# Core v5.2.7
**Release Date:** January 17, 2025  
**Tags:** BUG FIXES, ADMIN IMPROVEMENTS, FOREX ENHANCEMENTS, EXCHANGE FIXES, ECOSYSTEM IMPROVEMENTS, PATH FIXES

## Fixed
- Spot currency import button not displaying in admin panel after importing markets
- Admin page builder showing "something went wrong" error when editing home page
- Forex live account deposit and withdrawal buttons not working properly
- Admin support center chat viewing error when accessing ticket conversations
- Kucoin exchange orderbook data fetching failing due to invalid limit parameters
- Double await syntax error in Forex account API endpoint causing runtime failures
- TypeScript type error in support ticket agent assignment functionality
- Inconsistent currency selection type handling in Forex deposit store
- Admin menu extension hover causing "Cannot read properties of undefined (reading 'indexOf')" error
- Ecosystem custodial wallet creation failing due to smart contract file path resolution issues
- Ecosystem custodial wallet web interface not properly sending masterWalletId field
- Critical path resolution issues causing frontend file access to fail in production environment
- Upload endpoints using incorrect paths that would go outside public_html in production
- Media directory paths not respecting development vs production working directory differences

## Added
- Import currencies button to spot currency admin page with proper functionality
- Missing support ticket agent assignment API endpoint
- Comprehensive error handling for ecosystem custodial wallet creation
- Smart contract file path fallback system for ecosystem wallet deployment
- Enhanced debugging for custodial wallet creation process
- Environment-aware path resolution for all frontend file access operations

## Enhanced
- Mega menu panel error handling with comprehensive null checking and try-catch protection
- Smart contract file resolution with multiple path fallback options
- Custodial wallet creation error messages with more specific guidance
- Network configuration fallback for ecosystem wallets when environment variables are missing
- File upload system with proper development vs production path handling
- Documentation system with correct path resolution for all environments

## Technical Improvements
- Fixed syntax errors in Forex account API endpoint
- Improved type safety in support ticket assignment
- Enhanced error boundaries in admin menu components
- Better validation and error handling in ecosystem wallet deployment
- Corrected all file system paths to respect working directory differences between environments
- Standardized path resolution logic across upload, media, and documentation systems

## API Enhancements
- Added proper validation for custodial wallet creation requests
- Improved error responses with specific failure reasons
- Enhanced smart contract deployment with better error handling
- Added comprehensive logging for debugging wallet creation issues
- Fixed all frontend file access paths to work correctly in both development and production

## User Experience Improvements
- More descriptive error messages for custodial wallet creation failures
- Better visual feedback during wallet deployment process
- Improved admin menu stability during navigation
- Enhanced form validation feedback for ecosystem wallet creation
- Reliable file uploads and media handling across all environments

## Critical Path Fixes
- Upload endpoints now correctly resolve frontend paths in both development and production
- Logo upload functionality works properly regardless of deployment environment
- Media cache system correctly accesses frontend public directory
- FAQ page scanner properly locates Next.js app directory
- Documentation system finds swagger.json and docs-ui assets in correct locations

## API Enhancements
- Added `/api/admin/crm/support/ticket/[id]/assign` endpoint for agent management
- Fixed `/api/forex/account/[id]` endpoint syntax error
- Enhanced `/api/admin/content/page/[id]` endpoint field handling
- Improved exchange market WebSocket with provider-specific validations 