# Core v5.2.6
**Release Date:** January 17, 2025  
**Tags:** RECAPTCHA SYSTEM, SECURITY ENHANCEMENTS, API FIXES, BUG FIXES, AUTHENTICATION IMPROVEMENTS

## Fixed
- reCAPTCHA validation error "Recaptcha Token is required" in authentication endpoints
- Login form not generating reCAPTCHA tokens when reCAPTCHA is enabled
- Register form not generating reCAPTCHA tokens when reCAPTCHA is enabled
- Password reset form missing reCAPTCHA protection against abuse
- Incorrect environment variable name for reCAPTCHA secret key in backend
- Missing reCAPTCHA validation in register API endpoint
- Missing reCAPTCHA validation in password reset API endpoint
- Incorrect import statements for $fetch function across multiple components
- Forex dashboard deposit functionality failing due to missing reCAPTCHA tokens
- Authentication flows breaking when reCAPTCHA is enabled in environment
- Trading interface orderbook Recent Trades section color inconsistency in dark mode
- Admin URL retaining auth=false parameter after successful user authentication
- Page refresh keeping auth=false parameter even when user has valid admin permissions
- URL parameter persistence causing confusion in admin interface navigation
- Race conditions between middleware redirects and client-side URL cleanup
- Inconsistent URL parameter handling across different authentication flows

## Added
- Comprehensive reCAPTCHA token generation in login form with action-specific tokens
- Comprehensive reCAPTCHA token generation in register form with action-specific tokens
- Comprehensive reCAPTCHA token generation in forgot password form with action-specific tokens
- reCAPTCHA validation in register API endpoint with proper error handling
- reCAPTCHA validation in password reset API endpoint to prevent abuse
- Smart conditional reCAPTCHA logic based on environment variable configuration
- Graceful fallback handling when reCAPTCHA fails to load or is disabled
- User-friendly error messages for reCAPTCHA verification failures
- Action-specific reCAPTCHA tokens for better security (login, register, password_reset)
- Comprehensive URL parameter cleanup utility functions for authentication flows
- Smart permission-based URL cleanup for admin routes
- Loading state handling to prevent premature URL parameter cleanup
- Robust error handling for URL manipulation operations
- Client-side authentication state detection with permission validation

## Enhanced
- Authentication security with reCAPTCHA protection across all auth endpoints
- Error handling in authentication forms with proper reCAPTCHA integration
- User experience during reCAPTCHA token generation with loading states
- API endpoint validation with comprehensive reCAPTCHA verification
- Environment variable handling for reCAPTCHA configuration
- Backward compatibility for deployments with reCAPTCHA disabled
- Security against automated attacks on authentication endpoints
- Trading interface visual consistency with improved dark mode color scheme
- GlobalAuthDetector component with improved admin permission checking
- Authentication modal URL cleanup after successful login
- User experience by removing unnecessary URL parameters after authentication
- URL handling consistency across all authentication-related components
- Admin access flow with proper permission validation and URL cleanup

## Technical Improvements
- Fixed incorrect $fetch import statements from default import to named import
- Updated 15 files with incorrect $fetch imports across frontend components
- Corrected environment variable naming for reCAPTCHA secret key (removed NEXT_PUBLIC_ prefix)
- Added proper reCAPTCHA script loading and cleanup in authentication forms
- Implemented helper functions for reCAPTCHA-enabled authentication flows
- Enhanced error handling patterns across all authentication components
- Standardized reCAPTCHA token generation with consistent action naming
- Improved API endpoint schemas to conditionally require reCAPTCHA tokens
- Added comprehensive validation for reCAPTCHA environment variables
- Enhanced security messaging and user feedback during authentication processes
- Created cleanupAuthParams utility function for flexible URL parameter removal
- Added cleanupAuthFalseParam function specifically for auth=false parameter cleanup
- Added hasAuthFalseParam function to check current URL state
- Enhanced GlobalAuthDetector with user loading state awareness
- Improved auth modal handleSuccess function with utility integration
- Added permission-aware URL cleanup logic for admin routes
- Implemented proper race condition prevention in authentication flows
- Enhanced middleware and client-side coordination for URL parameter management

## Security Notes
- reCAPTCHA is now properly enforced on all authentication endpoints when enabled
- Prevents automated attacks on login, registration, and password reset endpoints
- Action-specific tokens provide better protection against replay attacks
- Graceful degradation ensures functionality when reCAPTCHA is disabled
- Comprehensive error handling prevents information disclosure through error messages

## User Experience Improvements
- Admin URLs now automatically clean up after successful authentication
- No more persistent auth=false parameters after login
- Smoother navigation experience in admin interface
- Consistent URL appearance across all authenticated admin pages
- Better visual feedback during authentication state transitions 