# Core v5.2.2
**Release Date:** January 2025  
**Tags:** BUG FIXES, PERFORMANCE, SECURITY

## Fixed

- **Static File Path Resolution** - Fixed backend static file serving path resolution logic to properly handle production environments where the working directory structure differs from development
- **Upload File Serving** - Enhanced path detection for uploads directory to support multiple deployment scenarios (root directory, backend subdirectory, direct public folder)
- **CORS Headers for Static Files** - Added proper CORS headers to static file responses to prevent cross-origin request issues in production
- **Production Proxy Configuration** - Improved Next.js proxy configuration to handle backend URL resolution in production environments with flexible backend host detection
- **Static File Debug Logging** - Added comprehensive debug logging for static file serving to help diagnose production path resolution issues (enabled with DEBUG_STATIC_FILES=true)
- **Path Sanitization** - Enhanced security with proper leading slash handling and path sanitization for static file requests
- **Market Symbol Validation** - Fixed WebSocket market data handlers to validate symbols against database before attempting to fetch data from exchanges, preventing BadSymbol errors for non-existent or disabled markets
- **Exchange Market Filtering** - Added database validation to ensure only admin-enabled markets can be subscribed to via WebSocket connections
- **Futures Market Validation** - Enhanced futures market WebSocket handler to validate symbols against futuresMarket table before processing subscriptions
- **Ecosystem Market Validation** - Added symbol validation to ecosystem market WebSocket handler to prevent invalid market subscriptions
- **Support Ticket 502 Error Fix** - Enhanced error handling in support ticket API endpoint to prevent 502 Bad Gateway errors caused by corrupted JSON data in messages or tags fields
- **Support Ticket JSON Handling** - Improved robustness of JSON field parsing in support ticket model with comprehensive error logging and fallback mechanisms
- **API Error Toast Fix** - Fixed $fetch function to properly show error toasts for responses containing statusCode fields (e.g., {"message":"API call failed.","statusCode":500})
- **Error Response Handling** - Enhanced error detection in API responses by properly converting string statusCodes to numbers for comparison
- **Extension License Activation** - Fixed license activation failing with empty productId by creating extension-specific license verification component that properly uses extension store
- **Production Proxy Configuration** - Fixed upload file serving in production by reverting to v4-style localhost proxy configuration instead of external domain proxy
- **Themes Support Removal** - Removed deprecated /themes/ path handling from both frontend proxy and backend static file serving
- **Static File Path Validation** - Fixed overly strict path sanitization that was incorrectly blocking legitimate upload file requests with "Path traversal detected" error

## Enhanced

- **Multi-path Detection** - Backend now tries multiple possible paths to locate the uploads directory, ensuring compatibility across different deployment configurations
- **Environment Variable Support** - Added support for BACKEND_HOST and NEXT_PUBLIC_BACKEND_HOST environment variables for flexible backend URL configuration in production
- **Error Handling** - Improved error handling and logging for static file serving with better debugging information
- **Market Security** - Strengthened market data access control by ensuring only database-approved and enabled markets can be accessed via WebSocket subscriptions
- **WebSocket Validation** - Enhanced all market WebSocket handlers with comprehensive symbol format validation and database existence checks
- **Support Ticket Reliability** - Strengthened support ticket data retrieval with graceful error handling for corrupted or invalid JSON data, preventing system crashes
- **API Error Feedback** - Improved user experience by ensuring all API errors with statusCode fields are properly displayed as toast notifications to users
- **Debug Logging** - Added comprehensive debug logging for API error handling to help diagnose toast notification issues in development
- **License Activation Validation** - Enhanced license activation API endpoint with better validation and debug logging to help diagnose missing parameter issues 