# Version 5.1.7
**Release Date:** June 25, 2025  
**Tags:** MAJOR IMPROVEMENTS, CRITICAL FIXES, SECURITY ENHANCEMENTS

## Fixed

### Security & File System Enhancements
- **Static File Serving Path Fix**: Corrected static file serving to properly serve from `/frontend/public/` directory in both development and production environments
- **Path Traversal Protection**: Enhanced existing static file serving with comprehensive path sanitization to prevent directory traversal attacks
- **File Type Security**: Implemented whitelisting of allowed MIME types and file extensions for all upload and static file operations
- **File Size Limits**: Enforced 10MB maximum file size limit with proper validation for all upload endpoints
- **Directory Security**: Enhanced validation to ensure uploaded files remain within designated upload directories
- **Security Headers**: Added comprehensive security headers for static file serving including CSP and XSS protection
- **Input Sanitization**: Implemented multi-layer validation for all user-provided paths and file data

### KYC Level Service Integration
- **Foreign Key Constraint Fix**: Fixed KYC level creation/update failing with foreign key constraint error when invalid serviceId is provided
- **Service Validation**: Added comprehensive validation for KYC verification service IDs with proper error messaging
- **Service ID Cleanup**: Enhanced frontend to properly handle empty or invalid service IDs before sending to backend
- **Gemini Service ID**: Corrected Gemini service ID reference from "gemini-1" to "gemini-1.5-pro" in verification services view
- **Service Seeder**: Updated KYC services seeder to include Gemini service with correct ID "gemini-1.5-pro"

### WebSocket Market Data System Overhaul
- **Unified Market Data Architecture**: Fixed WebSocket endpoints to send all requested data types (trades, orderbook, OHLCV) simultaneously instead of only one type
- **Stream Key Generation**: Fixed WebSocket stream key generation to match frontend expectations by removing limit values from trades and OHLCV keys
- **Payload Structure**: Fixed WebSocket payload structure to match frontend subscription format with consistent field order (type, limit, interval, symbol)
- **OrderBook Panel System**: Fixed OrderBookPanel WebSocket subscription timing issue where subscriptions were not being sent for orderbook and trades data
- **Subscription Management**: Enhanced unified market data subscription to properly handle multiple data types added after initial subscription
- **Critical Stream Key Mismatch**: Fixed critical stream key mismatch between frontend and backend for orderbook subscriptions
- **Race Condition Fix**: Fixed race condition in WebSocket subscription management that caused "Cannot read properties of undefined (reading 'add')" errors
- **TypeScript Compilation**: Fixed TypeScript compilation errors with correct import paths for ExchangeManager and exchange utilities

### OrderBook & Market Data Visualization
- **OrderBook Depth Visualization**: Fixed orderbook depth bar visualization to use individual order amounts instead of cumulative volume for proper depth representation
- **OrderBook Loading State**: Fixed orderbook panel stuck in loading state by removing strict symbol validation for orderbook and ticker data
- **Data Processing**: Enhanced orderbook data processing to add missing symbol and timestamp properties when not present
- **Markets Panel Live Updates**: Fixed markets panel in `/trade` page not updating prices in real-time when receiving ticker WebSocket messages
- **Ticker Data Lookup**: Enhanced ticker data matching to support multiple key formats (`CURRENCY/PAIR`, `CURRENCYPAIR`, `symbol`, `displaySymbol`) for better data consistency

### Chart System Improvements
- **Chart Loading Order**: Fixed chart loading before settings initialization, preventing double-loading where default chart loads first then switches to TradingView based on user settings
- **Settings-Dependent Loading**: Chart switcher now waits for settings to be fetched before loading any chart component
- **Performance Optimization**: Optimized chart loading sequence to prevent unnecessary re-renders and improve user experience

### Trading Interface Enhancements
- **Trading Header Cleanup**: Removed unnecessary 2h high display from trading header to reduce visual clutter and simplified desktop additional info section to show only 24h volume
- **Live Markets Duplicates**: Fixed live markets widget on home page showing duplicate coins by grouping markets by base currency and selecting highest volume pair

### Performance & User Experience
- **Wallet Stats Performance**: Implemented 1-hour caching for failed price fetches to prevent repeated API calls for currencies that can't be priced, reducing endpoint response time from 815ms to under 200ms
- **Price Fetch Optimization**: Added intelligent failure caching that skips price fetching for currencies that recently failed, significantly improving wallet statistics loading performance
- **WebSocket Connection Logs**: Removed unnecessary console.log statements from WebSocket connections to clean up browser console

### UI/UX Improvements
- **Withdrawal Page Validation**: Fixed translation strings and improved error messaging for wallet selection with proper currency display outside translation functions
- **Withdrawal User Experience**: Enhanced warning messages to show specific information about unavailable wallets and currencies with better user guidance
- **Notification Settings Modal**: Fixed settings cog in notification header to properly open modal instead of navigation

## Enhanced

### Advanced Market Data Architecture
- **Unified Market Data Handlers**: Created UnifiedMarketDataHandler for spot markets with parallel data fetching for ticker, OHLCV, trades, and orderbook
- **Futures Market Integration**: Implemented UnifiedFuturesMarketDataHandler with coordinated data streaming for all futures market data types
- **Ecosystem Market Support**: Added UnifiedEcosystemMarketDataHandler for ecosystem markets with synchronized multi-stream data delivery
- **Subscription Lifecycle Management**: Added proper subscription lifecycle management with automatic cleanup and resource management
- **Data Fetching Optimization**: Improved data fetching intervals and error handling for more reliable real-time market data

### Real-time Market Data Features
- **Market Data Synchronization**: Enhanced market data synchronization across all trading interfaces
- **Advanced Market Data Feature**: Active market now receives high-frequency ticker updates from market data WebSocket while other markets use standard ticker updates for optimal performance
- **Automatic Subscription Switching**: Market data WebSocket automatically switches subscriptions when changing active markets
- **Simplified Integration**: Implemented simplified market data WebSocket integration using same approach as trading header for consistent fast ticker updates on active markets

### Data Processing Improvements
- **Ticker Priority System**: Improved ticker data processing with eco tickers having higher priority over spot tickers
- **WebSocket State Management**: Enhanced WebSocket state management during component re-renders and hot reloads
- **Ticker Key Format Consistency**: Improved ticker key format consistency across WebSocket connections

### Development & Workflow Enhancements
- **Path Validation**: Implemented comprehensive path sanitization with separate validation for system paths vs user input paths
- **File Upload Security**: Added strict whitelisting of allowed file extensions and MIME types for all upload endpoints
- **Directory Security**: Enhanced directory validation to prevent access outside designated upload areas
- **Security Headers**: Added comprehensive security headers for dynamically served files including CSP and XSS protection 