# Version 5.1.4
**Release Date:** June 24, 2025  
**Tags:** MOBILE IMPROVEMENTS, TRADING INTERFACE

## Enhanced

### Mobile Order Book Experience
- **Auto-Scroll Feature**: Added automatic scrolling of asks section to bottom on mobile to show the best ask price (lowest price) by default
- **Redesigned Layout**: Redesigned mobile order book layout with asks above, ticker price in the middle, and bids below
- **Enhanced Display**: Increased mobile orderbook display from 8 to 15 items to match desktop functionality
- **Improved Touch Interactions**: Enhanced mobile touch interactions with larger touch targets and better spacing
- **Responsive Design**: Added responsive design that automatically detects mobile view and applies optimized layout

## Fixed

### Mobile Order Book Issues
- **Scrolling Problems**: Fixed scrolling issue where orderbook items were cut off and couldn't be scrolled properly
- **Depth Bar Positioning**: Fixed asks depth bar positioning to be on the right side like bids (was incorrectly on left side)
- **Visual Improvements**: Added proper scrollbar styling and min-height constraints for better scrolling experience
- **Change Percentage Display**: Removed change percentage from the orderbook ticker display to keep it clean and focused

### Trading Header System
- **Infinite Loop Fix**: Fixed issue where trading header would show a number briefly, then "Loading..." and keep looping infinitely
- **Mobile Ticker Display**: Fixed issue where the header ticker on mobile trade page didn't update when switching markets and stayed on "Loading..."
- **Price Change Calculation**: Fixed incorrect price change display in trading header where absolute change value was being treated as percentage
- **Debug Cleanup**: Removed unnecessary console.log statements from TradingHeader component to clean up debug output
- **Market Type Integration**: Added marketType prop to TradingHeader component calls in TradingLayout for both mobile and desktop views

### Mobile Trade Interface
- **Market Selection Fix**: Fixed issue where clicking on a market in the mobile markets tab would sort by symbol instead of selecting the clicked market
- **Binary Trading WebSocket**: Fixed issue where binary trading was duplicating trades when users navigated to other sections during an open trade
- **Subscription Management**: Enhanced WebSocket cleanup and subscription management with proper lifecycle handling during navigation

### Technical Improvements
- **Dependency Management**: Fixed useEffect dependency arrays to prevent unnecessary re-renders and subscription loops
- **WebSocket Cleanup**: Implemented proper cleanup of WebSocket subscriptions during page changes and navigation
- **State Management**: Added market switching state management to prevent race conditions during symbol changes 