# Version 5.1.1
**Release Date:** June 22, 2025  
**Tags:** ADMIN IMPROVEMENTS, SETTINGS SYSTEM

## Fixed

### Admin Settings File Upload System
- **File Upload Support**: Fixed admin settings page file upload functionality for logos and other image settings
- **Multiple Logo Types**: Added support for multiple logo types (logo, darkLogo, fullLogo, cardLogo, favicons, etc.)
- **Size Constraints**: Each file type is processed with proper size constraints from field definitions (e.g., logo: 96x96px, fullLogo: 350x75px)
- **Parallel Processing**: File uploads are processed using Promise.all for parallel uploads with comprehensive error handling
- **File Replacement**: Old file paths are passed for replacement when updating existing logos

### Admin Settings Display System
- **Values Display Fix**: Fixed admin settings page not showing actual setting values in form fields
- **Data Source Correction**: Changed settings page to use `configSettings` from useConfigStore instead of raw API response
- **Settings Initialization**: Optimized settings initialization to prevent multiple fetches and duplicate effect triggers
- **Data Validation**: Added validation in frontend to only send clean, defined settings from FIELD_DEFINITIONS
- **Backend Validation**: Enhanced backend validation to prevent storing invalid serialized objects

## Enhanced

### Settings Management
- **Form Integration**: Improved form field population with actual saved values from database
- **Error Handling**: Enhanced error handling for failed uploads and validation issues
- **Performance**: Reduced multiple API calls during settings page initialization
- **Data Integrity**: Ensured UI reflects what was actually saved to database, not just local draft values

### Admin Settings File Upload Support
- **Root Cause**: File uploads were being skipped during save - File objects were detected but not processed, causing uploaded images to not be saved
- **Solution**: 
  - Implemented proper file upload handling using imageUploader utility before saving settings
  - Added support for multiple logo types (logo, darkLogo, fullLogo, cardLogo, favicons, etc.)
  - Each file type is processed separately with proper size constraints from field definitions
  - Uploaded file URLs are included in the final settings payload
- **Technical Details**: 
  - File uploads are processed first using Promise.all for parallel uploads
  - Each file upload uses proper size constraints from FIELD_DEFINITIONS (e.g., logo: 96x96px, fullLogo: 350x75px)
  - Old file paths are passed for replacement when updating existing logos
  - File URLs are properly included in clean payload alongside other settings
  - Added comprehensive error handling for failed uploads
- **Files Modified**: frontend/app/[locale]/(dashboard)/admin/system/settings/page.tsx
- **API Endpoints Used**: POST /api/upload

### Admin Settings Page Values Not Displaying
- **Root Cause**: Settings page was using wrong data source - raw API response instead of parsed settings from config store
- **Solution**: 
  - Changed settings page to use `configSettings` from useConfigStore instead of `globalSettings` from useSettings hook
  - Fixed data source mismatch where useSettings processes settings correctly but page was using unprocessed API response
  - Optimized settings initialization to prevent multiple fetches and duplicate effect triggers
- **Technical Details**: 
  - Frontend now properly uses parsed settings object `{themeSwitcher: 'true', deposit: 'true', ...}` instead of raw API response `{settings: Array(111), extensions: Array(15)}`
  - Added validation in frontend to only send clean, defined settings from FIELD_DEFINITIONS
  - Enhanced useSettings hook to filter out problematic settings during fetch
  - Added backend validation to prevent storing invalid serialized objects
  - Fixed multiple settings fetch calls on page load
- **Files Modified**: 
  - frontend/app/[locale]/(dashboard)/admin/system/settings/page.tsx
  - frontend/hooks/use-settings.ts
  - backend/src/api/admin/system/settings/index.put.ts
- **API Endpoints Changed**: PUT /api/admin/system/settings 