<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\FlexApi\V2;

use Twilio\Options;
use Twilio\Values;

abstract class FlexUserOptions
{

    /**
     * @param string $firstName First name of the User.
     * @param string $lastName Last name of the User.
     * @param string $email Email of the User.
     * @param string $friendlyName Friendly name of the User.
     * @param string $userSid The unique SID identifier of the Twilio Unified User.
     * @param string $locale The locale preference of the user.
     * @return UpdateFlexUserOptions Options builder
     */
    public static function update(
        
        string $firstName = Values::NONE,
        string $lastName = Values::NONE,
        string $email = Values::NONE,
        string $friendlyName = Values::NONE,
        string $userSid = Values::NONE,
        string $locale = Values::NONE

    ): UpdateFlexUserOptions
    {
        return new UpdateFlexUserOptions(
            $firstName,
            $lastName,
            $email,
            $friendlyName,
            $userSid,
            $locale
        );
    }

}


class UpdateFlexUserOptions extends Options
    {
    /**
     * @param string $firstName First name of the User.
     * @param string $lastName Last name of the User.
     * @param string $email Email of the User.
     * @param string $friendlyName Friendly name of the User.
     * @param string $userSid The unique SID identifier of the Twilio Unified User.
     * @param string $locale The locale preference of the user.
     */
    public function __construct(
        
        string $firstName = Values::NONE,
        string $lastName = Values::NONE,
        string $email = Values::NONE,
        string $friendlyName = Values::NONE,
        string $userSid = Values::NONE,
        string $locale = Values::NONE

    ) {
        $this->options['firstName'] = $firstName;
        $this->options['lastName'] = $lastName;
        $this->options['email'] = $email;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['userSid'] = $userSid;
        $this->options['locale'] = $locale;
    }

    /**
     * First name of the User.
     *
     * @param string $firstName First name of the User.
     * @return $this Fluent Builder
     */
    public function setFirstName(string $firstName): self
    {
        $this->options['firstName'] = $firstName;
        return $this;
    }

    /**
     * Last name of the User.
     *
     * @param string $lastName Last name of the User.
     * @return $this Fluent Builder
     */
    public function setLastName(string $lastName): self
    {
        $this->options['lastName'] = $lastName;
        return $this;
    }

    /**
     * Email of the User.
     *
     * @param string $email Email of the User.
     * @return $this Fluent Builder
     */
    public function setEmail(string $email): self
    {
        $this->options['email'] = $email;
        return $this;
    }

    /**
     * Friendly name of the User.
     *
     * @param string $friendlyName Friendly name of the User.
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The unique SID identifier of the Twilio Unified User.
     *
     * @param string $userSid The unique SID identifier of the Twilio Unified User.
     * @return $this Fluent Builder
     */
    public function setUserSid(string $userSid): self
    {
        $this->options['userSid'] = $userSid;
        return $this;
    }

    /**
     * The locale preference of the user.
     *
     * @param string $locale The locale preference of the user.
     * @return $this Fluent Builder
     */
    public function setLocale(string $locale): self
    {
        $this->options['locale'] = $locale;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V2.UpdateFlexUserOptions ' . $options . ']';
    }
}

