<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PaymentGateway\PayPalController;
use App\Http\Controllers\PaymentGateway\StripePaymentController;
use App\Http\Controllers\PaymentGateway\PaytmController;
use App\Http\Controllers\PaymentGateway\FlutterwaveController;
use App\Http\Controllers\PaymentGateway\InstamojoController;
use App\Http\Controllers\PaymentGateway\PaystackController;
use App\Http\Controllers\PaymentGateway\PhonePeController;
use App\Http\Controllers\PaymentGateway\RazorpayController;
use App\Http\Controllers\PaymentGateway\LiqPayController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SiteController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;


// ==============================Payment Gateway Route============================
    Route::get('instamojo', [InstamojoController::class, 'index']);
    Route::post('instamojo-pay', [InstamojoController::class, 'instamojoPay'])->name('instamojo.make.payment');
    Route::get('instamojo-success', [InstamojoController::class, 'instamojoSuccess'])->name('instamojo.success.payment');
    Route::get('instamojo-wallet-success', [InstamojoController::class, 'instamojoWalletSuccess'])->name('instamojo-wallet.success.payment');

    Route::get('phonepe-form',[PhonePeController::class,'index']);
    Route::post('phonepe',[PhonePeController::class,'phonePe']);
    Route::any('phonepe/success',[PhonePeController::class,'success'])->name('phonepe.success.payment');
    Route::post('phonepe-wallet',[PhonePeController::class,'walletPayment']);
    Route::any('phonepe-wallet/success',[PhonePeController::class,'walletSuccess'])->name('phonepe-wallet.success.payment');

    Route::get('/paystack-form', [PaystackController::class, 'index'])->name('paystack-form');
    Route::post('/paystack/payment/{orderId}/{orderPostData}', [PaystackController::class, 'payment']);
    Route::get('/paystack/success', [PaystackController::class, 'success'])->name('paystack.success');
    Route::post('/paystack-wallet/payment/{payment_id}', [PaystackController::class, 'walletPayment']);


    Route::get('/initiate', [PaytmController::class, 'initiate'])->name('initiate.payment');
    Route::post('/paytm-payment', [PaytmController::class, 'paymentMethod'])->name('make.payment');
    Route::post('/payment/status', [PaytmController::class, 'paymentCallback'])->name('status');


    Route::get('paypal/payment/success/', [PayPalController::class, 'paymentSuccess'])->name('paypal.payment.success');
    Route::get('paypal/payment/cancel', [PayPalController::class, 'paymentCancel'])->name('paypal.payment.cancel');
    Route::get('paypal-wallet/payment/success/', [PayPalController::class, 'walletPaymentSuccess'])->name('paypal-wallet.payment.success');
    Route::get('paypal-wallet/payment/cancel', [PayPalController::class, 'walletPaymentCancel'])->name('paypal-wallet.payment.cancel');
    Route::get('paypal-wallet.payment/cancel', [PayPalController::class, 'walletPaymentCancel'])->name('paypal-wallet.payment/cancel');
    

    Route::controller(StripePaymentController::class)->group(function(){
        Route::get('stripe', 'stripe');
        Route::get('stripe', 'payment')->name('stripe.post');
        Route::get('/stripe/success', 'success')->name('stripe.success');

    });

    Route::controller(FlutterwaveController::class)->group(function(){
        Route::get('flutterwave/success', 'success')->name('flutterwave.success');
        Route::get('flutterwave-wallet/success', 'walletSuccess')->name('flutterwave-wallet.success');
    });

    Route::get('/razoarpay/success', [RazorpayController::class, 'payment'])->name('razoarpay.success');
    Route::get('/razoarpay-walllet/success', [RazorpayController::class, 'walletPayment'])->name('razoarpay-wallet.success');


    Route::post('liqpay/create-payment', [LiqPayController::class, 'createPayment'])->name('liqpay.create');
    Route::post('liqpay/callback', [LiqPayController::class, 'handleCallback'])->name('liqpay.callback');
    Route::post('liqpay/server-callback', [LiqPayController::class, 'handleCallback'])->name('liqpay.server.callback');

    // ===================Payment Gateway Route End Here==============


    // ===========================Default Route Here=====================
    Route::post('/verify-login-user-details', 'App\Http\Controllers\SiteController@verifyUser')->name('authUserVerify');
    Route::post('/save-login-user-details', 'App\Http\Controllers\SiteController@saveUserDetails');
    Route::post('/fcm-token', 'App\Http\Controllers\SiteController@updateToken')->name('fcmToken');

    Route::get('/firebase-config', function () {
        return response()->json([
            'apiKey' => setting('firebase_api_key', ''),
            'authDomain' => setting('firebase_auth_domain', ''),
            'projectId' => setting('firebase_project_id', ''),
            'storageBucket' => setting('firebase_storage_bucket', ''),
            'messagingSenderId' => setting('firebase_messaging_sender_id', ''),
            'appId' => setting('firebase_app_id', ''),
            'measurementId' => setting('firebase_measurement_id', ''),
            'vapidKey' => setting('firebase_messaging_vapid_publickey', ''),
        ]);
    });

    Route::post('/send-notification', [NotificationController::class, 'sendNotification'])->name('send-notification');

// =================Default Route End Here================================


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

    Route::get('clear', function() {
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        Artisan::call('config:cache');
        Artisan::call('view:clear');
        return "Cleared!";
    });
    
    // Route for migrate
    Route::get('/execute-queries', function() {
        Artisan::call('migrate', ['--force' => true]);
        Artisan::call('db:seed', ['--class' => 'DatabaseSeeder', '--force' => true]);
        return "Migration run successfully";
    });

    

    Route::get('/update-application', function() {
        Artisan::call('schedule:run');
        return "Scheduler runs successfully.";
    });

    Route::get('/share-product', 'App\Http\Controllers\ShareController@share');
    Route::get('/check_keywords', 'App\Http\Controllers\DashboardController@check_keywords');

    // The callback url after a payment
    Route::get('products/get-product-details', [ProductController::class, 'getProductDetails']);

    Route::middleware('checkauth:web')->group(function () {
        Route::get('/signin', 'App\Http\Controllers\SiteController@signin');
        Route::post('/verify-otp', 'App\Http\Controllers\UserController@doVerifyOtp');
        Route::get('/signup', 'App\Http\Controllers\SiteController@signup');

        Route::get('/admin-forget-password','App\Http\Controllers\Auth\ForgotPasswordController@forgetPassword')->middleware(['check.app.installation','check.app.code_verified']);

        Route::get('email-verification-for-password', 'App\Http\Controllers\Auth\ForgotPasswordController@emailVerificationForPassword')->name('email-verification-for-password');

        Route::post('do-admin-reset-password', 'App\Http\Controllers\Auth\ForgotPasswordController@resetPasswordPost');
    });


    Route::middleware('language:web')->group(function () {
        Route::get('/', 'App\Http\Controllers\SiteController@index')->middleware(['check.app.installation','check.app.code_verified']);

        Route::get('/update-website','App\Http\Controllers\UpdateApplicationController@updateWebsite');

        Route::get('/licenses-verify', 'App\Http\Controllers\LicenseController@index')->name('license.verify')->middleware('check.app.installation');

        Route::post('/licenses-verify', 'App\Http\Controllers\LicenseController@verify')->name('license.verify')->middleware('check.app.installation');

        Route::get('/contact-us', 'App\Http\Controllers\SiteController@contact');
        Route::post('/contact-us', 'App\Http\Controllers\SiteController@doSubmitContactUs');
        Route::get('/privacy-policy', 'App\Http\Controllers\SiteController@privacyPolicy');
        Route::get('/term-and-conditions', 'App\Http\Controllers\SiteController@termsAndCondition');
        Route::get('/about', 'App\Http\Controllers\SiteController@about');
        Route::get('/account-delete', 'App\Http\Controllers\SiteController@accountDelete');
    });

    Route::middleware('siteauth:web')->group(function () {
        Route::get('/cart', 'App\Http\Controllers\SiteController@cart');
        Route::get('/add-to-cart', 'App\Http\Controllers\SiteController@addToCart');
        Route::get('/delete-cart-item/{id}', 'App\Http\Controllers\SiteController@deleteCartitem');
        Route::post('/cart-checkout', 'App\Http\Controllers\SiteController@doCheckout');
        Route::get('/apply-coupon', 'App\Http\Controllers\SiteController@applyCoupon');
        Route::get('/checkout', 'App\Http\Controllers\SiteController@checkout');
        Route::get('/place-order', 'App\Http\Controllers\SiteController@placeOrder');
        Route::post('/do-place-order', 'App\Http\Controllers\SiteController@doPlaceOrder');
        Route::post('/save-token', 'App\Http\Controllers\SiteController@saveToken')->name('stripeToken');
        Route::get('/do-online-payment/{id}', 'App\Http\Controllers\SiteController@doOnlinePayment');
        Route::get('/do-confirm-payment/{id}', 'App\Http\Controllers\SiteController@doConfirmPayment');
        Route::get('/check-update-cart', 'App\Http\Controllers\SiteController@checkUpdateUserCart')->name('check.update.cart');
        Route::get('/profile', 'App\Http\Controllers\SiteController@profile');
        Route::get('/orders', 'App\Http\Controllers\SiteController@orders')->name('orders.show');
        Route::get('/order-details/{id}', 'App\Http\Controllers\SiteController@orderDetail');
        Route::get('/cancel-order-request/{id}', 'App\Http\Controllers\SiteController@cancelOrderRequest');
        Route::post('/user-logout', 'App\Http\Controllers\SiteController@userLogout');
        Route::post('/update-profile', 'App\Http\Controllers\SiteController@updateProfile');
        Route::post('/add-card', 'App\Http\Controllers\SiteController@addCard');
        Route::post('/get-city-state-by-zipcode', 'App\Http\Controllers\SiteController@getCityStateByZipcode');
        Route::get('/get-zip-codes', 'App\Http\Controllers\SiteController@getZipCodes')->name('getZipCodes');
        Route::get('/addresses', 'App\Http\Controllers\SiteController@addresses');
        Route::get('/delete-address/{address_id}', 'App\Http\Controllers\SiteController@deleteMyAddress');
        Route::post('/add-address', 'App\Http\Controllers\SiteController@addUpdateAddress');
        Route::post('/validate-address', 'App\Http\Controllers\SiteController@validateAddress')->name('validateAddress');
        Route::get('/wallet', 'App\Http\Controllers\SiteController@wallet');
        Route::match(['get', 'post'], '/wallet-checkout', [SiteController::class, 'handleCheckout'])->name('wallet.checkout');
        Route::post('/wallet-payment-confirm', 'App\Http\Controllers\SiteController@doConfirmWalletPayment');
        Route::post('/save-token-wallet', 'App\Http\Controllers\SiteController@saveTokenWallet'); /* for stripe */
    });

        Route::get('/set-language', 'App\Http\Controllers\SiteController@setLanguage');

        Route::post('/verify-login-user-details', 'App\Http\Controllers\SiteController@verifyUser');
        Route::post('/save-login-user-details', 'App\Http\Controllers\SiteController@saveUserDetails');
        
    /*
    Admin ROUTES
    */
    Route::middleware('admin-language:web')->group(function () {
        Route::get('/admin','App\Http\Controllers\Auth\LoginController@getLoginView');
        Route::get('/admin-login','App\Http\Controllers\Auth\LoginController@getLoginView')->middleware(['check.app.installation','check.app.code_verified']);

        Route::post('do-login', 'App\Http\Controllers\Auth\LoginController@authenticate');


    Route::middleware('auth')->group(function () {
        Route::post('users/store', 'App\Http\Controllers\UserController@store')->name('users.create');

        Route::get('users/profile', 'App\Http\Controllers\UserController@profile')->name('users.profile');

    Route::prefix('admin','check.app.installation','check.app.code_verified')->group(function () {
        Route::get('/setlang', 'App\Http\Controllers\AppSettingController@setLanguage');
        Route::get('dashboard', 'App\Http\Controllers\DashboardController@index')->name('dashboard');
        Route::get('/', 'App\Http\Controllers\DashboardController@index')->name('dashboard');


        /************** Update Application Routing Starts Here *****************/
        Route::get('/check-update','App\Http\Controllers\UpdateApplicationController@index');
        /************** Update Application Routing Starts Here *****************/


        /************************* Role Routing Starts Here **************************/

    Route::middleware(['permission','check.app.installation','check.app.code_verified'])->group(function () {

        Route::get('/role', 'App\Http\Controllers\RoleController@index');
        Route::post('/role', 'App\Http\Controllers\RoleController@index');
        Route::post('/add-role', 'App\Http\Controllers\RoleController@store');
        Route::post('/update-role', 'App\Http\Controllers\RoleController@update');
        Route::get('role-destroy/{id}', 'App\Http\Controllers\RoleController@destroy')->name('role.destroy');
        Route::get('/update-role-status/{id}/{value}', 'App\Http\Controllers\RoleController@updateColumn');


        Route::get('/sub-admin', 'App\Http\Controllers\SubAdminController@index')->name('sub-admin.index');
        Route::post('/sub-admin', 'App\Http\Controllers\SubAdminController@index');
        Route::post('/add-sub-admin', 'App\Http\Controllers\SubAdminController@store');
        Route::get('subadmin-edit/{id}', 'App\Http\Controllers\SubAdminController@edit')->name('subadmin.edit');
        Route::post('/update-sub-admin', 'App\Http\Controllers\SubAdminController@update')->name('update-sub-admin');
        Route::get('subadmin-destroy/{id}', 'App\Http\Controllers\SubAdminController@destroy')->name('subadmin.destroy');
        Route::get('/update-sub-admin-status/{id}', 'App\Http\Controllers\SubAdminController@updateColumn');
    });

        /************************* Role End Here **************************/

    Route::resource('users', App\Http\Controllers\UserController::class);
        Route::get('user-destroy/{id}', 'App\Http\Controllers\UserController@destroy')->name('user.destroy');
        Route::get('change-user-status/{id}', 'App\Http\Controllers\UserController@changeStatus');
        Route::get('users/wallet/{id}', 'App\Http\Controllers\UserController@userWalletLists');
        Route::post('users/wallet/transaction/{id}', 'App\Http\Controllers\UserController@doSubmituserWallet');
        Route::get('users/addresses/{id}', 'App\Http\Controllers\UserController@userAddresses');

        Route::resource('drivers', App\Http\Controllers\DriverController::class);
        Route::get('driver-destroy/{id}', 'App\Http\Controllers\DriverController@destroy')->name('driver.destroy');
        Route::get('change-driver-status/{id}', 'App\Http\Controllers\DriverController@changeStatus');

        Route::resource('products', App\Http\Controllers\ProductController::class);
        Route::get('product-add', 'App\Http\Controllers\ProductController@addProduct');
        Route::post('products/store', 'App\Http\Controllers\ProductController@store')->name('products.create');
        Route::get('products-destroy/{id}', 'App\Http\Controllers\ProductController@destroy')->name('products.destroy');
        Route::get('change-product-status/{id}', 'App\Http\Controllers\ProductController@changeStatus');
        Route::get('products/translation/{id}', 'App\Http\Controllers\ProductController@translation');
        Route::post('products/translation/{id}', 'App\Http\Controllers\ProductController@updateTranslation');



        Route::resource('banners', App\Http\Controllers\BannerController::class);
        Route::get('banner-destroy/{id}', 'App\Http\Controllers\BannerController@destroy')->name('banner.destroy');
        Route::get('change-banner-status/{id}', 'App\Http\Controllers\BannerController@changeStatus');
        Route::get('banners/translation/{id}', 'App\Http\Controllers\BannerController@translation');
        Route::post('banners/translation/{id}', 'App\Http\Controllers\BannerController@updateTranslation');


        Route::resource('orders', App\Http\Controllers\OrderController::class);
        Route::get('orders-destroy/{id}', 'App\Http\Controllers\OrderController@destroy')->name('orders.destroy');
        Route::get('cancel-order-request', 'App\Http\Controllers\OrderController@cancelOrderRequest');
        Route::get('declined-order-request/{id}', 'App\Http\Controllers\OrderController@declinedOrderRequest');
        Route::get('approved-order-request/{id}', 'App\Http\Controllers\OrderController@approvedOrderRequest');
        Route::get('revenue', 'App\Http\Controllers\OrderController@revenue');
        Route::get('delivery', 'App\Http\Controllers\OrderController@delivery');
        Route::post('update-delivery-status','App\Http\Controllers\OrderController@updateOrderDeliveryStatus');
        Route::post('assign-driver','App\Http\Controllers\OrderController@assignDriverForDeliver');
        Route::post('bulk-assign-driver','App\Http\Controllers\OrderController@bulkAssignDriverForDeliver');
        Route::get('subscription', 'App\Http\Controllers\OrderController@activeSubscription');
        Route::get('export', 'App\Http\Controllers\OrderController@export')->name('export.orders');
        Route::get('/export-to-pdf', 'App\Http\Controllers\OrderController@exportToPdf');
        Route::get('export-revenue-to-excel', 'App\Http\Controllers\OrderController@exportRevenueReportToExcel')->name('export.revenue');
        Route::get('export-revenue-to-pdf', 'App\Http\Controllers\OrderController@exportRevenueReportToPdf');

        Route::resource('coupons', App\Http\Controllers\CouponController::class);
        Route::get('coupon-destroy/{id}', 'App\Http\Controllers\CouponController@destroy')->name('coupon.destroy');
        Route::get('change-coupon-status/{id}', 'App\Http\Controllers\CouponController@changeStatus');
        Route::post('coupons/translation/{id}', 'App\Http\Controllers\CouponController@updateTranslation');
        Route::get('coupons/translation/{id}', 'App\Http\Controllers\CouponController@translation');

        Route::resource('payments', App\Http\Controllers\PaymentController::class);

        Route::resource('site_contents', App\Http\Controllers\SiteContentController::class);
        Route::get('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@translation');
        Route::post('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@updateTranslation');
        Route::post('/translation-by-third-party', 'App\Http\Controllers\SiteContentController@translateByThirdParty');
        Route::post('/translation-by-google', 'App\Http\Controllers\SiteContentController@translationByGoogle');
        Route::get('change-sitecontent-status/{id}', 'App\Http\Controllers\SiteContentController@changeStatus');

        Route::resource('contact_us', App\Http\Controllers\ContactUsController::class);

        Route::resource('timeslots', App\Http\Controllers\TimeslotController::class);
        Route::get('timeslot-destroy/{id}', 'App\Http\Controllers\TimeslotController@destroy')->name('timeslot.destroy');
        Route::get('change-timeslot-status/{id}', 'App\Http\Controllers\TimeslotController@changeStatus');
        Route::get('timeslots/translation/{id}', 'App\Http\Controllers\TimeslotController@translation');
        Route::post('timeslots/translation/{id}', 'App\Http\Controllers\TimeslotController@updateTranslation');

        Route::resource('currencies', App\Http\Controllers\CurrencyController::class);
        Route::get('currency-destroy/{id}', 'App\Http\Controllers\CurrencyController@destroy')->name('currency.destroy');
        Route::get('change-currencies-status/{id}', 'App\Http\Controllers\CurrencyController@changeStatus');

        Route::resource('languages', App\Http\Controllers\LanguagesController::class);
        Route::get('language-destroy/{id}', 'App\Http\Controllers\LanguagesController@destroy')->name('language.destroy');
        Route::post('languages/update/{id}', 'App\Http\Controllers\LanguagesController@update');
        Route::get('change-languages-status/{id}', 'App\Http\Controllers\LanguagesController@changeStatus');

        Route::resource('keywords', App\Http\Controllers\LanguagesKeywordsController::class);

        Route::resource('notifications', App\Http\Controllers\PushNotificationController::class);
        Route::get('notification-destroy/{id}', 'App\Http\Controllers\PushNotificationController@destroy')->name('notification.destroy');

        Route::resource('about_us', App\Http\Controllers\AboutUsController::class);
        Route::get('about_us-destroy/{id}', 'App\Http\Controllers\AboutUsController@destroy')->name('about_us.destroy');
        Route::get('about_us/translation/{id}', 'App\Http\Controllers\AboutUsController@translation');
        Route::post('about_us/translation/{id}', 'App\Http\Controllers\AboutUsController@updateTranslation');

        Route::get('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@translation');
        Route::post('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@updateTranslation');

        Route::resource('holidays', App\Http\Controllers\NonWorkinDaysController::class);
        Route::get('holidays-destroy/{id}', 'App\Http\Controllers\NonWorkinDaysController@destroy')->name('holidays.destroy');

        Route::resource('delivery_areas', App\Http\Controllers\DeliveryArea\DeliveryAreasController::class);
        Route::get('delivery_areas-destroy/{id}', 'App\Http\Controllers\DeliveryArea\DeliveryAreasController@destroy')->name('delivery_areas.destroy');
        Route::get('change-delivery-area-status/{id}', 'App\Http\Controllers\DeliveryArea\DeliveryAreasController@changeStatus');
        Route::post('get-city-by_state-id', 'App\Http\Controllers\DeliveryArea\DeliveryAreasController@getCityByStateId');
        
        // State Controller
        Route::resource('state', App\Http\Controllers\DeliveryArea\StateController::class);
        Route::post('state-update', 'App\Http\Controllers\DeliveryArea\StateController@update')->name('state.update');
        Route::get('state-destroy/{id}', 'App\Http\Controllers\DeliveryArea\StateController@destroy')->name('state.destroy');
        Route::get('change-state-status/{id}', 'App\Http\Controllers\DeliveryArea\StateController@changeStatus');
        
        // City Controller
        Route::resource('city', App\Http\Controllers\DeliveryArea\CityController::class);
        Route::post('city-update', 'App\Http\Controllers\DeliveryArea\CityController@update')->name('city.update');
        Route::get('city-destroy/{id}', 'App\Http\Controllers\DeliveryArea\CityController@destroy')->name('city.destroy');
        Route::get('change-city-status/{id}', 'App\Http\Controllers\DeliveryArea\CityController@changeStatus');
        

    });


    Route::prefix('admin/settings')->group(function () {
        Route::patch('update', 'App\Http\Controllers\AppSettingController@updateSetting');
        Route::patch('translate', 'App\Http\Controllers\AppSettingController@translate');
        Route::get('sync-translation', 'App\Http\Controllers\AppSettingController@syncTranslation');
        Route::get('/{type?}/{tab?}', [App\Http\Controllers\AppSettingController::class, 'index'])->where('type', '[A-Za-z]*')->where('tab', '[A-Za-z]*')->name('app-settings');
    });

    Route::post('admin/settings/defaultSettings', 'App\Http\Controllers\AppSettingController@defaultSettingsUpdate')->name('defaultSettings.update');

    });
        Auth::routes();
});
