@extends('layouts.site-app')
@section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.my_order_title')}}</div>
</section>
<section class="youracc-bg">
    <div class="container">
        <div class="row">
            <div class="form-group col-md-12">
                @if(Session::has('message'))
                <div class="alert alert-success" role="alert">
                    {{ Session::get('message') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger" role="alert">
                    {{ Session::get('error') }}
                </div>
                @endif
            </div>
            <div class="col-lg-3 col-md-4">
                @include('partials.site.user-links')
            </div>
            <div class="col-lg-9 col-md-8">
                @if(count($data)>0)
                @foreach($data as $row)
                <div class="yourordr"><a href="{{url('order-details/')}}/{{$row->id}}" style="color: #748a9d;">{{__('lang.order_no')}}{{$row->id}}</a> <a href="{{url('order-details/')}}/{{$row->id}}"><i class="fa fa-angle-down" aria-hidden="true"></i></a></div>
                @endforeach
                @else
                <div class="alert alert-danger" role="alert">{{__('lang.dont_have_order')}}</div>
                @endif
            </div>
        </div>
    </div>
</section>
<footer class="footer">
    @include('partials.site.footer')
</footer>
@endsection
