@extends('layouts.site-app')
@section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.wallet_title')}}</div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-4">
                @include('partials.site.user-links')
            </div>
            <div class="col-lg-9 col-md-8">
                <div class="walletlistop">
                    <div class="walletmid">
                        <div class="amountserch">
                            @include('partials.site.alert')
                            <div class="row">
                                {!! Form::model(null, ['method' => 'POST', 'url' => ['wallet-checkout']]) !!}
                                    @csrf
                                    <div class="col-lg-9 col-md-8 col-sm-8">
                                        <input  type="text" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" name="amount" placeholder="{{__('lang.wallet_enter_amount_placeholder')}}" class="walitinputstyle"  required/>
                                    </div>
                                    <div class="col-lg-3 col-md-4 col-sm-4">
                                        <input type="submit" value="{{__('lang.wallet_proceed_btn')}}" name="btn" class="procedbtninfo" />
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="walletlisttable">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="tablehead">
                                <h4 class="text-align-left">{{__('lang.wallet_amount_transaction')}}</h4>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="tablehead">
                                <h5>{{__('lang.current_wallet_amount')}} <span>{{\Helpers::currency($total_wallet)}}</span></h5>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12">
                            <div class="amountdetailtable">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th width="5%">{{__('lang.wallet_sno')}}</th>
                                            <th width="15%">{{__('lang.wallet_amount')}}</th>
                                            <th width="15%">{{__('lang.wallet_type')}}</th>
                                            <th width="45%">{{__('lang.wallet_comments')}}</th>
                                            <th width="20%">{{__('lang.wallet_date_time')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(count($data)>0)
                                            <?php $i=1; ?>
                                            @foreach($data as $row)
                                                <tr>
                                                    <td width="5%">{{$i++}}</td>
                                                    <td width="15%">{{\Helpers::currency($row->amount)}}</td>
                                                    <td width="15%" style="text-transform: capitalize;">{{$row->type}}</td>
                                                    <td width="45%">{{$row->description}} @if($row->order_info) {{__('lang.wallet_please_click_on')}} <a href="{{url('order-details/')}}/{{$row->order_info->id}}"><b class="nocolor">#{{$row->order_info->id}}</b></a>  @endif</td>
                                                    <td width="20%">
                                                        {{\Helpers::commonDateFormate($row->created_at)}} <br />
                                                        {{\Helpers::commonTimeFormate($row->created_at)}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="5" class="required">{{__('lang.wallet_record_not_found')}}</td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                            <div>
                                <h6 class="pull-left"> <?php if ($data->firstItem() != null) {?> {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                                <h6 class="pull-right">
                                    <div class="pagination" style="float: right;">
                                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                                    </div>
                                </h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="footer">
    @include('partials.site.footer')
</footer>
@endsection
