@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_user_wallet')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('users.index') !!}">{{__('lang.admin_user_list')}}</a></li>
                                <li class="breadcrumb-item active">{{__('lang.admin_user_wallet')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_user_wallet_add')}}</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- Striped rows start -->
            <div class="row" id="table-striped">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">{{$user->phone}} {{__('lang.admin_wallet_list')}}</h4>
                            <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>{{__('lang.admin_table_sno')}}</th>
                                        <th>{{__('lang.admin_type')}}</th>
                                        <th>{{__('lang.admin_amount')}}</th>
                                        <th>{{__('lang.admin_description')}}</th>
                                        <th>{{__('lang.admin_created_at')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=0; ?>
                                    @if(count($data) > 0)
                                    @foreach($data as $res) <?php $i++; ?>
                                    <tr>
                                        <td>{{$i}}</td>
                                        <td>
                                            @if($res->type == 'credit')
                                                <a href="javascript:;">
                                                    <span class="badge rounded-pill badge-light-primary me-1">Credit</span>
                                                </a>
                                            @else
                                                <a href="javascript:;">
                                                    <span class="badge rounded-pill badge-light-warning me-1">Debit</span>
                                                </a>
                                            @endif
                                        </td>
                                        <td>{{ isset($res->amount) ? \Helpers::currency($res->amount) : '--' }}</td>
                                        <td>{{ isset($res->description)?$res->description:'--' }} @if($res->order_info) Please click on <a href="{{ route('orders.show', $res->order_info->id) }}" target="_blank"><b class="nocolor">#{{$res->order_info->id}}</b></a>  @endif</td>
                                        <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="5" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <div class="pagination" style="float: right;">
                                {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Striped rows end -->
        </div>
    </div>
</div>

<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! url('admin/users/wallet/transaction/'.$user->id) !!}" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_payment_gateway_wallet')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="type">{{__('lang.admin_type')}}</label>
                    <select class="form-select" id="type" name="type">
                        <option value="credit">{{__('lang.admin_credit')}}</option>
                        <option value="debit">{{__('lang.admin_debit')}}</option>
                    </select>
                    <small class="form-text"> {{__('lang.admin_wallet_text')}}</small>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_wallet_amnt')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="100.00*" aria-label="100.00" name="amount" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-phone">{{__('lang.admin_wallet_description')}} <span class="required">*</span></label>
                    <textarea id="basic-icon-default-phone" class="form-control dt-post" placeholder="{{__('lang.admin_wallet_description')}}" aria-label="{{__('lang.admin_wallet_description')}}" name="description" required></textarea>
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
@endsection