<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_user_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_image')}}</th>
                                <th>{{__('lang.admin_name')}}</th>
                                <th>{{__('lang.admin_email')}}</th>
                                <th>{{__('lang.admin_phone')}}</th>
                                <th>{{__('lang.admin_payment_gateway_wallet')}}</th>
                                @can('update-user-status')
                                <th>{{__('lang.admin_status')}}</th>
                                @endcan
                                <th>{{__('lang.admin_created_at')}}</th>
                                @canany(['delete-user', 'update-user','add-wallet']) 
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcanany 
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td aria-colindex="2" role="cell" class=""><span class="b-avatar mr-1 badge-secondary rounded-circle"><span class="b-avatar-img">
                                    @if($res->image!='')
                                    <img src="{{asset('/app-assets/images/users/'.$res->image)}}" width="100px" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';">
                                    @else
                                    <img src="{{asset('/app-assets/images/no-image.png')}}">
                                    @endif
                                </span></span></td>
                                <td>
                                @if($res->name)
                                {{$res->name}}
                                @else
                                {{ '--' }}
                                @endif
                                </td>
                                <td>
                                @if($res->email)
                                {{$res->email}}
                                @else
                                {{ '--' }}
                                @endif
                                </td>
                                <td>{{ isset($res->phone)?$res->phone:'--' }}</td>
                                <td><a href="{{ url('admin/users/wallet/'.$res->id) }}">{{ isset($res->wallet_amount)?\Helpers::currency($res->wallet_amount):'--' }}</a></td>

                                @can('update-user-status')
                                <td>
                                    @if($res->status == 1)
                                        <a href="{{ url('admin/change-user-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span></a>
                                    @else
                                        <a href="{{ url('admin/change-user-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                    @endif
                                </td>
                                @endcan

                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                @canany(['delete-user', 'update-user','add-wallet']) 
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                         @can('update-user')
                                            <a class="dropdown-item" href="{{ route('users.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                        @endcan
                                        @can('delete-user')
                                            <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('user' , {{ $res->id }})">
                                            <i data-feather="trash" class="me-50"></i>
                                            <span>{{__('lang.admin_button_delete')}}</span>
                                            </a>
                                        @endcan
                                        @can('add-wallet')
                                            <a class="dropdown-item" href="{{ url('admin/users/wallet/'.$res->id) }}">
                                                <i data-feather="credit-card" class="me-50"></i>
                                                <span>{{__('lang.admin_payment_gateway_wallet')}}</span>
                                            </a>
                                        @endcan
                                            <a class="dropdown-item" href="{{ url('admin/users/addresses/'.$res->id) }}">
                                                <svg style="height: 18px;width: 22px;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" class="main-grid-item-icon" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                                  <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z" />
                                                  <circle cx="12" cy="10" r="3" />
                                                </svg>
                                                <span>{{__('lang.saved_addresses_title')}}</span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>