@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_users')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_user_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            @can('add-user')  
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_user_add')}}</span>
                    </button>
                </div>
            </div>
            @endcan

        </div>
        <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
            <div class="dt-action-buttons text-end">
                <form id="formData" method="get">
                    <div class="row">
                        <div class="form-group col-sm-5">
                            <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_search_by_name_email_phone')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                        </div>

                         <div class="col-md-4">
                            <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_status')}}</option>
                                @foreach($filter['status'] as $value => $sts)
                                <option value="{{ $value }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="form-group col-sm-3" style="text-align: left;">
                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        @include('users.table')
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('users.store') !!}" enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_user_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                    <div class="col-12 d-flex mt-1 px-0">
                        <label class="btn btn-primary me-75 mb-0" for="change-picture">
                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                            <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                            <span class="d-block d-sm-none">
                                <i class="me-0" data-feather="edit"></i>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_name')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="John Doe" aria-label="John Doe" name="name" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">{{__('lang.admin_email')}} <span class="required">*</span></label>
                    <input type="text" id="basic-icon-default-email" class="form-control dt-email" placeholder="john.doe@example.com" aria-label="john.doe@example.com" name="email" required />
                    <small class="form-text"> {{__('lang.admin_email_placeholder')}} </small>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-phone">{{__('lang.admin_phone')}} <span class="required">*</span></label>
                    <div class="input-group">
                        <select id="country-code" class="country-select form-select" id="basic-icon-default-country-code" name="country_code" required style="width: 30%; max-width: 130px;">
                            <option value="+1" data-country-code="US" data-country-name="United States" title="United States">🇺🇸 +1 (US)</option>
                            <option value="+44" data-country-code="GB" data-country-name="United Kingdom" title="United Kingdom">🇬🇧 +44 (GB)</option>
                            <option value="+91" data-country-code="IN" data-country-name="India" title="India">🇮🇳 +91 (IN)</option>
                            <option value="+61" data-country-code="AU" data-country-name="Australia" title="Australia">🇦🇺 +61 (AU)</option>
                            <option value="+1" data-country-code="CA" data-country-name="Canada" title="Canada">🇨🇦 +1 (CA)</option>
                            <option value="+33" data-country-code="FR" data-country-name="France" title="France">🇫🇷 +33 (FR)</option>
                            <option value="+49" data-country-code="DE" data-country-name="Germany" title="Germany">🇩🇪 +49 (DE)</option>
                            <option value="+81" data-country-code="JP" data-country-name="Japan" title="Japan">🇯🇵 +81 (JP)</option>
                            <option value="+86" data-country-code="CN" data-country-name="China" title="China">🇨🇳 +86 (CN)</option>
                            <option value="+39" data-country-code="IT" data-country-name="Italy" title="Italy">🇮🇹 +39 (IT)</option>
                            <option value="+34" data-country-code="ES" data-country-name="Spain" title="Spain">🇪🇸 +34 (ES)</option>
                            <option value="+7" data-country-code="RU" data-country-name="Russia" title="Russia">🇷🇺 +7 (RU)</option>
                            <option value="+55" data-country-code="BR" data-country-name="Brazil" title="Brazil">🇧🇷 +55 (BR)</option>
                            <option value="+52" data-country-code="MX" data-country-name="Mexico" title="Mexico">🇲🇽 +52 (MX)</option>
                            <option value="+27" data-country-code="ZA" data-country-name="South Africa" title="South Africa">🇿🇦 +27 (ZA)</option>
                            <option value="+82" data-country-code="KR" data-country-name="South Korea" title="South Korea">🇰🇷 +82 (KR)</option>
                            <option value="+90" data-country-code="TR" data-country-name="Turkey" title="Turkey">🇹🇷 +90 (TR)</option>
                            <option value="+60" data-country-code="MY" data-country-name="Malaysia" title="Malaysia">🇲🇾 +60 (MY)</option>
                            <option value="+66" data-country-code="TH" data-country-name="Thailand" title="Thailand">🇹🇭 +66 (TH)</option>
                            <option value="+971" data-country-code="AE" data-country-name="United Arab Emirates" title="United Arab Emirates">🇦🇪 +971 (AE)</option>
                            <option value="+62" data-country-code="ID" data-country-name="Indonesia" title="Indonesia">🇮🇩 +62 (ID)</option>
                            <option value="+234" data-country-code="NG" data-country-name="Nigeria" title="Nigeria">🇳🇬 +234 (NG)</option>
                            <option value="+92" data-country-code="PK" data-country-name="Pakistan" title="Pakistan">🇵🇰 +92 (PK)</option>
                            <option value="+63" data-country-code="PH" data-country-name="Philippines" title="Philippines">🇵🇭 +63 (PH)</option>
                            <option value="+47" data-country-code="NO" data-country-name="Norway" title="Norway">🇳🇴 +47 (NO)</option>
                            <option value="+45" data-country-code="DK" data-country-name="Denmark" title="Denmark">🇩🇰 +45 (DK)</option>
                            <option value="+46" data-country-code="SE" data-country-name="Sweden" title="Sweden">🇸🇪 +46 (SE)</option>
                            <option value="+41" data-country-code="CH" data-country-name="Switzerland" title="Switzerland">🇨🇭 +41 (CH)</option>
                            <option value="+31" data-country-code="NL" data-country-name="Netherlands" title="Netherlands">🇳🇱 +31 (NL)</option>
                            <option value="+32" data-country-code="BE" data-country-name="Belgium" title="Belgium">🇧🇪 +32 (BE)</option>
                            <option value="+48" data-country-code="PL" data-country-name="Poland" title="Poland">🇵🇱 +48 (PL)</option>
                            <option value="+30" data-country-code="GR" data-country-name="Greece" title="Greece">🇬🇷 +30 (GR)</option>
                            <option value="+353" data-country-code="IE" data-country-name="Ireland" title="Ireland">🇮🇪 +353 (IE)</option>
                            <option value="+386" data-country-code="SI" data-country-name="Slovenia" title="Slovenia">🇸🇮 +386 (SI)</option>
                            <option value="+357" data-country-code="CY" data-country-name="Cyprus" title="Cyprus">🇨🇾 +357 (CY)</option>
                            <option value="+64" data-country-code="NZ" data-country-name="New Zealand" title="New Zealand">🇳🇿 +64 (NZ)</option>
                            <option value="+54" data-country-code="AR" data-country-name="Argentina" title="Argentina">🇦🇷 +54 (AR)</option>
                            <option value="+98" data-country-code="IR" data-country-name="Iran" title="Iran">🇮🇷 +98 (IR)</option>
                            <option value="+964" data-country-code="IQ" data-country-name="Iraq" title="Iraq">🇮🇶 +964 (IQ)</option>
                            <option value="+254" data-country-code="KE" data-country-name="Kenya" title="Kenya">🇰🇪 +254 (KE)</option>
                            <option value="+251" data-country-code="ET" data-country-name="Ethiopia" title="Ethiopia">🇪🇹 +251 (ET)</option>
                            <option value="+237" data-country-code="CM" data-country-name="Cameroon" title="Cameroon">🇨🇲 +237 (CM)</option>
                            <option value="+216" data-country-code="TN" data-country-name="Tunisia" title="Tunisia">🇹🇳 +216 (TN)</option>
                            <option value="+212" data-country-code="MA" data-country-name="Morocco" title="Morocco">🇲🇦 +212 (MA)</option>
                            <option value="+20" data-country-code="EG" data-country-name="Egypt" title="Egypt">🇪🇬 +20 (EG)</option>
                            <option value="+95" data-country-code="MM" data-country-name="Myanmar" title="Myanmar">🇲🇲 +95 (MM)</option>
                            <option value="+65" data-country-code="SG" data-country-name="Singapore" title="Singapore">🇸🇬 +65 (SG)</option>
                        </select>
                        <input type="text" id="basic-icon-default-phone" class="form-control dt-post" placeholder="1212121212" aria-label="{{__('lang.admin_phone')}}" name="phone" value="{{ old('phone') }}" required style="width: 50%;"/>
                    </div>
                </div>

                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-password">{{__('lang.admin_password')}} <span class="required">*</span></label>
                    <input type="password" id="basic-icon-default-password" class="form-control dt-post" placeholder="*******" aria-label="Password" name="password" required />
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
@endsection