@extends('layouts.app')
@section('content')
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_users')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/users*') ? 'active' : '' }}"><a href="{!! route('users.index') !!}">{{__('lang.admin_user_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_user_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($user, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['users.update', $user->id]]) !!}
                                @csrf
                                <div class="d-flex mb-2">
                                    @if($user->image)
                                    <img src="{{asset('app-assets/images/users/'.$user->image)}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';"/>
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="mt-50">
                                    <h4>{{$user->name}}</h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_user_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_user_name')}}" value="{{$user->name}}" name="name" id="username"  required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_email')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_email')}}" value="{{$user->email}}" name="email" id="email" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="phone">{{__('lang.admin_user_phone')}} <span class="required">*</span></label>
                                            <div class="input-group">
                                                <select id="country-code" class="country-select form-select" name="country_code" required>
                                                    <option value="+1" data-country-code="US" data-country-name="United States" title="United States" {{ $user->country_code == '+1' ? 'selected' : '' }}>🇺🇸 +1 (US)</option>
                                                    <option value="+44" data-country-code="GB" data-country-name="United Kingdom" title="United Kingdom" {{ $user->country_code == '+44' ? 'selected' : '' }}>🇬🇧 +44 (GB)</option>
                                                    <option value="+91" data-country-code="IN" data-country-name="India" title="India" {{ $user->country_code == '+91' ? 'selected' : '' }}>🇮🇳 +91 (IN)</option>
                                                    <option value="+61" data-country-code="AU" data-country-name="Australia" title="Australia" {{ $user->country_code == '+61' ? 'selected' : '' }}>🇦🇺 +61 (AU)</option>
                                                    <option value="+1" data-country-code="CA" data-country-name="Canada" title="Canada" {{ $user->country_code == '+1' ? 'selected' : '' }}>🇨🇦 +1 (CA)</option>
                                                    <option value="+33" data-country-code="FR" data-country-name="France" title="France" {{ $user->country_code == '+33' ? 'selected' : '' }}>🇫🇷 +33 (FR)</option>
                                                    <option value="+49" data-country-code="DE" data-country-name="Germany" title="Germany" {{ $user->country_code == '+49' ? 'selected' : '' }}>🇩🇪 +49 (DE)</option>
                                                    <option value="+81" data-country-code="JP" data-country-name="Japan" title="Japan" {{ $user->country_code == '+81' ? 'selected' : '' }}>🇯🇵 +81 (JP)</option>
                                                    <option value="+86" data-country-code="CN" data-country-name="China" title="China" {{ $user->country_code == '+86' ? 'selected' : '' }}>🇨🇳 +86 (CN)</option>
                                                    <option value="+39" data-country-code="IT" data-country-name="Italy" title="Italy" {{ $user->country_code == '+39' ? 'selected' : '' }}>🇮🇹 +39 (IT)</option>
                                                    <option value="+34" data-country-code="ES" data-country-name="Spain" title="Spain" {{ $user->country_code == '+34' ? 'selected' : '' }}>🇪🇸 +34 (ES)</option>
                                                    <option value="+7" data-country-code="RU" data-country-name="Russia" title="Russia" {{ $user->country_code == '+7' ? 'selected' : '' }}>🇷🇺 +7 (RU)</option>
                                                    <option value="+55" data-country-code="BR" data-country-name="Brazil" title="Brazil" {{ $user->country_code == '+55' ? 'selected' : '' }}>🇧🇷 +55 (BR)</option>
                                                    <option value="+52" data-country-code="MX" data-country-name="Mexico" title="Mexico" {{ $user->country_code == '+52' ? 'selected' : '' }}>🇲🇽 +52 (MX)</option>
                                                    <option value="+27" data-country-code="ZA" data-country-name="South Africa" title="South Africa" {{ $user->country_code == '+27' ? 'selected' : '' }}>🇿🇦 +27 (ZA)</option>
                                                    <option value="+82" data-country-code="KR" data-country-name="South Korea" title="South Korea" {{ $user->country_code == '+82' ? 'selected' : '' }}>🇰🇷 +82 (KR)</option>
                                                    <option value="+90" data-country-code="TR" data-country-name="Turkey" title="Turkey" {{ $user->country_code == '+90' ? 'selected' : '' }}>🇹🇷 +90 (TR)</option>
                                                    <option value="+60" data-country-code="MY" data-country-name="Malaysia" title="Malaysia" {{ $user->country_code == '+60' ? 'selected' : '' }}>🇲🇾 +60 (MY)</option>
                                                    <option value="+66" data-country-code="TH" data-country-name="Thailand" title="Thailand" {{ $user->country_code == '+66' ? 'selected' : '' }}>🇹🇭 +66 (TH)</option>
                                                    <option value="+971" data-country-code="AE" data-country-name="United Arab Emirates" title="United Arab Emirates" {{ $user->country_code == '+971' ? 'selected' : '' }}>🇦🇪 +971 (AE)</option>
                                                    <option value="+62" data-country-code="ID" data-country-name="Indonesia" title="Indonesia" {{ $user->country_code == '+62' ? 'selected' : '' }}>🇮🇩 +62 (ID)</option>
                                                    <option value="+234" data-country-code="NG" data-country-name="Nigeria" title="Nigeria" {{ $user->country_code == '+234' ? 'selected' : '' }}>🇳🇬 +234 (NG)</option>
                                                    <option value="+92" data-country-code="PK" data-country-name="Pakistan" title="Pakistan" {{ $user->country_code == '+92' ? 'selected' : '' }}>🇵🇰 +92 (PK)</option>
                                                    <option value="+63" data-country-code="PH" data-country-name="Philippines" title="Philippines" {{ $user->country_code == '+63' ? 'selected' : '' }}>🇵🇭 +63 (PH)</option>
                                                    <option value="+47" data-country-code="NO" data-country-name="Norway" title="Norway" {{ $user->country_code == '+47' ? 'selected' : '' }}>🇳🇴 +47 (NO)</option>
                                                    <option value="+45" data-country-code="DK" data-country-name="Denmark" title="Denmark" {{ $user->country_code == '+45' ? 'selected' : '' }}>🇩🇰 +45 (DK)</option>
                                                    <option value="+46" data-country-code="SE" data-country-name="Sweden" title="Sweden" {{ $user->country_code == '+46' ? 'selected' : '' }}>🇸🇪 +46 (SE)</option>
                                                    <option value="+41" data-country-code="CH" data-country-name="Switzerland" title="Switzerland" {{ $user->country_code == '+41' ? 'selected' : '' }}>🇨🇭 +41 (CH)</option>
                                                    <option value="+31" data-country-code="NL" data-country-name="Netherlands" title="Netherlands" {{ $user->country_code == '+31' ? 'selected' : '' }}>🇳🇱 +31 (NL)</option>
                                                    <option value="+32" data-country-code="BE" data-country-name="Belgium" title="Belgium" {{ $user->country_code == '+32' ? 'selected' : '' }}>🇧🇪 +32 (BE)</option>
                                                    <option value="+48" data-country-code="PL" data-country-name="Poland" title="Poland" {{ $user->country_code == '+48' ? 'selected' : '' }}>🇵🇱 +48 (PL)</option>
                                                    <option value="+30" data-country-code="GR" data-country-name="Greece" title="Greece" {{ $user->country_code == '+30' ? 'selected' : '' }}>🇬🇷 +30 (GR)</option>
                                                    <option value="+353" data-country-code="IE" data-country-name="Ireland" title="Ireland" {{ $user->country_code == '+353' ? 'selected' : '' }}>🇮🇪 +353 (IE)</option>
                                                    <option value="+386" data-country-code="SI" data-country-name="Slovenia" title="Slovenia" {{ $user->country_code == '+386' ? 'selected' : '' }}>🇸🇮 +386 (SI)</option>
                                                    <option value="+357" data-country-code="CY" data-country-name="Cyprus" title="Cyprus" {{ $user->country_code == '+357' ? 'selected' : '' }}>🇨🇾 +357 (CY)</option>
                                                    <option value="+64" data-country-code="NZ" data-country-name="New Zealand" title="New Zealand" {{ $user->country_code == '+64' ? 'selected' : '' }}>🇳🇿 +64 (NZ)</option>
                                                    <option value="+54" data-country-code="AR" data-country-name="Argentina" title="Argentina" {{ $user->country_code == '+54' ? 'selected' : '' }}>🇦🇷 +54 (AR)</option>
                                                    <option value="+98" data-country-code="IR" data-country-name="Iran" title="Iran" {{ $user->country_code == '+98' ? 'selected' : '' }}>🇮🇷 +98 (IR)</option>
                                                    <option value="+964" data-country-code="IQ" data-country-name="Iraq" title="Iraq" {{ $user->country_code == '+964' ? 'selected' : '' }}>🇮🇶 +964 (IQ)</option>
                                                    <option value="+254" data-country-code="KE" data-country-name="Kenya" title="Kenya" {{ $user->country_code == '+254' ? 'selected' : '' }}>🇰🇪 +254 (KE)</option>
                                                    <option value="+251" data-country-code="ET" data-country-name="Ethiopia" title="Ethiopia" {{ $user->country_code == '+251' ? 'selected' : '' }}>🇪🇹 +251 (ET)</option>
                                                    <option value="+237" data-country-code="CM" data-country-name="Cameroon" title="Cameroon" {{ $user->country_code == '+237' ? 'selected' : '' }}>🇨🇲 +237 (CM)</option>
                                                    <option value="+216" data-country-code="TN" data-country-name="Tunisia" title="Tunisia" {{ $user->country_code == '+216' ? 'selected' : '' }}>🇹🇳 +216 (TN)</option>
                                                    <option value="+212" data-country-code="MA" data-country-name="Morocco" title="Morocco" {{ $user->country_code == '+212' ? 'selected' : '' }}>🇲🇦 +212 (MA)</option>
                                                    <option value="+20" data-country-code="EG" data-country-name="Egypt" title="Egypt" {{ $user->country_code == '+20' ? 'selected' : '' }}>🇪🇬 +20 (EG)</option>
                                                    <option value="+95" data-country-code="MM" data-country-name="Myanmar" title="Myanmar" {{ $user->country_code == '+95' ? 'selected' : '' }}>🇲🇲 +95 (MM)</option>
                                                    <option value="+65" data-country-code="SG" data-country-name="Singapore" title="Singapore" {{ $user->country_code == '+65' ? 'selected' : '' }}>🇸🇬 +65 (SG)</option>
                                                </select>
                                    
                                                @php
                                                    // Remove country code from phone number for display
                                                    $localPhone = preg_replace('/^' . preg_quote($user->country_code) . '/', '', $user->phone);
                                                @endphp
                                    
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_phone')}}" value="{{ trim($localPhone) }}" name="phone" id="phone" required />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="password">{{__('lang.admin_password')}}</label>
                                            <input type="password" class="form-control" placeholder="{{__('lang.admin_password')}}" name="password" id="password" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($user->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($user->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('users.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection