@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.saved_addresses_title')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('users.index') !!}">{{__('lang.admin_user_list')}}</a></li>
                                <li class="breadcrumb-item active">{{__('lang.saved_addresses_title')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- Striped rows start -->
            <div class="row" id="table-striped">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>{{__('lang.admin_table_sno')}}</th>
                                        <th>{{__('lang.admin_type')}}</th>
                                        <th>{{__('lang.admin_address')}}</th>
                                        <th>{{__('lang.admin_city')}}</th>
                                        <th>{{__('lang.admin_state')}}</th>
                                        <th>{{__('lang.admin_zipcode')}}</th>
                                        <th>{{__('lang.admin_created_at')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=0; ?>
                                    @if(count($data) > 0)
                                    @foreach($data as $row) <?php $i++; ?>
                                    <tr>
                                        <td>{{$i}}</td>
                                        <td>{{$row->type}}</td>
                                        <td>{{$row->address}}</td>
                                        <td>{{$row->city}}</td>
                                        <td>{{$row->state}}</td>
                                        <td>{{$row->zipcode}}</td>
                                        <td>{{ isset($row->created_at) ? \Helpers::commonDateTimeFormate($row->created_at) : '--' }}</td>
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="7" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <div class="pagination" style="float: right;">
                                {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Striped rows end -->
        </div>
    </div>
</div>
<!-- END: Content-->
@endsection