<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_timeslot_list')}}</h4>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_name')}}</th>
                                <th>{{__('lang.admin_timeslot_from_time')}}</th>
                                <th>{{__('lang.admin_timeslot_to_time')}}</th>
                                @can('update-timeslots-status')
                                <th>{{__('lang.admin_status')}}</th>
                                @endcan
                                @canany(['update-timeslots','delete-timeslots','timeslots-translation'])
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcanany
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td>{{ isset($res->name)?$res->name:'--' }}</td>
                                <td>{{ isset($res->from_time)?date('h:i A',strtotime($res->from_time)):'--' }}</td>
                                <td>{{ isset($res->to_time)?date('h:i A',strtotime($res->to_time)):'--' }}</td>
                                @can('update-timeslots-status')
                                <td>
                                    @if($res->status == 1)
                                        <a href="{{ url('admin/change-timeslot-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span></a>
                                    @else
                                        <a href="{{ url('admin/change-timeslot-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                    @endif
                                </td>
                                @endcan
                                @canany(['update-timeslots','delete-timeslots','timeslots-translation'])
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('update-timeslots')
                                            <a class="dropdown-item" href="{{ route('timeslots.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            @endcan
                                            @can('timeslots-translation')
                                            <a class="dropdown-item" href="{{ url('admin/timeslots/translation/'.$res->id) }}">
                                                <i data-feather="type" class="me-50"></i>
                                                <span>{{__('lang.admin_button_translation')}}</span>
                                            </a>
                                            @endcan

                                            @can('delete-timeslots')
                                              <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('timeslot' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                               </a>
                                             @endcan
                                        </div>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>