@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_subadmins')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/sub-admin*') ? 'active' : '' }}"><a href="{!! route('sub-admin.index') !!}">{{__('lang.admin_edit_subadmin')}}</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <!-- users edit start -->
                                {!! Form::model($subadmin, ['method' => 'POST','enctype'=>'multipart/form-data', 'route' => ['update-sub-admin']]) !!}
                                @csrf
                                <input type="hidden" name="id" value="{{$subadmin->id}}">
                                <div class="d-flex mb-2">
                                    @if($subadmin->image!='')
                                    <img src="{{asset('app-assets/images/users//'.$subadmin->image)}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';"/>
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="mt-50">
                                    <h4>{{$subadmin->name}}</h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_name')}}" value="{{$subadmin->name}}" name="name" id="username" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_email')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_email')}}" value="{{$subadmin->email}}" name="email" id="email" required />
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="role_id">{{__('lang.admin_role')}} <span class="required">*</span></label>
                                            <select class="form-control" id="role_id" name="role_id" required/>
                                            <option value="">{{__('lang.admin_select_role')}}</option>
                                            @if(isset($roles) && count($roles))
                                                @foreach($roles as $role)
                                                <option @if($subadmin->role_id==$role->id) selected @endif value="{{$role->id}}">{{$role->name}}</option>
                                                @endforeach
                                            @endif
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="phone">{{__('lang.admin_phone')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_phone')}}" value="{{$subadmin->phone}}" name="phone" id="phone" required maxlength="10"/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="password">{{__('lang.admin_password')}}</label>
                                            <input type="password" class="form-control" placeholder="{{__('lang.admin_password')}}" name="password" id="password" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($subadmin->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($subadmin->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('sub-admin.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->
@endsection