@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_static_pages_translation')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/site_contents*') ? 'active' : '' }}"><a href="{!! route('site_contents.index') !!}">{{__('lang.admin_static_pages_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_static_pages_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="language_code">{{__('lang.admin_select_language')}}</label>
                                            <select class="form-select" id="language_code" name="language_code" onchange="selectLanguage(this.value);" required>
                                                @foreach($languages as $row)
                                                    <option value="{{$row->language_code}}">{{$row->language_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                {!! Form::model($data, ['method' => 'POST','url' => ['admin/site_contents/translation/'.$data->id]]) !!}
                                @csrf
                                <?php
                                $i = 0;
                                ?>
                                @foreach($languages as $row) 
                                @if($row->details)
                                    <input type="hidden" name="translation_id[]" value="{{$row->details->id}}">
                                    <input type="hidden" name="language_code[]" value="{{$row->language_code}}">
                                    <div class="row formbody <?php if($i>0){ ?>hide<?php } ?>" id="translation_{{$row->language_code}}">
                                        <div class="col-md-9">
                                            <div class="mb-1">
                                                <label class="form-label" for="name">{{__('lang.admin_cms_page_title')}} ({{$row->language_name}})</label>
                                                <input type="text" class="form-control " placeholder="Page Title" value="{{$row->details->page_title}}" name="page_title[]" id="page_title_{{$row->language_code}}" />
                                            </div>
                                        </div>


                                        <div class="col-md-3 mt-2">
                                            @if(setting('google_translate_api_key')!='')
                                            <button type="button" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1" onclick="translateByGoogle('{{$row->language_name}}','{{$row->language_code}}','page_title_{{$row->language_code}}');">{{__('lang.admin_google_translate')}}</button>
                                            @else
                                            <button type="button" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1" onclick="translationKeyNotFoundError();">{{__('lang.admin_google_translate')}}</button>
                                            @endif
                                        </div>

                                        <div class="col-md-9">
                                            <div class="mb-1">
                                                <label class="" for="name">{{__('lang.admin_cms_page_description')}} ({{$row->language_name}})</label>
                                                <textarea class="form-control" name="description[]" id="editor_{{$row->language_code}}" name="Page Description" value="{{$row->details->description}}">{{$row->details->description}}</textarea>
                                            </div>
                                        </div>


                                        <div class="col-md-3 mt-2">
                                            @if(setting('google_translate_api_key')!='')
                                            <button type="button" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1" onclick="translateByGoogle('{{$row->language_name}}','{{$row->language_code}}','editor_{{$row->language_code}}');">{{__('lang.admin_google_translate')}}</button>
                                            @else
                                            <button type="button" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1" onclick="translationKeyNotFoundError();">{{__('lang.admin_google_translate')}}</button>
                                            @endif
                                        </div>

                                    </div>
                                    <script type="text/javascript">
                                        ClassicEditor
                                        .create( document.querySelector( '#editor_{{$row->language_code}}' ), {} )
                                        .catch( error => {
                                            console.log( error );
                                        } );
                                    </script>
                                    <?php $i++; ?>
                                @endif @endforeach
                                <div class="row">
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('site_contents.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- coupons edit ends -->

        </div>
    </div>
</div>
<!-- END: Content-->
<script type="text/javascript">
    function selectLanguage(langCode){
        $(".formbody").addClass('hide');
        $("#translation_"+langCode).removeClass('hide');
    }
</script>
@endsection