<script>
   document.addEventListener("DOMContentLoaded", function () {
       const input = document.querySelector("#phone");
       const button = document.querySelector("#login_button");
       const errorMsg = document.querySelector("#error-msg");
       const validMsg = document.querySelector("#valid-msg");
       window.service_id='';
       const iti = window.intlTelInput(input, {
           initialCountry: {!! json_decode($settingsArray['countryCodes'], true) == null ? '"in"' : '"' . json_decode($settingsArray['countryCodes'], true)[0] . '"' !!},
           onlyCountries: [{!! json_decode($settingsArray['countryCodes'], true) == null ? '"in","us"' : '"' . implode('","', json_decode($settingsArray['countryCodes'], true)) . '"' !!}],
           separateDialCode: true,
           utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@17.0.8/build/js/utils.js"
       });
       /* const errorMap = ["Invalid number", "Invalid country code", "Number is Too short", $('#website_number_too_long').val(), "Invalid number"]; */

       const reset = () => {
           input.classList.remove("error");
           if (errorMsg) {
               errorMsg.innerHTML = "";
               errorMsg.classList.add("hide");
           }
           if (validMsg) {
               validMsg.classList.add("hide");
           }
       };

       const showError = (msg) => {
           input.classList.add("error");
           if (errorMsg) {
               errorMsg.innerHTML = msg;
               errorMsg.classList.remove("hide");
           }
           Swal.fire({
               text: msg,
               confirmButtonText: "{{ __('lang.ok') }}"
           });
       };

       // on click button: validate
       button.addEventListener('click', () => {
           setButtonDisabled(true,"login");
           const trim_phoneNumber = input.value.trim();
           const countryData = iti.getSelectedCountryData();
           const countryCode = countryData.dialCode;
           const phoneNumber = `+${countryCode}${trim_phoneNumber}`;

            if (trim_phoneNumber.length === 0) {
                showError($('#admin_phone_number_is_required').val());
                setButtonDisabled(false,"login");
                return;
            } else if (trim_phoneNumber.length < 8 || trim_phoneNumber.length > 15) {
                showError($('#admin_phone_number_length').val());
                setButtonDisabled(false,"login");
                return;
            }
            // Numeric validation
            if (!/^\d+$/.test(trim_phoneNumber)) {
                showError($('#admin_phone_number_contain_digit').val());
                setButtonDisabled(false,"login");
                return;
            }
            $('#enter_phone1').val(phoneNumber);
            phoneSendAuthTwilio();
            // $('#verifymodal').modal('show');

            // setButtonDisabled(false,"login");
            // return false;



       });

       // on keyup / change flag: reset
       input.addEventListener('change', reset);
       input.addEventListener('keyup', reset);

       // Firebase configuration




        // Function to send OTP via Twilio
        window.phoneSendAuthTwilio = function () {
           const countryData = iti.getSelectedCountryData();
           const countryCode = countryData.dialCode;
           const phoneNumber = input.value.trim();
           const fullPhoneNumber = `+${countryCode}${phoneNumber}`;

           // AJAX request to your backend to send OTP via Twilio
           $.ajax({
               type: 'POST',
               url: base_url + "/api/twilio/send-otp",
               data: {
                   phone: fullPhoneNumber,
               },
               success: function (response) {
                   if (response.success) {
                        service_id=response.service_id;
                       document.getElementById("enter_phone").innerHTML = fullPhoneNumber;
                       document.getElementById("enter_phone1").value = fullPhoneNumber;
                       $('#verifymodal').modal('show');
                   } else {
                       setButtonDisabled(false, "login");
                       Swal.fire({
                           text: 'OTP not send. Try again later.',
                       });
                   }
               },
               error: function (xhr, status, error) {
                   setButtonDisabled(false, "login");
                   Swal.fire({
                       text: $('#admin_otp_not_send_due_to_invalid_number').val(),
                   });
               }
           });
       }

       window.getOTPValue = function() {
           var otp = '';
           document.querySelectorAll('.digit-group input').forEach(function(input) {
               otp += input.value;
           });
           return otp;
       }

       window.codeverify =function() {
           setButtonDisabled(true,"verify");
           var code = getOTPValue();
           if(!code){
               setButtonDisabled(false,"verify");
               Swal.fire({
                   text:  $("#admin_otp_required").val(),
               });
           }
           var fullPhoneNumber = $("#enter_phone1").val().trim();
           otpVerify(fullPhoneNumber,code);
       }
   });

   function otpVerify(phonenumber,otp){
        var url = base_url + "/api/twilio/verify-otp";
        $.ajax({
           type: 'POST',
           url: url,
           data: {otp:otp, phonenumber:phonenumber, service_id},
           success: function (response) {
               if (response.success) {
                   $('#verifymodal form').submit();
                //   user_login(phonenumber, otp);
                   sessionStorage.setItem('message', response.message || '$("#admin_login_successful").val()');
                   sessionStorage.setItem('message_type', 'success');
               } else {
                   sessionStorage.setItem('message', response.message || '$("#admin_login_failed").val()');
                   sessionStorage.setItem('message_type', 'error');
               }

               // Handle successful login (e.g., show user dashboard)
           },
           error: function (xhr, status, error) {
               console.error('Login error:', error);
               $("#login_button").html("Login");
               $("#login_button").attr('disabled', false);
               Swal.fire({
                   text:  $('#admin_failed_signin_try_again').val(),
                   confirmButtonText: "{{ __('lang.ok') }}"
               });
               sessionStorage.setItem('message', '$("#admin_failed_signin_try_again").val()');
               sessionStorage.setItem('message_type', 'error');
           }
       });
   }

   function user_login(phoneNumber, otp) {
       if (phoneNumber == '') {
           Swal.fire({
               text:  $('#admin_phone_number_is_required').val(),
               confirmButtonText: "{{ __('lang.ok') }}"
           });
           return;
       }
       if (otp == '') {
           Swal.fire({
               text:  $('#admin_otp_required').val(),
               confirmButtonText: "{{ __('lang.ok') }}"
           });
           return;
       }
       $("#login_button").html("Please wait..");
       $("#login_button").attr('disabled', true);

       var url = base_url + "/api/user/login";
       var data = {
           phone: phoneNumber,
           otp: otp,
       };
       $.ajax({
           type: 'POST',
           url: url,
           contentType: 'application/json',
           dataType: 'json',
           data: JSON.stringify(data),
           success: function (response) {
               console.log('Login success:', response);
               if (response.success) {
                   $('#verifymodal form').submit();
                   sessionStorage.setItem('message', response.message || '$("#admin_login_successful").val()');
                   sessionStorage.setItem('message_type', 'success');
               } else {
                   sessionStorage.setItem('message', response.message || '$("#admin_login_failed").val()');
                   sessionStorage.setItem('message_type', 'error');
               }


               // Handle successful login (e.g., show user dashboard)
           },
           error: function (xhr, status, error) {
               console.error('Login error:', error);
               $("#login_button").html("Login");
               $("#login_button").attr('disabled', false);
               Swal.fire({
                   text:  $('#admin_failed_signin_try_again').val(),
                   confirmButtonText: "{{ __('lang.ok') }}"
               });
               sessionStorage.setItem('message', '$("#admin_failed_signin_try_again").val()');
               sessionStorage.setItem('message_type', 'error');
           }
       });
   }

   $('.digit-group').find('input').each(function() {
       $(this).attr('maxlength', 1);
       $(this).on('keyup', function(e) {
           var parent = $($(this).parent());
           if(e.keyCode === 8 || e.keyCode === 37) {
               var prev = parent.find('input#' + $(this).data('previous'));
               if(prev.length) {
                   $(prev).select();
               }
           } else if((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 65 && e.keyCode <= 90) || (e.keyCode >= 96 && e.keyCode <= 105) || e.keyCode === 39) {
               var next = parent.find('input#' + $(this).data('next'));
               if(next.length) {
                   $(next).select();
               } else {
                   //$("#submit_verify").click();
               }
           }
       });
   });
   function setButtonDisabled(disabled,button) {
       let btn='';
       if(button=="login"){
           btn = document.querySelector("#login_button");
       }else if(button=="verify"){
           btn = document.querySelector("#verify_btn");
       }
       btn.disabled = disabled;
       if (disabled) {
           btn.classList.remove('button-enabled');
           btn.classList.add('button-disabled');
       } else {
           btn.classList.remove('button-disabled');
           btn.classList.add('button-enabled');
       }
   }

</script>