@extends('layouts.site-app')
@section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.sign_in_title')}}</div>
</section>
<section class="loginbg" id="signIn_blade">
    <div class="container">
        <div class="row justify-content-center sign-in-form">
            <div class="col-lg-5 col-md-8 col-sm-10">
                <div class="loginform dark-color-bg signinform p-4">
                    <form>
                        <div class="row">
                            <div class="form-group col-12">
                                @if(Session::has('message'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ Session::get('message') }}
                                    </div>
                                @endif
                                @if(Session::has('error'))
                                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        {{ Session::get('error') }}
                                    </div>
                                @endif
                            </div>
                            <div class="col-12">
                                <input type="text" class="form-control form-input-color" name="phone" id="phone" placeholder="{{__('lang.enter_your_number_placeholder')}}" onkeypress="return (event.charCode != 8 && event.charCode == 0 || (event.charCode >= 48 && event.charCode <= 57))" maxlength="10" />
                            </div>
                        </div>
                        <div class="form-group col-12">
                            <div id="recaptcha-container"></div> 
                            <!-- Added reCAPTCHA container here -->
                            <button type="button" class="btn btn-primary submit-btn w-100 text-uppercase mt-5" id="login_button" onclick="">{{__('lang.user_login')}} <img src="{{asset('site-assets/images/arrowright.png')}}" /></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</section>
<div class="modal fade" id="verifymodal" tabindex="-1" aria-labelledby="verifyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <!-- Modal body -->
            <div class="modal-body">
                {!! Form::model(null, ['method' => 'POST', 'url' => ['verify-otp']]) !!}
                    @csrf
                    <input type="hidden" name="phone_number" id="enter_phone1" value="">
                    <div class="verificationcode-popup text-center">
                        <h1>{{__('lang.enter_verify_code')}}</h1>
                        <h6>{{__('lang.verification_otp_send_message')}}</h6>
                        <h3 id="enter_phone"></h3>
                        <div class="otpinput digit-group d-flex justify-content-between" data-group-name="digits">
                            <input type="password" id="otp_1" name="otp_1" class="form-control" data-next="otp_2" />
                            <input type="password" id="otp_2" name="otp_2" class="form-control" data-next="otp_3" data-previous="otp_1" />
                            <input type="password" id="otp_3" name="otp_3" class="form-control" data-next="otp_4" data-previous="otp_2" />
                            <input type="password" id="otp_4" name="otp_4" class="form-control" data-next="otp_5" data-previous="otp_3" />
                            <input type="password" id="otp_5" name="otp_5" class="form-control" data-next="otp_6" data-previous="otp_4" />
                            <input type="password" id="otp_6" name="otp_6" class="form-control" data-previous="otp_5" />
                        </div>
                        <button class="btn btn-primary submit-btn mt-3 w-100" id="verify_btn" type="button" onclick="codeverify()">
                            {{__('lang.verify_button')}} <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                        </button>
                        <div class="resendlink mt-3">
                            <a href="/signin" onclick="phoneSendAuth()" id="resend_otp_link">{{__('lang.web_go_back')}}</a>
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

{{-- hidden error input showing translated errors --}}
<input type="hidden" id="admin_phone_number_is_required" value="{{ __('lang.admin_phone_number_is_required') }}" />
<input type="hidden" id="admin_please_verified_recaptcha" value="{{ __('lang.admin_please_verified_recaptcha') }}" />
<input type="hidden" id="admin_phone_number_length" value="{{ __('lang.admin_phone_number_length') }}" />
<input type="hidden" id="admin_phone_number_contain_digit" value="{{ __('lang.admin_phone_number_contain_digit') }}" />
<input type="hidden" id="admin_recaptcha_expired" value="{{ __('lang.admin_recaptcha_expired') }}" />
<input type="hidden" id="admin_otp_not_send_due_to_invalid_captcha" value="{{ __('lang.admin_otp_not_send_due_to_invalid_captcha') }}" />
<input type="hidden" id="admin_login_failed" value="{{ __('lang.admin_login_failed') }}" />
<input type="hidden" id="admin_login_successful" value="{{ __('lang.admin_login_successful') }}" />
<input type="hidden" id="admin_failed_signin_try_again" value="{{ __('lang.admin_failed_signin_try_again') }}" />
<input type="hidden" id="admin_otp_required" value="{{ __('lang.admin_otp_required') }}" />
<input type="hidden" id="admin_otp_is_wrong_or_server_error" value="{{ __('lang.admin_otp_is_wrong_or_server_error') }}" />
<input type="hidden" id="admin_otp_not_send_due_to_invalid_number" value="{{ __('lang.admin_otp_not_send_due_to_invalid_number') }}" />

{{-- end hidden error input --}}
<footer class="footer">
    @include('partials.site.footer')
</footer>


<!-- Load intl-tel-input JS -->
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@23.3.0/build/js/intlTelInput.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@17.0.8/build/js/utils.js"></script>

<!-- Load Firebase App and Auth scripts -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    @php
        $isTestMode = isset($settingsArray['enable_test_mode']) ? $settingsArray['enable_test_mode'] : '0';
        $isFirebaseEnabled = isset($settingsArray['is_enable_firebase']) ? $settingsArray['is_enable_firebase'] : '0';
        $isTwilioEnabled = isset($settingsArray['is_enable_twilio']) ? $settingsArray['is_enable_twilio'] : '0';
        $isFast2SmsEnabled = isset($settingsArray['is_enabled_fast_2_sms']) ? $settingsArray['is_enabled_fast_2_sms'] : '0';
        $isFirebaseMessageEnabled = isset($settingsArray['enable_firebase_message']) ? $settingsArray['enable_firebase_message'] : '0';
        $is2FactorSmsEnabled = isset($settingsArray['is_enabled_2_factor']) ? $settingsArray['is_enabled_2_factor'] : '0';
    @endphp

    @if($isTwilioEnabled =='1')
        @include('signin_type.twilio_js')
    @elseif($isFirebaseEnabled == 1 || $isFirebaseMessageEnabled == 1)
        @include('signin_type.firebase_js')
    @elseif($isFast2SmsEnabled == 1)
        @include('signin_type.fast_2_sms_js')
    @elseif($is2FactorSmsEnabled == 1)
        @include('signin_type.factor_2_sms_js')
    @else
        @include('signin_type.test_mode_js')
    @endif

@endsection