@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{__('lang.admin_menu_website_settings')}}
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <section class="app-user-edit">
                    <div class="card">
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                    {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                        @csrf
                                        <input type="hidden" name="page_name" value="website_settings">
                                        <div class="row">
                                            <h4> {{__('lang.admin_uris_setting')}}</h4>
                                            @foreach ($data as $row)
                                                @if($row->key=='youtube_video_url')
                                                    <div class="col-md-4">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="youtube_video_url">{{__('lang.admin_youtube_embed_url')}}</label>
                                                            <span class="tooltip-icon" data-toggle="tooltip" title="1. Copy the embedded URL from a YouTube video.&#013;2. Take out the src URL. Example - src='https://www.youtube.com/embed/W_j6PHiin_0'&#013;3. Paste that URL in the field and Save.">
                                                                    &#x1F6C8;
                                                            </span>
                                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_youtube_embed_url')}}" name="youtube_video_url" id="youtube_video_url" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                                @if($row->key=='apple_download_url')
                                                    <div class="col-md-4">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="apple_download_url">{{__('lang.admin_apple_download_url')}}</label>
                                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_apple_download_url')}}" name="apple_download_url" id="apple_download_url" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                                @if($row->key=='android_download_url')
                                                    <div class="col-md-4">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="android_download_url">{{__('lang.admin_android_download_url')}}</label>
                                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_android_download_url')}}" name="android_download_url" id="android_download_url" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                        </div>
                                        <div class="row mt-2">
                                            <h4> {{__('lang.admin_contact_setting')}}</h4>
                                            @foreach ($data as $row)
                                            @if($row->key=='contact_phone')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_phone">{{__('lang.admin_contact_phone')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_phone')}}" name="contact_phone" id="contact_phone" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='contact_email')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_email">{{__('lang.admin_contact_email')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_email')}}" name="contact_email" id="contact_email" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='contact_address')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_address">{{__('lang.admin_contact_address')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_address')}}" name="contact_address" id="contact_address" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='google_address_latitude')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="address_latitude">{{__('lang.admin_address_latitude')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_address_latitude')}}" name="google_address_latitude" id="address_latitude" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='google_address_longitude')
                                            <div class="col-md-4">
                                                <div class="mb-1">
                                                    <label class="form-label" for="address_longitude">{{__('lang.admin_address_longitude')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_address_longitude')}}" name="google_address_longitude" id="address_longitude" value="{{$row->value}}" />
                                                </div>
                                            </div>
                                            @endif
                                            @if($row->key=='contact_support_phone')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_support_phone">{{__('lang.admin_contact_support_phone')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_support_phone')}}" name="contact_support_phone" id="contact_support_phone" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        </div>
                                        <div class="row mt-2">
                                            <h4>{{__('lang.admin_seo_setting')}}</h4>
                                            @foreach ($data as $row)
                                                @if($row->key=='site_title')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="site_title">{{__('lang.admin_seo_title')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_title')}}" name="site_title" id="site_title" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                                @endif

                                                @if($row->key=='site_author')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="site_author">{{__('lang.admin_seo_author')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_author')}}" name="site_author" id="site_author" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                                @endif

                                                @if($row->key=='site_description')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="site_description">{{__('lang.admin_seo_description')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_description')}}" name="site_description" id="site_description" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                                @endif

                                                @if($row->key=='site_keyword')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="site_keyword">{{__('lang.admin_seo_keyword')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_keyword')}}" name="site_keyword" id="site_keyword" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                                @endif

                                                @if($row->key=='google_analytics')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="google_analytics">{{__('lang.admin_google_analytics')}}</label>
                                                        <textarea class="form-control" placeholder="{{__('lang.admin_google_analysis')}}" name="google_analytics" id="google_analytics">{{$row->value}}</textarea>
                                                    </div>
                                                </div>
                                                @endif
                                                @endforeach
                                            </div>
                                            <div class="row mt-2">
                                                <h4>{{__('lang.admin_logo_setting')}}</h4>
                                                @foreach ($data as $row)
                                                    @if($row->key=='website_logo')
                                                        <div class="col-md-3">
                                                            <div class="mb-1">
                                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Logo" class="website_logo users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                                <div class="img-footer">
                                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="website_logo">
                                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                                        <input class="form-control" type="file" id="website_logo" hidden accept="image/png, image/jpeg, image/jpg" name="website_logo" width="100%"
                                                                        height="500"
                                                                        style="border: 0;"
                                                                        allowfullscreen=""
                                                                        loading="lazy"/>
                                                                        <span class="d-block d-sm-none">
                                                                            <i class="me-0" data-feather="edit"></i>
                                                                        </span>
                                                                    </label>
                                                                    <p class="img-label">{{__('lang.admin_website_logo')}}</p>
                                                                    <p class="img-resolution">
                                                                    {{__('lang.admin_website_logo_resolution')}}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($row->key=='website_favicon')
                                                        <div class="col-md-3">
                                                            <div class="mb-1">
                                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Favicon" id="image-preview-1" class="about_product users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                                <div class="img-footer">
                                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-1">
                                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                                        <input class="form-control" type="file" id="change-picture-1" hidden accept="image/png, image/jpeg, image/jpg" name="website_favicon" onclick="showImagePreview('change-picture-1','image-preview-1');"/>
                                                                        <span class="d-block d-sm-none">
                                                                            <i class="me-0" data-feather="edit"></i>
                                                                        </span>
                                                                    </label>
                                                                    <p class="img-label">{{__('lang.admin_website_favicon')}}</p>
                                                                    <p class="img-resolution">
                                                                    {{__('lang.admin_website_favicon_resolution')}}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                @endforeach
                                            </div>
                                            @can('update-settings')
                                            <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                                <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                            </div>
                                            @endcan
                                        </div>
                                    {!! Form::close() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        $('[data-toggle="tooltip"]').tooltip();
    </script>
@endsection


