@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_sms_setting')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}

                                <input type="hidden" name="page_name" value="sms_setting">
                                    @csrf

                                    <div class="row mt-1 mb-4">
                                        <h3>{{__('lang.admin_sms_setting')}} <small class="form-text text-warning" id="help-text">( {{__('lang.admin_enable_single_sms_service_at_a_time')}})</small></h3>

                                        @foreach ($data as $row)
                                            @if($row->key=='enable_test_mode')
                                            <div class="demo-inline-spacing col-md-4">
                                                <div class="form-check form-switch tooltip-container">
                                                    <input type="checkbox" class="form-check-input" name="enable_test_mode" id="enable_test_mode" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                                    <label class="form-check-label" for="enable_test_mode">{{ __('lang.admin_is_enable_test_mode') }}</label>
                                                    <small class="form-text text-warning" id="testmode-help-text"></small>
                                                </div>
                                            </div>
                                            @endif
                                        @endforeach
                                    </div>
                                    <!-- Firebase -->
                                    <div class="row mt-2 firebase_fields">
                                        <h3>{{__('lang.admin_firebase_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if ($row->key == 'is_enable_firebase')
                                            <div class="demo-inline-spacing col-md-12 mb-2">
                                                <!-- Firebase Switch -->
                                                <div class="form-check form-switch tooltip-container" data-bs-toggle="tooltip" data-bs-placement="top" title="">
                                                    <input type="checkbox" class="form-check-input" name="is_enable_firebase" id="is_enable_firebase" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                                    <label class="form-check-label" for="is_enable_firebase">{{ __('lang.admin_enable_firebase') }}</label>
                                                    <small class="form-text text-warning" id="firebase-help-text"></small>
                                                </div>
                                            </div>
                                            @endif
                                            
                                            @if($row->key=='firebase_api_key')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label for="apiKey" class="form-label">{{__('lang.admin_firebase_api_key')}} ( required for sms)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_api_key')}}" name="firebase_api_key" id="apiKey" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach

                                        @foreach ($data as $row)
                                            @if($row->key=='firebase_auth_domain')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label for="authDomain" class="form-label">{{__('lang.admin_firebase_auth_domain')}}( required for sms)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_auth_domain')}}" name="firebase_auth_domain" id="authDomain" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        @foreach ($data as $row)
                                            @if($row->key=='firebase_storage_bucket')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label for="storageBucket" class="form-label">{{__('lang.admin_firebase_storage_bucket')}}( required for sms)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_storage_bucket')}}" name="firebase_storage_bucket" id="storageBucket" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        @foreach ($data as $row)
                                            @if($row->key=='firebase_messaging_sender_id')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label for="messagingSenderId" class="form-label">{{__('lang.admin_firebase_messaging_sender_id')}}( required for sms)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_messaging_sender_id')}}" name="firebase_messaging_sender_id" id="messagingSenderId" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        @foreach ($data as $row)
                                            @if($row->key=='firebase_app_id')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label for="appId" class="form-label">{{__('lang.admin_firebase_app_id')}}( required for notification)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_app_id')}}" name="firebase_app_id" id="appId" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='firebase_measurement_id')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label for="measurementId" class="form-label">{{__('lang.admin_firebase_measurement_id')}}( required for sms)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_measurement_id')}}" name="firebase_measurement_id" id="measurementId" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='firebase_messaging_vapid_publickey')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label for="firebase_messaging_vapid_publickey" class="form-label">{{__('lang.admin_firebase_messaging_vapid_publickey')}}( required for notification)</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_messaging_vapid_publickey')}}" name="firebase_messaging_vapid_publickey" id="firebase_vapid_publickey" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        <h3 class="form-control"><small class="form-text text-warning" id="help-text">{{__('lang.admin_note')}} : {{__('lang.admin_note_for_firebase_sms_service')}}</small></h3>
                                    </div>
                                    <p style="border: 1px solid darkturquoise ;margin-top: 10px;"></p>
                                    <!-- Twillio -->
                                    <div class="row mt-2 twilio_fields">
                                        <h3>{{__('lang.admin_twilio_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if($row->key=='is_enable_twilio')
                                            <div class="demo-inline-spacing col-md-12 mb-2">
                                                <!-- Twilio Switch -->
                                                <div class="form-check form-switch tooltip-container" data-bs-toggle="tooltip" data-bs-placement="top" title="">
                                                    <input type="checkbox" class="form-check-input" name="is_enable_twilio" id="is_enable_twilio" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                                    <label class="form-check-label" for="is_enable_twilio">{{ __('lang.admin_is_enable_twilio') }}</label>
                                                    <small class="form-text text-warning" id="twilio-help-text"></small>
                                                </div>
                                            </div>
                                            @endif
                                            @if($row->key=='twilio_account_sid')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twilio_account_sid">{{__('lang.admin_twilio_account_sid')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_twilio_account_sid')}}" name="twilio_account_sid" id="twilio_account_sid" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='twilio_auth_token')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twilio_auth_token">{{__('lang.admin_twilio_auth_token')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_twilio_auth_token')}}" name="twilio_auth_token" id="twilio_auth_token" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='twilio_phone_number')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twilio_phone_number">{{__('lang.admin_twilio_phone_number')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_twilio_phone_number')}}" name="twilio_phone_number" id="twilio_phone_number" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                    <p style="border: 1px solid darkturquoise;margin-top: 10px;"></p>
                                    <!-- Fast 2 SMS -->
                                    <div class="row mt-2 fast2sms_fields">
                                        <h3>{{__('lang.admin_fast_2_sms_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if ($row->key == 'is_enabled_fast_2_sms')
                                            <div class="demo-inline-spacing col-md-12 mb-2">
                                                <!-- Fast2Sms Switch -->
                                                <div class="form-check form-switch tooltip-container" data-bs-toggle="tooltip" data-bs-placement="top" title="">
                                                    <input type="checkbox" class="form-check-input" name="is_enabled_fast_2_sms" id="is_enabled_fast_2_sms" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                                    <label class="form-check-label" for="is_enabled_fast_2_sms">{{ __('lang.admin_enabled_fast_2_sms') }}</label>
                                                    <small class="form-text text-warning" id="fast2sms-help-text"></small>
                                                </div>
                                            </div>
                                            @endif
                                            
                                            @if($row->key=='fast_2_sms_api_key')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="fast_2_sms_api_key">{{__('lang.admin_fast_2_sms_api_key')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_fast_2_sms_api_key')}}" name="fast_2_sms_api_key" id="fast_2_sms_api_key" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='fast_2_sms_sender_id')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="fast_2_sms_sender_id">{{__('lang.admin_fast_2_sms_sender_id')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_fast_2_sms_sender_id')}}" name="fast_2_sms_sender_id" id="fast_2_sms_sender_id" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        <br class="mt-3">
                                    </div>
                                    <p style="border: 1px solid darkturquoise;margin-top: 10px;"></p>
                                    <!-- 2 Factor -->
                                    <div class="row mt-2 2factor_fields">
                                        <h3>{{__('lang.admin_2_factor_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if ($row->key == 'is_enabled_2_factor')
                                            <div class="demo-inline-spacing col-md-12 mb-2">
                                                <!-- 2 Factor Switch -->
                                                <div class="form-check form-switch tooltip-container" data-bs-toggle="tooltip" data-bs-placement="top" title="">
                                                    <input type="checkbox" class="form-check-input" name="is_enabled_2_factor" id="is_enabled_2_factor" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                                    <label class="form-check-label" for="is_enabled_2_factor">{{ __('lang.admin_enabled_2_factor') }}</label>
                                                    <small class="form-text text-warning" id="Factor2-help-text"></small>
                                                </div>
                                            </div>
                                            @endif
                                            
                                            @if($row->key=='2_factor_api_key')
                                                <div class="col-md-12">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="2_factor_api_key">{{__('lang.admin_2_factor_api_key')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_2_factor_api_key')}}" name="2_factor_api_key" id="2_factor_api_key" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        <br class="mt-3">
                                    </div>

                                    @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                    @endcan
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script>
    const adminSetAsDefaultText = "{{ __('lang.admin_set_as_default') }}";
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="{{asset('site-assets/js/sms_type_switch_handle.js')}}"></script>
<script>
    // Wait for the document to be ready
    $(document).ready(function () {
        // Handle the click event for is_enable_twilio checkbox
        $('input[name="is_enable_twilio"]').click(function () {
            if ($(this).prop('checked')) {
                $('input[name="is_enable_firebase"]').prop('checked', false);
                $('input[name="is_enabled_fast_2_sms"]').prop('checked', false);
                $('input[name="is_enabled_2_factor"]').prop('checked', false);
                $('input[name="enable_test_mode"]').prop('checked', false);
            }
        });

        // Handle the click event for is_enable_firebase checkbox
        $('input[name="is_enable_firebase"]').click(function () {
            if ($(this).prop('checked')) {
                $('input[name="is_enable_twilio"]').prop('checked', false);
                $('input[name="is_enabled_fast_2_sms"]').prop('checked', false);
                $('input[name="is_enabled_2_factor"]').prop('checked', false);
                $('input[name="enable_test_mode"]').prop('checked', false);
            }
        });
        
        
        // Handle the click event for is_enabled_fast_2_sms checkbox
        $('input[name="is_enabled_fast_2_sms"]').click(function () {
            if ($(this).prop('checked')) {
                $('input[name="is_enable_twilio"]').prop('checked', false);
                $('input[name="is_enable_firebase"]').prop('checked', false);
                $('input[name="enable_test_mode"]').prop('checked', false);
                $('input[name="is_enabled_2_factor"]').prop('checked', false);
            }
        });


        // Handle the click event for is_enabled_2_factor checkbox
        $('input[name="is_enabled_2_factor"]').click(function () {
            if ($(this).prop('checked')) {
                $('input[name="is_enable_twilio"]').prop('checked', false);
                $('input[name="is_enable_firebase"]').prop('checked', false);
                $('input[name="enable_test_mode"]').prop('checked', false);
                $('input[name="is_enabled_fast_2_sms"]').prop('checked', false);
            }
        });
        
        $('input[name="enable_test_mode"]').click(function () {
            if ($(this).prop('checked')) {
                $('input[name="is_enable_twilio"]').prop('checked', false);
                $('input[name="is_enable_firebase"]').prop('checked', false);
                $('input[name="is_enabled_fast_2_sms"]').prop('checked', false);
                $('input[name="is_enabled_2_factor"]').prop('checked', false);
            }
        });

    });

    document.addEventListener('DOMContentLoaded', function () {
    // Initialize tooltips for test mode hover
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });

</script>
@endsection
