@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_payment_gateway')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="basic-switches">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}

                                <input type="hidden" name="page_name" value="payment">

                                <!-- Other payment gatrway -->
                                <div class="row mt-2">
                                    <div class="col-md-8">
                                       <h3>{{__('lang.admin_payment_option')}}</h3>
                                    </div>
                                    <div class="col-md-4">
                                        @can('update-settings')
                                        <div class="float-end" style="float: inline-end;">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        </div>
                                        @endcan
                                    </div>
                                    @foreach ($data as $row)
                                            @if($row->key=='enable_cod')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <input type="checkbox" class="form-check-input" name="enable_cod" id="customSwitch2" value="1" <?php if($row->value=='1'){?>checked<?php } ?>/>
                                                        <label class="form-check-label" for="customSwitch2">{{__('lang.admin_payment_gateway_cod')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            @if($row->key=='enable_wallet')
                                            <div class="col-md-6 mb-2">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <input type="checkbox" class="form-check-input" name="enable_wallet" id="customSwitch3" value="1" <?php if($row->value=='1'){?>checked<?php } ?>/>
                                                        <label class="form-check-label" for="customSwitch3">{{__('lang.admin_payment_gateway_wallet')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                    @endforeach
                                </div>

                                <!-- Razorpay -->
                                <div class="row">
                                    <h3>{{__('lang.admin_razorpay_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_razorpay'))){ ?> <a title="{{__('lang.admin_razorpay_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?></h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_razorpay')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_razorpay'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_razorpay" id="customSwitch4" value="1" <?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch4">{{__('lang.admin_payment_gateway_razorpay')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='razorpay_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="razorpay_key">Razorpay Key</label>
                                                    <input type="text" class="form-control" placeholder="Razorpay Key" name="razorpay_key" id="razorpay_key" value="{{ \Helpers::maskApiKey($row->value)}}"  <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_razorpay'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='razorpay_secret')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="razorpay_secret">Razorpay Secret</label>
                                                    <input type="text" class="form-control" placeholder="Razorpay Secret" name="razorpay_secret" id="razorpay_secret" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_razorpay'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Stripe -->
                                <div class="row mt-3">
                                    <h3>{{__('lang.admin_stripe_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_stripe'))){ ?> <a title="{{__('lang.admin_stripe_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?>
                                    </h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_stripe')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <?php
                                                        // Check if the currency is supported
                                                        $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_stripe'));

                                                        // Set checked and disabled attributes based on currency support and row value
                                                        if ($currencySupported) {
                                                            $checked = ($row->value == '1') ? 'checked' : '';
                                                            $disabled = '';
                                                        } else {
                                                            $checked = ''; // Unchecked if currency is not supported
                                                            $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                        }
                                                    ?>
                                                    <div class="form-check form-switch">
                                                        <input type="checkbox" class="form-check-input" name="enable_stripe" id="customSwitch5" value="1" <?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch5">{{__('lang.admin_payment_gateway_stripe')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='stripe_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="stripe_key">{{__('lang.admin_stripe_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_stripe_key_placeholder')}}" name="stripe_key" id="stripe_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_stripe'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='stripe_secret_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="stripe_secret_key">{{__('lang.admin_stripe_secret_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_stripe_secret_key_placeholder')}}" name="stripe_secret_key" id="stripe_secret_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_stripe'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Paytm -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_paytm_payment_gateway')}} (Only For App) <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paytm'))){ ?> <a title="{{__('lang.admin_paytm_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?></h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_paytm')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_paytm'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_paytm" id="customSwitch7" value="1"<?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch7">{{__('lang.admin_payment_gateway_paytm')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paytm_merchant_id')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paytm_merchant_id">{{__('lang.admin_paytm_merchant_id')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paytm_merchant_id_placeholder')}}" name="paytm_merchant_id" id="paytm_merchant_id" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paytm'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paytm_merchant_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paytm_merchant_key">{{__('lang.admin_paytm_merchant_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paytm_merchant_key_placeholder')}}" name="paytm_merchant_key" id="paytm_merchant_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paytm'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paytm_merchant_website')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paytm_merchant_website">{{__('lang.admin_paytm_merchant_website')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paytm_merchant_website_placeholder')}}" name="paytm_merchant_website" id="paytm_merchant_website" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paytm'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paytm_channel')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paytm_channel">{{__('lang.admin_paytm_channel')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paytm_channel_placeholder')}}" name="paytm_channel" id="paytm_channel" value="{{$row->value}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paytm'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paytm_industry_type')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paytm_industry_type">{{__('lang.admin_paytm_industry_type')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paytm_industry_type_placeholder')}}" name="paytm_industry_type" id="paytm_industry_type" value="{{$row->value}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paytm'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Paypal -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_paypal_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paypal'))){ ?> <a title="{{__('lang.admin_paypal_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?></h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_paypal')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_paypal'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_paypal" id="customSwitch6" value="1"<?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch6">{{__('lang.admin_payment_gateway_paypal')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paypal_client_id')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paypal_client_id">{{__('lang.admin_paypal_client_id')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paypal_client_id_placeholder')}}" name="paypal_client_id" id="paypal_client_id" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paypal'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paypal_secret_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paypal_secret_key">{{__('lang.admin_paypal_secret_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paypal_secret_key_placeholder')}}" name="paypal_secret_key" id="paypal_secret_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paypal'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paypal_app_id')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paypal_app_id">{{__('lang.admin_paypal_app_id')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paypal_app_id')}}" name="paypal_app_id" id="paypal_app_id" value="{{ $row->value ?? ''}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paypal'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Phonepe -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_phone_payment_gateway')}}  <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_phonepe'))){ ?> <a title="{{__('lang.admin_phonepe_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?> </h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_phonepe')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_phonepe'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_phonepe" id="customSwitch8" value="1" <?php echo $checked; ?> <?php echo $disabled; ?> />
                                                        <label class="form-check-label" for="customSwitch8">{{__('lang.admin_payment_gateway_phonepe')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='phonepe_merchant_id')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="phonepe_merchant_id">{{__('lang.admin_phonepe_merchant_id')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_phonepe_merchant_id_placeholder')}}" name="phonepe_merchant_id" id="phonepe_merchant_id" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_phonepe'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='phonepe_salt_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="phonepe_salt_key">{{__('lang.admin_phonepe_salt_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_phonepe_salt_key_placeholder')}}" name="phonepe_salt_key" id="phonepe_salt_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_phonepe'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Instamojo -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_instamojo_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_instamojo'))){ ?> <a title="{{__('lang.admin_instamojo_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?> </h3>
                                    @foreach ($data as $row)
                                         @if($row->key=='enable_instamojo')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_instamojo'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_instamojo" id="customSwitch9" value="1" <?php echo $checked; ?> <?php echo $disabled; ?> />
                                                        <label class="form-check-label" for="customSwitch9">{{__('lang.admin_payment_gateway_instamojo')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='instamojo_api_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="instamojo_api_key">{{__('lang.admin_instamojo_api_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_instamojo_api_key_placeholder')}}" name="instamojo_api_key" id="instamojo_api_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_instamojo'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='instamojo_auth_token')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="instamojo_auth_token">{{__('lang.admin_instamojo_auth_token')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_instamojo_auth_token_placeholder')}}" name="instamojo_auth_token" id="instamojo_auth_token" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_instamojo'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='instamojo_api_endpoint')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="instamojo_api_endpoint">{{__('lang.admin_instamojo_api_endpoint')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_instamojo_api_endpoint_placeholder')}}" name="instamojo_api_endpoint" id="instamojo_api_endpoint" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_instamojo'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Flutterwave -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_flutter_rave_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_flutterwave'))){ ?> <a title="{{__('lang.admin_flutterwave_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?> </h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_flutterwave')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_flutterwave'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_flutterwave" id="customSwitch10" value="1" <?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch10">{{__('lang.admin_payment_gateway_flutterwave')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='rave_public_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="rave_public_key">{{__('lang.admin_rave_public_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_rave_public_key_placeholder')}}" name="rave_public_key" id="rave_public_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_flutterwave'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='rave_secret_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="rave_secret_key">{{__('lang.admin_rave_secret_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_rave_secret_key_placeholder')}}" name="rave_secret_key" id="rave_secret_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_flutterwave'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='rave_encryption_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="rave_encryption_key">{{__('lang.admin_rave_encryption_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_rave_encryption_key_placeholder')}}" name="rave_encryption_key" id="rave_encryption_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_flutterwave'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>


                                <!-- Paystack -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_paystack_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paystack'))){ ?> <a title="{{__('lang.admin_paystack_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?> </h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_paystack')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_paystack'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_paystack" id="customSwitch11" value="1" <?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch11">{{__('lang.admin_payment_gateway_paystack')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paystack_public_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paystack_public_key">{{__('lang.admin_paystack_public_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paystack_public_key_placeholder')}}" name="paystack_public_key" id="paystack_public_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paystack'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paystack_secret_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paystack_secret_key">{{__('lang.admin_paystack_secret_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paystack_secret_key_placeholder')}}" name="paystack_secret_key" id="paystack_secret_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paystack'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='paystack_merchant_email')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="paystack_merchant_email">{{__('lang.admin_paystack_merchant_email')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_paystack_merchant_email_placeholder')}}" name="paystack_merchant_email" id="paystack_merchant_email" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paystack'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif

                                    @endforeach
                                </div>


                                <!-- LiqPay -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_liqpay_payment_gateway')}} <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_liqpay'))){ ?> <a title="{{__('lang.admin_paystack_payment_gateway_not_support_currency')}}" style="color: red;"><i data-feather="info"></i></a> <?php }?> </h3>
                                    @foreach ($data as $row)
                                        @if($row->key=='enable_liqpay')
                                            <div class="col-md-6">
                                                <div class="demo-inline-spacing">
                                                    <div class="form-check form-switch">
                                                        <?php
                                                            // Check if the currency is supported
                                                            $currencySupported = in_array(setting('default_currency_code'), config('constant.supported_currencies_liqpay'));

                                                            // Set checked and disabled attributes based on currency support and row value
                                                            if ($currencySupported) {
                                                                $checked = ($row->value == '1') ? 'checked' : '';
                                                                $disabled = '';
                                                            } else {
                                                                $checked = ''; // Unchecked if currency is not supported
                                                                $disabled = 'disabled'; // Add 'disabled' attribute to prevent user interaction
                                                            }
                                                        ?>
                                                        <input type="checkbox" class="form-check-input" name="enable_liqpay" id="customSwitch12" value="1" <?php echo $checked; ?> <?php echo $disabled; ?>/>
                                                        <label class="form-check-label" for="customSwitch12">{{__('lang.admin_payment_gateway_liqpay')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='liqpay_public_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="liqpay_public_key">{{__('lang.admin_liqpay_public_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_liqpay_public_key_placeholder')}}" name="liqpay_public_key" id="liqpay_public_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_liqpay'))){ echo "readonly"; } ?>/>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='liqpay_private_key')
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="liqpay_private_key">{{__('lang.admin_liqpay_private_key')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_liqpay_private_key_placeholder')}}" name="liqpay_private_key" id="liqpay_private_key" value="{{ \Helpers::maskApiKey($row->value)}}" <?php if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_liqpay'))){ echo "readonly"; } ?> />
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection

<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function () {
        const razorpayKey = document.getElementById('razorpay_key');
        const razorpaySecret = document.getElementById('razorpay_secret');
        const enableRazorpaySwitch = document.getElementById('customSwitch4');

        function toggleRazorpaySwitch() {
            if (razorpayKey.value.trim() === '' || razorpaySecret.value.trim() === '') {
                enableRazorpaySwitch.checked = false;
                enableRazorpaySwitch.disabled = true;
            } else {
                enableRazorpaySwitch.disabled = false;
            }
        }

        // Add event listeners
        razorpayKey.addEventListener('input', toggleRazorpaySwitch);
        razorpaySecret.addEventListener('input', toggleRazorpaySwitch);

        // Initial check
        toggleRazorpaySwitch();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const stripeKey = document.getElementById('stripe_key');
        const stripeSecret = document.getElementById('stripe_secret_key');
        const enableStripeSwitch = document.getElementById('customSwitch5');

        function toggleStripeSwitch() {
            if (stripeKey.value.trim() === '' || stripeSecret.value.trim() === '') {
                enableStripeSwitch.checked = false;
                enableStripeSwitch.disabled = true;
            } else {
                enableStripeSwitch.disabled = false;
            }
        }

        // Add event listeners
        stripeKey.addEventListener('input', toggleStripeSwitch);
        stripeSecret.addEventListener('input', toggleStripeSwitch);

        // Initial check
        toggleStripeSwitch();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const paytmMerchantId = document.getElementById('paytm_merchant_id');
        const paytmMerchantKey = document.getElementById('paytm_merchant_key');
        const paytm_merchant_website = document.getElementById('paytm_merchant_website');
        const paytm_industry_type = document.getElementById('paytm_industry_type');
        const paytm_channel = document.getElementById('paytm_channel');
        const enablePaytmSwitch = document.getElementById('customSwitch7');

        function togglePaytmSwitch() {
            if (paytmMerchantId.value.trim() === '' || paytmMerchantKey.value.trim() === '' || paytm_merchant_website.value.trim() === '' || paytm_industry_type.value.trim() === '' || paytm_channel.value.trim() === '') {
                enablePaytmSwitch.checked = false;
                enablePaytmSwitch.disabled = true;
            } else {
                enablePaytmSwitch.disabled = false;
            }
        }

        // Add event listeners
        paytmMerchantId.addEventListener('input', togglePaytmSwitch);
        paytmMerchantKey.addEventListener('input', togglePaytmSwitch);
        paytm_merchant_website.addEventListener('input', togglePaytmSwitch);
        paytm_industry_type.addEventListener('input', togglePaytmSwitch);
        paytm_channel.addEventListener('input', togglePaytmSwitch);

        // Initial check
        togglePaytmSwitch();
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const paypalClientId = document.getElementById('paypal_client_id');
        const paypalSecretKey = document.getElementById('paypal_secret_key');
        const paypal_app_id = document.getElementById('paypal_app_id');
        const enablePayPalSwitch = document.getElementById('customSwitch6');

        function togglePayPalSwitch() {
            if (paypalClientId.value.trim() === '' || paypalSecretKey.value.trim() === '' || paypal_app_id.value.trim() === '') {
                enablePayPalSwitch.checked = false;
                enablePayPalSwitch.disabled = true;
            } else {
                enablePayPalSwitch.disabled = false;
            }
        }

        // Add event listeners
        paypalClientId.addEventListener('input', togglePayPalSwitch);
        paypalSecretKey.addEventListener('input', togglePayPalSwitch);
        paypal_app_id.addEventListener('input', togglePayPalSwitch);

        // Initial check
        togglePayPalSwitch();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const phonepeMerchantId = document.getElementById('phonepe_merchant_id');
        const phonepeSaltKey = document.getElementById('phonepe_salt_key');
        const enablePhonePeSwitch = document.getElementById('customSwitch8');

        function togglePhonePeSwitch() {
            if (phonepeMerchantId.value.trim() === '' || phonepeSaltKey.value.trim() === '') {
                enablePhonePeSwitch.checked = false;
                enablePhonePeSwitch.disabled = true;
            } else {
                enablePhonePeSwitch.disabled = false;
            }
        }

        // Add event listeners
        phonepeMerchantId.addEventListener('input', togglePhonePeSwitch);
        phonepeSaltKey.addEventListener('input', togglePhonePeSwitch);

        // Initial check
        togglePhonePeSwitch();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const instamojoApiKey = document.getElementById('instamojo_api_key');
        const instamojoAuthToken = document.getElementById('instamojo_auth_token');
        const enableInstamojoSwitch = document.getElementById('customSwitch9');

        function toggleInstamojoSwitch() {
            if (instamojoApiKey.value.trim() === '' || instamojoAuthToken.value.trim() === '') {
                enableInstamojoSwitch.checked = false;
                enableInstamojoSwitch.disabled = true;
            } else {
                enableInstamojoSwitch.disabled = false;
            }
        }

        // Add event listeners
        instamojoApiKey.addEventListener('input', toggleInstamojoSwitch);
        instamojoAuthToken.addEventListener('input', toggleInstamojoSwitch);

        // Initial check
        toggleInstamojoSwitch();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const flutterwaveTxRef = document.getElementById('rave_public_key');
        const flutterwaveAmount = document.getElementById('rave_secret_key');
        const rave_encryption_key = document.getElementById('rave_encryption_key');
        const enableRaveSwitch = document.getElementById('customSwitch10');

        function toggleFlutterwaveButton() {
            if (flutterwaveTxRef.value.trim() === '' || flutterwaveAmount.value.trim() === '' || rave_encryption_key.value.trim() === '') {
                enableRaveSwitch.disabled = true;
            } else {
                enableRaveSwitch.disabled = false;
            }
        }

        // Add event listeners
        flutterwaveTxRef.addEventListener('input', toggleFlutterwaveButton);
        flutterwaveAmount.addEventListener('input', toggleFlutterwaveButton);
        rave_encryption_key.addEventListener('input', toggleFlutterwaveButton);

        // Initial check
        toggleFlutterwaveButton();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const paystackPublicKey = document.getElementById('paystack_public_key');
        const paystackSecretKey = document.getElementById('paystack_secret_key');
        const enablePaystackSwitch = document.getElementById('customSwitch11');

        function togglePaystackSwitch() {
            if (paystackPublicKey.value.trim() === '' || paystackSecretKey.value.trim() === '') {
                enablePaystackSwitch.checked = false;
                enablePaystackSwitch.disabled = true;
            } else {
                enablePaystackSwitch.disabled = false;
            }
        }

        // Add event listeners
        paystackPublicKey.addEventListener('input', togglePaystackSwitch);
        paystackSecretKey.addEventListener('input', togglePaystackSwitch);

        // Initial check
        togglePaystackSwitch();
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const liqpayPublicKey = document.getElementById('liqpay_public_key');
        const liqpayPrivateKey = document.getElementById('liqpay_private_key');
        const enableLiqPaySwitch = document.getElementById('customSwitch12');

        function toggleLiqPaySwitch() {
            if (liqpayPublicKey.value.trim() === '' || liqpayPrivateKey.value.trim() === '') {
                enableLiqPaySwitch.checked = false;
                enableLiqPaySwitch.disabled = true;
            } else {
                enableLiqPaySwitch.disabled = false;
            }
        }

        // Add event listeners
        liqpayPublicKey.addEventListener('input', toggleLiqPaySwitch);
        liqpayPrivateKey.addEventListener('input', toggleLiqPaySwitch);

        // Initial check
        toggleLiqPaySwitch();
    });
</script>