@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_order_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                                <input type="hidden" name="page_name" value="orders">
                                <div class="row">
                                    @foreach ($data as $row)
                                    @if($row->key=='default_tax')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="default_tax">{{__('lang.admin_default_tax_in')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_default_tax_in')}}" name="default_tax" id="default_tax" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='shipping_charge')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="shipping_charge">{{__('lang.admin_shipping_charge_in')}} {{-- {{setting('default_currency_code')}} --}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_shipping_charge_in')}}" name="shipping_charge" id="shipping_charge" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='minimum_order_value')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="minimum_order_value">{{__('lang.admin_min_order_value_in')}} {{-- {{setting('default_currency_code')}} --}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_min_order_value_in')}}" name="minimum_order_value" id="minimum_order_value" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='is_enable_mail_order_receive')
                                        <div class="col-md-4">
                                            <div class="demo-inline-spacing">
                                                <div class="form-check form-switch">
                                                    <input type="checkbox" class="form-check-input" name="is_enable_mail_order_receive" id="is_enable_mail_order_receive" value="1" <?php if($row->value=='1'){?>checked<?php } ?>/>
                                                    <label class="form-check-label" for="is_enable_mail_order_receive">{{__('lang.enable_mail_order_btn')}}</label>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    @if($row->key=='nearest_delivery_date')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="nearest_delivery_date">{{__('lang.admin_nearest_delivery_date_user_can_select')}}</label>
                                            <select class="form-control form-select" name="nearest_delivery_date">
                                                <option <?=$row->key == 0?> value="0">{{__('lang.admin_current_date')}}</option>
                                                <?php for ($i = 1; $i <= 9; $i++): ?>
                                                    <option <?=$row->value == $i ? 'selected' : ''?> value="<?=$i?>"><?=$i?></option>
                                                 <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                    @endif

                                    @endforeach

                                    @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                    @endcan

                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection