@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_push_notification')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf

                                <input type="hidden" name="page_name" value="notifications">

                                <!-- One Signal Notification -->
                                <div class="row">
                                    <h3>{{__('lang.admin_one_signal_notification')}}</h3>
                                    @foreach ($data as $row)
                                        @if($row->key == 'is_enable_one_signal')
                                            <div class="col-md-2 mt-2">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="is_enable_one_signal" name="is_enable_one_signal" value="1" {{ $row->value == '1' ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="is_enable_one_signal">{{ __('lang.admin_is_enable_one_signal') }}</label>
                                                </div>
                                            </div>
                                        @endif

                                        @if($row->key == 'one_signal_key')
                                            <div class="col-md-5 display-inline-block">
                                                <label class="form-label" for="one_signal_key">{{__('lang.admin_one_signal_key')}}</label>
                                                <input type="text" class="form-control" value="{{ \Helpers::maskApiKey($row->value)}}" name="one_signal_key" placeholder="{{__('lang.admin_one_signal_key_placeholder')}}">
                                            </div>
                                        @endif
                                        @if($row->key == 'one_signal_app_id')
                                            <div class="col-md-5 display-inline-block">
                                                <label class="form-label" for="one_signal_app_id">{{__('lang.admin_one_signal_app_id')}}</label>
                                                <input type="text" class="form-control" value="{{ \Helpers::maskApiKey($row->value)}}" name="one_signal_app_id" placeholder="{{__('lang.admin_one_signal_app_id_placeholder')}}">
                                            </div>
                                        @endif
                                    @endforeach
                                </div>

                                <!-- Firebase Notification -->
                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_firebase_notification')}}</h3>
                                    @foreach ($data as $row)
                                        @if($row->key == 'is_enable_firebase_notification')
                                            <div class="col-md-2 mt-2">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="is_enable_firebase_notification" name="is_enable_firebase_notification" value="1" {{ $row->value == '1' ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="is_enable_firebase_notification">{{ __('lang.admin_is_enable_firebase_notification') }}</label>
                                                </div>
                                            </div>
                                        @endif
                                        @if($row->key=='firebase_project_id')
                                            <div class="col-md-4">
                                                <div class="mb-1">
                                                    <label for="projectId" class="form-label">{{__('lang.admin_firebase_project_id')}}( required for sms)</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_firebase_project_id')}}" name="firebase_project_id" id="projectId" value="{{ \Helpers::maskApiKey($row->value)}}" />
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                        <div class="col-md-6">
                                            <label class="form-label" for="upload-json">{{__('lang.admin_firebase_credential_json')}} ({{__('lang.admin_required_for_notification')}})</label>
                                            <div class="mb-1">
                                                <div class="col-12 d-flex px-0">
                                                    <label class="" for="upload-json">
                                                        <input type="file" name="firebase_json_file" id="upload-json" class="form-control" accept=".json">
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                </div>
                                            </div>
                                            @if(Storage::exists('public/firebase/firebase_credentials.json'))
                                                <p> {{__('lang.admin_file_is_uploaded')}} : {{__('lang.admin_yes')}}</p>
                                            @else
                                            <p>{{__('lang.admin_file_is_uploaded')}} : {{__('lang.admin_no')}}</p>
                                            @endif
                                        </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>

<script>
    // Wait for the document to be ready
    $(document).ready(function () {
        // Handle the click event for is_enable_one_signal checkbox
        $('input[name="is_enable_one_signal"]').click(function () {
            // If is_enable_one_signal is checked, uncheck is_enable_firebase
            if ($(this).prop('checked')) {
                $('input[name="is_enable_firebase_notification"]').prop('checked', false);
            }
        });

        // Handle the click event for is_enable_firebase checkbox
        $('input[name="is_enable_firebase_notification"]').click(function () {
            // If is_enable_firebase is checked, uncheck is_enable_one_signal
            if ($(this).prop('checked')) {
                $('input[name="is_enable_one_signal"]').prop('checked', false);
            }
        });
    });
</script>
@endsection
