@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_email_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}

                                <input type="hidden" name="page_name" value="sms_setting">

                                    @csrf   
                                    <div class="row mt-2">
                                        <h3>{{__('lang.admin_firebase_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if($row->key=='enable_firebase_message')
                                                <div class="col-md-4 mt-2">
                                                    <input <?php if($row->value=='1'){?>checked<?php } ?> class="form-check-input" type="checkbox" name="enable_firebase_message" value="1"/>
                                                    <label class="form-check-label" for="enable_firebase_message">{{__('lang.admin_is_enable_firebase')}}</label>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>                                  
                                    <!-- <div class="row mt-2">
                                        <h3>{{__('lang.admin_twilio_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if($row->key=='is_enable_twilio')
                                                <div class="col-md-2 mt-2">
                                                    <input <?php if($row->value=='1'){?>checked<?php } ?> class="form-check-input" type="checkbox" name="is_enable_twilio" value="1"/>
                                                    <label class="form-check-label" for="is_enable_twilio">{{__('lang.admin_is_enable_twilio')}}</label>
                                                </div>
                                            @endif
                                            @if($row->key=='twilio_account_sid')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twilio_account_sid">{{__('lang.admin_twilio_account_sid')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_twilio_account_sid')}}" name="twilio_account_sid" id="twilio_account_sid" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='twilio_auth_token')
                                                <div class="col-md-3">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twilio_auth_token">{{__('lang.admin_twilio_auth_token')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_twilio_auth_token')}}" name="twilio_auth_token" id="twilio_auth_token" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='twilio_phone_number')
                                                <div class="col-md-3">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twilio_phone_number">{{__('lang.admin_twilio_phone_number')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_twilio_phone_number')}}" name="twilio_phone_number" id="twilio_phone_number" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach

                                    </div> -->


                                     <!-- <div class="row mt-2">
                                        <h3>Msg91 Configuration</h3>
                                        @foreach ($data as $row)
                                            @if($row->key=='is_enable_msg91')
                                                <div class="col-md-2 mt-2">
                                                    <input <?php if($row->value=='1'){?>checked<?php } ?> class="form-check-input" type="checkbox" name="is_enable_msg91" value="1"/>
                                                    <label class="form-check-label" for="is_enable_msg91">{{__('lang.admin_is_enable_msg91')}}</label>
                                                </div>
                                            @endif
                                            @if($row->key=='msg91_auth_key')
                                                <div class="col-md-5">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="msg91_auth_key">{{__('lang.admin_msg91_auth_key')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_msg91_auth_key')}}" name="msg91_auth_key" id="msg91_auth_key" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                           
                                            @if($row->key=='msg91_sender_id')
                                                <div class="col-md-5">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="msg91_sender_id">{{__('lang.admin_msg91_sender_id')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_msg91_sender_id')}}" name="msg91_sender_id" id="msg91_sender_id" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach

                                    </div> -->
                                
                                    @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                    @endcan

                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>

<script>
    // Wait for the document to be ready
    $(document).ready(function () {
        // Handle the click event for is_enable_twilio checkbox
        $('input[name="is_enable_twilio"]').click(function () {
            // If is_enable_twilio is checked, uncheck is_enable_msg91
            if ($(this).prop('checked')) {
                $('input[name="is_enable_firebase"]').prop('checked', false);
            }
        });

        // Handle the click event for is_enable_msg91 checkbox
        $('input[name="is_enable_firebase"]').click(function () {
            // If is_enable_msg91 is checked, uncheck is_enable_twilio
            if ($(this).prop('checked')) {
                $('input[name="is_enable_twilio"]').prop('checked', false);
            }
        });
    });
</script>
@endsection