@extends('layouts.app')
@section('content')

<style type="text/css">
label.form-label {
    float: none!important;
}
</style>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_home_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                    @csrf   
                                    <input type="hidden" name="page_name" value="homepage_settings">                                 
                                    <div class="row">
                                        @foreach ($data as $row)

                                        @if($row->key=='about_product')
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="About Product" id="image-preview-1" class="about_product users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                <div class="img-footer">
                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-1">
                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                        <input class="form-control" type="file" id="change-picture-1" hidden accept="image/png, image/jpeg, image/jpg" name="about_product" onclick="showImagePreview('change-picture-1','image-preview-1');"/>
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                    <p class="img-label">{{__('lang.admin_about_product')}}</p>
                                                    <p class="img-resolution">
                                                    {{__('lang.admin_about_product_resolution')}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                        
                                        @if($row->key=='mobile_image')
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Mobile Image" id="image-preview-2" class="mobile_image users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                <div class="img-footer">
                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-2">
                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                        <input class="form-control" type="file" id="change-picture-2" hidden accept="image/png, image/jpeg, image/jpg" name="mobile_image" onclick="showImagePreview('change-picture-2','image-preview-2');"/>
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                    <p class="img-label">{{__('lang.admin_mobile_image')}}</p>
                                                    <p class="img-resolution">
                                                    {{__('lang.admin_mobile_image_resolution')}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @endforeach

                                        
                                    </div>
                                    <div class="row mt-2">

                                    <h3>{{__('lang.admin_top_four_information_boxes_image')}}</h3>

                                        @foreach ($data as $row)
                                        
                                        @if($row->key=='icon_1')
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" id="image-preview-A" class="icon_1 users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                <div class="img-footer">
                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-A">
                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                        <input class="form-control" type="file" id="change-picture-A" hidden accept="image/png, image/jpeg, image/jpg" name="icon_1" onclick="showImagePreview('change-picture-A','image-preview-A');"/>
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                    <p class="img-label">{{__('lang.admin_website_icon1')}}</p>
                                                    <p class="img-resolution">
                                                    {{__('lang.admin_website_icon1_resolution')}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='icon_2')
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" id="image-preview-B" class="icon_2 users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                <div class="img-footer">
                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-B">
                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                        <input class="form-control" type="file" id="change-picture-B" hidden accept="image/png, image/jpeg, image/jpg" name="icon_2" onclick="showImagePreview('change-picture-B','image-preview-B');"/>
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                    <p class="img-label">{{__('lang.admin_website_icon2')}}</p>
                                                    <p class="img-resolution">
                                                    {{__('lang.admin_website_icon2_resolution')}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='icon_3')
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" id="image-preview-C" class="icon_3 users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>

                                                <div class="img-footer">
                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-C">
                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                        <input class="form-control" type="file" id="change-picture-C" hidden accept="image/png, image/jpeg, image/jpg" name="icon_3" onclick="showImagePreview('change-picture-C','image-preview-C');"/>
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                    <p class="img-label">{{__('lang.admin_website_icon3')}}</p>
                                                    <p class="img-resolution">
                                                    {{__('lang.admin_website_icon3_resolution')}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='icon_4')
                                        <div class="col-md-3">
                                            <div class="mb-1">
                                                <img src="{{asset('site-assets/images/website/'.$row->value)}}" id="image-preview-D" class="icon_4 users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                <div class="img-footer">
                                                    <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-D">
                                                        <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                        <input class="form-control" type="file" id="change-picture-D" hidden accept="image/png, image/jpeg, image/jpg" name="icon_4" onclick="showImagePreview('change-picture-D','image-preview-D');"/>
                                                        <span class="d-block d-sm-none">
                                                            <i class="me-0" data-feather="edit"></i>
                                                        </span>
                                                    </label>
                                                    <p class="img-label">{{__('lang.admin_website_icon4')}}</p>
                                                    <p class="img-resolution">
                                                    {{__('lang.admin_website_icon4_resolution')}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @endforeach
                                        
                                        @can('update-settings')
                                        <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        </div>
                                        @endcan
                                        
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection