@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_global_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                                <input type="hidden" name="page_name" value="global_settings">
                                <div class="row">

                                    <h3>{{__('lang.admin_timezone_configuration')}}</h3>

                                    @foreach ($data as $row)
                                    @if($row->key=='timezone')
                                    <div class="col-md-3">
                                        <div class="mb-1">
                                            <label for="timezone"> {{__('lang.admin_timezone')}}:</label>
                                            <select class="form-select js-states" name="timezone" id="timezone" name="timezone" style="cursor: pointer;"></select>
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='date_format')
                                    <div class="col-md-3">
                                        <div class="mb-1">
                                            <label class="form-label" for="date_format">{{__('lang.admin_date_format')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_date_format')}}" name="date_format" id="date_format" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='date_time_format')
                                    <div class="col-md-3">
                                        <div class="mb-1">
                                            <label class="form-label" for="date_format">{{__('lang.admin_date_time_format')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_date_time_format')}}" name="date_time_format" id="date_time_format" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='time_format')
                                    <div class="col-md-3">
                                        <div class="mb-1">
                                            <label class="form-label" for="date_format">{{__('lang.admin_time_format')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_time_format')}}" name="time_format" id="time_format" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach

                                </div>

                                <div class="row mt-2">
                                    <h3>{{__('lang.admin_google_translate_configuration')}}</h3> 
                                    @foreach ($data as $row)
                                        @if($row->key=='google_translate_api_key')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="date_format">{{__('lang.admin_google_translate_api_key')}}</label>
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_google_translate_api_key')}}" name="google_translate_api_key" id="google_translate_api_key" value="{{ \Helpers::maskApiKey($row->value)}}"/>
                                            </div>
                                        </div>
                                        @endif
                                    @endforeach
                                </div>
                                
                                
                                <div class="row mt-2">
                                        <h3>{{__('lang.admin_enable_countries_for_signin')}}</h3>
                                        <select name="countryCodes[]" id="countryCode" class="form-select signin_countryCode" multiple="multiple">
                                            @php
                                                if(!empty($data[$country_key])){
                                                    $value = $data[$country_key]->value;
                                                }else{
                                                    $value = [];
                                                }
                                            @endphp
                                            @foreach ($countries as $country)
                                                <option value="{{$country['value']}}" @if(in_array($country['value'], $value)) selected="true" @endif>{{$country['label']}}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="countryCodesArray" id="countryCodesArray" />
                                    </div>
                                    
                                @can('update-settings')
                                <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                    <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                </div>
                                @endcan
                                    
                                {!! Form::close() !!}
                                
                                <hr class="mb-2 mt-2">
                                <div class="tab-pane active mt-3" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <h3>{{__('lang.admin_google_map_configuration')}} ({{__('lang.admin_website')}})</h3> 
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                                <input type="hidden" name="page_name" value="google_map_address">
                                <div class="row">
                                    @foreach ($data as $row)
                                    @if($row->key=='google_address_map_api_key')
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="google_address_map_api_key">{{__('lang.admin_google_address_map_api_key')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_google_address_map_api_key')}}" name="google_address_map_api_key" id="google_address_map_api_key" value="{{ \Helpers::maskApiKey($row->value)}}" required/>
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='is_enable_google_map_address')
                                        <div class="col-md-6">
                                            <div class="demo-inline-spacing">
                                                <div class="form-check form-switch">
                                                    <input type="checkbox" class="form-check-input" name="is_enable_google_map_address" id="is_enable_google_map_address" value="1" <?php if($row->value=='1'){?>checked<?php } ?>/>
                                                    <label class="form-check-label" for="is_enable_google_map_address">{{__('lang.admin_is_enable_google_map_add_address')}}</label>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    @endforeach

                                    @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                    @endcan

                                </div>
                                {!! Form::close() !!}
                            </div>
                            
                                <hr class="mb-2 mt-2">
                                <div class="tab-pane active mt-3" id="account" aria-labelledby="account-tab" role="tabpanel">
                                 <h3>{{__('lang.admin_google_map_configuration')}} ({{__('lang.admin_app')}})</h3> 
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                                <input type="hidden" name="page_name" value="app_google_map_address">
                                <div class="row">
                                    @foreach ($data as $row)
                                    @if($row->key=='is_enable_app_google_map_address')
                                        <div class="col-md-6">
                                            <div class="demo-inline-spacing">
                                                <div class="form-check form-switch">
                                                    <input type="checkbox" class="form-check-input" name="is_enable_app_google_map_address" id="is_enable_app_google_map_address" value="1" <?php if($row->value=='1'){?>checked<?php } ?>/>
                                                    <label class="form-check-label" for="is_enable_app_google_map_address">{{__('lang.admin_is_enable_app_google_map_add_address')}}</label>
                                                </div>
                                            </div>
                                        </div>
                                        <p class="mt-1 text-danger">{{__('lang.admin_note')}} :- {{__('lang.admin_google_map_setup_intruction_in_app')}} <a target="_blank" href="https://docs.fluttertop.com/freshu/"><span class="text-primary">{{__('lang.admin_click_here')}} </span></a></p>
                                    @endif

                                    @endforeach

                                    @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                    @endcan

                                </div>
                                {!! Form::close() !!}
                            </div>
                                    
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<!-- Include moment library first -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
<!-- Then include moment-timezone -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment-timezone/0.5.33/moment-timezone-with-data.min.js"></script>


<script>
    var select = document.getElementById("timezone");
    var timezones = moment.tz.names();
    var selectedTimezone = "<?php foreach ($data as $row){  if($row->key=='timezone'){ echo $row->value; } }?>";

    for (var i = 0; i < timezones.length; i++) {
        var option = document.createElement("option");
        option.value = timezones[i];
        option.text = timezones[i];

        if (timezones[i] === selectedTimezone) {
            option.selected = true;
        }

        select.add(option);
    }
</script>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
<!-- Select2 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
<script>
     $("#timezone").select2({
         placeholder: "Select a Timezone",
         allowClear: true
     });
  
    $('.signin_countryCode').select2({
        placeholder: 'Select countries', // Placeholder text
        allowClear: true, // Optional: Allows clearing the selection
    });
</script>
@endsection