@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_email_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                    @csrf
                                    <input type="hidden" name="page_name" value="email_setting">     
                                    <div class="row">
                                        <h3>{{__('lang.admin_mail_configuration')}}</h3>
                                        @foreach ($data as $row)
                                            @if($row->key=='mail_driver')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_driver">{{__('lang.admin_mail_driver')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_driver')}}" name="mail_driver" id="mail_driver" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='mail_host')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_host">{{__('lang.admin_mail_host')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_host')}}" name="mail_host" id="mail_host" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='mail_port')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_port">{{__('lang.admin_mail_port')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_port')}}" name="mail_port" id="mail_port" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='mail_username')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_username">{{__('lang.admin_mail_username')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_username')}}" name="mail_username" id="mail_username" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='mail_password')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_password">{{__('lang.admin_mail_password')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_password')}}" name="mail_password" id="mail_password" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='mail_encrytion')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_encrytion">{{__('lang.admin_mail_encrytion')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_encrytion')}}" name="mail_encrytion" id="mail_encrytion" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='mail_from_address')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="mail_from_address">{{__('lang.admin_mail_from_address')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_from_address')}}" name="mail_from_address" id="mail_from_address" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                        @if($row->key=='mail_from_name')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="mail_from_name">{{__('lang.admin_mail_from_name')}}</label>
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_mail_from_name')}}" name="mail_from_name" id="mail_from_name" value="{{$row->value}}" />
                                            </div>
                                        </div>
                                        @endif

                                        

                                        @endforeach
                                        
                                    </div>

                                @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                @endcan

                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection