@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_deeplink_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                    @csrf  

                                    <input type="hidden" name="page_name" value="deeplink_setting"> 
                                    <div class="row mt-2">
                                        @foreach ($data as $row)
                                            @if($row->key=='android_schema_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="android_schema_url">{{__('lang.admin_android_schema_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_android_schema_url_placeholder')}}" name="android_schema_url" id="android_schema_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='playstore_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="playstore_url">{{__('lang.admin_playstore_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_playstore_url_placeholder')}}" name="playstore_url" id="playstore_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='ios_schema_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="ios_schema_url">{{__('lang.admin_ios_schema_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_ios_schema_url_placeholder')}}" name="ios_schema_url" id="ios_schema_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='appstore_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="appstore_url">{{__('lang.admin_appstore_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_appstore_url_placeholder')}}" name="appstore_url" id="appstore_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                            

                                        @endforeach

                                    </div>
                                
                                @can('update-settings')
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                @endcan

                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection