@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_app_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                                <input type="hidden" name="page_name" value="app_setting">
                                <div class="row mt-2">
                                     @foreach ($data as $row)
                                        @if($row->key=='splash_screen')
                                            <div class="col-md-12">
                                                <div class="mb-1">
                                                    <img src="{{asset('site-assets/images/app/'.$row->value)}}" alt="users avatar" class="users-avatar-shadow rounded me-2 my-25 cursor-pointer image-preview-cls" id="image-preview-id" onerror="this.src='{{asset('site-assets/images/no-image.jpg')}}';"/>
                                                    <div class="img-footer">
                                                        <label class="btn btn-primary me-75 mb-0 upload-image-preview-cls-btn" for="change-picture-id">
                                                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                            <input class="form-control" type="file" id="change-picture-id" hidden accept="image/png, image/jpeg, image/jpg" name="splash_screen" onclick="showImagePreview('change-picture-id','image-preview-id');"/>
                                                            <span class="d-block d-sm-none">
                                                                <i class="me-0" data-feather="edit"></i>
                                                            </span>
                                                        </label>
                                                        <p class="img-label">{{__('lang.admin_spalsh_screen')}}</p>
                                                        <p class="img-resolution">
                                                        {{__('lang.admin_spalsh_screen_resolution')}}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                                <div class="row mt-2">
                                     <h3>{{__('lang.admin_app_force_update')}}</h3> 
                                    @foreach ($data as $row)
                                    @if($row->key == 'is_android_app_force_update')
                                    <div class="col-md-6 mt-2">
                                       <div class="form-check form-switch tooltip-container">
                                            <input type="checkbox" class="form-check-input" name="is_android_app_force_update" id="is_android_app_force_update" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                            <label class="form-check-label" for="is_android_app_force_update">{{ __('lang.admin_is_android_app_force_update_placeholder') }}</label>
                                        </div>
                                    </div>
                                    @endif
                                    
                                    @if($row->key == 'is_ios_app_force_update')
                                    <div class="col-md-6 mt-2">
                                        <div class="form-check form-switch tooltip-container">
                                            <input type="checkbox" class="form-check-input" name="is_ios_app_force_update" id="is_ios_app_force_update" value="1" {{ $row->value == '1' ? 'checked' : '' }} />
                                            <label class="form-check-label" for="is_ios_app_force_update">{{ __('lang.admin_is_ios_app_force_update_placeholder') }}</label>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach
                                </div>

                                <p class="mt-3 mb-2" style="border: 1px solid darkturquoise;"></p>

                                <div class="row mt-2">
                                     <h3>{{__('lang.admin_rate_us')}} / {{__('lang.share_your_app')}}</h3> 
                                    @foreach ($data as $row)
                                        @if($row->key == 'rate_us_android')
                                        <div class="col-md-6 mt-2">
                                           <div class="form-group">
                                                <label class="form-check-label" for="rate_us_android">{{ __('lang.admin_rate_us_android') }}</label>
                                                <input type="text" class="form-control" value="{{ $row->value}}" name="rate_us_android" placeholder="{{__('lang.admin_rate_us_android')}}">
                                            </div>
                                        </div>
                                        @endif
                                        
                                        @if($row->key == 'rate_us_ios')
                                        <div class="col-md-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-check-label" for="rate_us_ios">{{ __('lang.admin_rate_us_ios') }}</label>
                                                <input type="text" class="form-control" value="{{$row->value}}" name="rate_us_ios" placeholder="{{__('lang.admin_rate_us_ios')}}">
                                            </div>
                                        </div>
                                        @endif
                                    @endforeach
                                </div>
                                    
                                @can('update-settings')
                                <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                    <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                </div>
                                @endcan
                                    
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection