@extends('layouts.site-app')
@section('sitecontent')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<style>
    span.select2-selection.select2-selection--single {
        height: 45px;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 45px !important;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        top: 11px !important;
    }
</style>


<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.saved_addresses_title')}}</div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-4">
                @include('partials.site.user-links')
            </div>
            <div class="col-lg-9 col-md-8">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="alert alert-success" role="alert">
                              {{ Session::get('message') }}
                            </div>
                        </div>
                    </div>
                @endif
                @if(Session::has('error'))
                <div class="row">
                    <div class="col-lg-12">
                        <div class="alert alert-danger" role="alert">
                          {{ Session::get('error') }}
                        </div>
                    </div>
                </div>
                @endif
                <div class="add-address white-bg">
                    <span onclick="showAddressForm()" style="cursor: pointer;">{{__('lang.add_address')}}</span>
                    <a href="javascript:;" onclick="showAddressForm()"><img src="{{asset('site-assets/images/plusico.png')}}" style="width: 30%;" /></a> 
                </div>
                {!! Form::model(null, ['id'=>'addressForm', 'method' => 'POST', 'url' => ['add-address']]) !!}
                    @csrf
                    @if(setting('google_address_map_api_key') != '' && setting('is_enable_google_map_address') == 1)
                        <input type="hidden" name="location_name" id="location_name" value="">
                        <input type="hidden" name="latitude" id="latitude" value="">
                        <input type="hidden" name="longitude" id="longitude" value="">
                        <input type="hidden" name="city" id="city" value="">
                        <input type="hidden" name="state" id="state" value="">
                        <input type="hidden" name="zipcode" id="zipcode" value="">
                        <input type="hidden" name="country" id="country" value="">
                        <div class="addressformbg" id="addAddressForm" style="display: none">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="map">
                                        <div id="myMap" style="height: 600px;width: 100%;position: relative;overflow: hidden;border: 1px solid #a5a5a5;border-radius: 5px;margin-bottom: 5px"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="addressform">
                                        <div class="row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_detact_location')}}</label>
                                                <input type="text" class="form-control" name="google_address" id="google_address"  placeholder="{{__('lang.address_detact_location')}}" />
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_type')}}</label>
                                                <div class="radio">
                                                    <input label="" type="radio" id="Home" name="type" value="{{__('lang.address_home')}}" checked />
                                                    <input label="" type="radio" id="Office" name="type" value="{{__('lang.address_office')}}" />
                                                    <input label="" type="radio" id="Mosque" name="type" value="{{__('lang.address_mosque')}}" />
                                                    <input label="" type="radio" id="other" name="type" value="{{__('lang.address_other')}}" />
                                                </div>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_title')}}</label>
                                                <input type="text" class="form-control" name="address" placeholder="{{__('lang.address_title')}}" />
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.placeholder_note')}}</label>
                                                <textarea class="form-control" name="note" id="note" placeholder="{{__('lang.placeholder_note')}}" style="height: 70px;"  ></textarea>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <button class="save-btn text-uppercase float-left" style="background: #af7ab3;" type="button">{{__('lang.cancel_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                                <button class="save-btn text-uppercase float-right" id="addressFormBtn"  onclick="return false" type="submit">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="addressformbg" id="addAddressForm" style="display: none">
                            <div class="row">
                                <div class="col-lg-3"></div>
                                <div class="col-lg-6">
                                    <div class="addressform">
                                        <div class="row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.zipcode')}}</label>
                                                <select onchange="showCityAndStateByZipcode('zipcode');" class="form-control select2" name="zipcode" id="zipcode" required>
                                                </select>
                                                
                                            </div>
                                            
                                            <div class="col-sm-12 hide zipcode_related_inp">
                                                <div class="mb-1">
                                                    <label class="form-label" for="address_state_name">{{__('lang.admin_state_name')}} <span class="required">*</span></label>
                                                    <input class="form-control address_state_name" id="address_state_name" disabled>
                                                </div>
                                            </div>
                                            
                                            <div class="col-sm-12 hide zipcode_related_inp">
                                                <div class="mb-1">
                                                    <label class="form-label" for="address_city_name">{{__('lang.admin_city_name')}} <span class="required">*</span></label>
                                                    <input class="form-control address_city_name" id="address_city_name" disabled>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_type')}}</label>
                                                <div class="radio">
                                                    <input label="" type="radio" id="Home" name="type" value="{{__('lang.address_home')}}" checked />
                                                    <input label="" type="radio" id="Office" name="type" value="{{__('lang.address_office')}}" />
                                                    <input label="" type="radio" id="Mosque" name="type" value="{{__('lang.address_mosque')}}" />
                                                    <input label="" type="radio" id="other" name="type" value="{{__('lang.address_other')}}" />
                                                </div>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_title')}}</label>
                                                <input type="text" class="form-control" name="address" placeholder="{{__('lang.address_title')}}" />
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.placeholder_note')}}</label>
                                                <textarea class="form-control" name="note" id="note" placeholder="{{__('lang.placeholder_note')}}" style="height: 70px;"  ></textarea>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <a href="{{url('addresses')}}">
                                                    <button class="save-btn text-uppercase float-left" style="background: #af7ab3;" type="button">{{__('lang.cancel_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/>
                                                    </button>
                                                </a>
                                                <button class="save-btn text-uppercase float-right" id="addressFormBtn"  onclick="return false" type="submit">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3"></div>
                            </div>
                        </div>
                    @endif
                {!! Form::close() !!}
                <div class="select-address save-addresses white-bg">
                    @if(count($data)>0)
                        @foreach($data as $row)
                            <div class="custom-control white-bg">
                                <label class="custom-control-label"> <span>{{$row->type}}</span> @if($row->address!='') {{$row->address}}, @endif {{$row->zipcode}} ,  @if($row->city!='') {{$row->city}}, @endif  @if($row->state!='') {{$row->state}}, @endif</label>
                                <a onclick="return confirm('{{__('lang.address_delete_confirm')}}');" href="{{url('/delete-address')}}/{{$row->id}}"><img src="{{asset('site-assets/images/delete-icon.png')}}" style="width: 25px;"/></a>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>

<footer class="footer">
    @include('partials.site.footer')
</footer>

<script type="text/javascript">
    setTimeout(function(){
        getLocation();
    },1500);
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
    $(document).ready(function () {
        // Prevent form submission on Enter key
        $('#addressForm').on('keypress', function (e) {
            if (e.which === 13) {
                e.preventDefault();
            }
        });

        // Fetch delivery areas zip codes as an array and ensure all are strings
        const deliveryZipCodes = {!! json_encode(App\Models\DeliveryAreas::where('status', 1)->pluck('zip_code')->toArray()) !!}.map(String);

        // Handle form submission with validation
        $('#addressFormBtn').on('click', function (e) {
            e.preventDefault(); // Prevent default form submission

            // Get input values and trim spaces
            const zipcode = $('#zipcode').val()?.trim();
            const state = $('#address_state_name').val()?.trim();
            const city = $('#address_city_name').val()?.trim();
            const addressTitle = $('input[name="address"]').val()?.trim();

            let isValid = true;

            // Validation checks
            if (!zipcode) {
                toastr.error('Zipcode is required.');
                isValid = false;
            } else if (!deliveryZipCodes.includes(zipcode)) {
                toastr.error('The entered zip code is not within our delivery range.');
                isValid = false;
            }

            if (!state) {
                toastr.error('State is required.');
                isValid = false;
            }

            if (!city) {
                toastr.error('City is required.');
                isValid = false;
            }

            if (!addressTitle) {
                toastr.error('Address title is required.');
                isValid = false;
            }

            // If all fields are valid, submit the form
            if (isValid) {
                $('#addressForm').submit();
            }
        });
    });

    
    function showCityAndStateByZipcode(zipcode) {
        var zipcode_value = $('#' + zipcode).val();
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        $.ajax({
            url: base_url + '/get-city-state-by-zipcode',
            type: 'POST',
            data: {
                'zip_code': zipcode_value
            },
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    if (zipcode_value !== '') {
                        $('.zipcode_related_inp').removeClass('hide');
                        $(".address_state_name").val(response.state);
                        $(".address_city_name").val(response.city);
                    } else {
                        $('.zipcode_related_inp').addClass('hide');
                        $(".address_state_name").val('');
                        $(".address_city_name").val('');
                    }
                } else {
                    myToastr(response.message, 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error: ', error);
                myToastr("Something went wrong. Please try again.", 'error');
            }
        });
    }
</script>

<!-- Select2 CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />

<!-- Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<script>
    $(document).ready(function() {
        $('#zipcode').select2({
            placeholder: "{{ __('lang.select_zipcode') }}",
            allowClear: true,
            width: '100%',
            minimumInputLength: 2,
            language: {
                inputTooShort: function() {
                    return "{{ __('lang.select_zipcode_type_length_msg') }}";
                },
                noResults: function() {
                    return "{{ __('lang.no_area_found_on_typed_zipcode') }}";
                }
            },
            ajax: {
                url: '{{ route("getZipCodes") }}', // Route for fetching zip codes
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        search: params.term // User's search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item) {
                            return {
                                id: item.zip_code,
                                text: item.zip_code + ' (' + item.location_name + ')'
                            };
                        })
                    };
                },
                cache: true
            }
        });
    });
</script>
@endsection