<div class="content-body">
<!-- Striped rows start -->
<div class="row" id="table-striped">
<div class="col-12">
    <div class="card">
        <div class="card-header">
            <h5 class="card-title display-inline-block">{{__('lang.admin_roles')}} {{__('lang.admin_list')}}</h5>
            <h6 class="float-right"> <?php if ($result->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $result->firstItem() }}-{{ $result->lastItem() }} {{__('lang.admin_of')}} {{ $result->total() }} <?php }?> </h6>
        </div>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{__('lang.admin_id')}}</th>
                        <th>{{__('lang.admin_name')}}</th>
                        @canany(['update-role', 'delete-role'])
                        <th>{{__('lang.admin_action')}}</th>
                        @endcanany

                    </tr>
                </thead>
                <tbody>
            @php $i=0; @endphp 
                @if(count($result) > 0) 
                    @foreach($result as $row) 
                        @php $i++; @endphp 
                    <tr>
                        <td>{{$i}}</td>
                        <td>@if($row->name!=''){{$row->name}}@else -- @endif</td>
                    
                     @canany(['update-sub-admin', 'delete-sub-admin'])
                    <td>
                            <div class="dropdown">
                                <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i data-feather="more-vertical"></i>
                                </button>
                                <div class="dropdown-menu">
                                
                                @can('update-role')  
                                    <a class="dropdown-item" type="button" href="javascript:;" data-bs-toggle="modal" data-bs-target="#editRoleModal_{{$row->id}}" class="role-edit-modal">
                                    <i data-feather="edit-2" class="me-50"></i> {{__('lang.admin_edit')}} </a>
                                @endcan
                             
                                @if($row->id != 1)
                                @can('delete-role')  
                                    <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('role' , {{ $row->id }})">
                                        <i data-feather="trash" class="me-50"></i>
                                        <span>{{__('lang.admin_button_delete')}}</span>
                                    </a>
                                 @endcan 
                                 @endif
                                </div>
                            </div>

                                    <div class="modal fade" id="editRoleModal_{{$row->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-xl">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                          <h5 class="modal-title" id="myModalLabel160">{{__('lang.admin_set_role_permission')}}</h5>
                                                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <!-- Add role form -->
                                                    <form class="row g-3" id="edit-record_{{$row->id}}" onsubmit="return validateRole('edit-record_{{$row->id}}');" action="{{url('admin/update-role')}}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="id" value="{{$row->id}}">
                                                        <div class="col-12">
                                                         <label class="form-label" for="name" style="float: left;"> {{__('lang.admin_role_name')}} <span class="required">*</span></label>
                                                        <input
                                                            type="text"
                                                            id="name"
                                                            name="name"
                                                            class="form-control"
                                                            placeholder="{{__('lang.admin_role_name_placeholder')}}"
                                                            tabindex="-1"
                                                            value="{{$row->name}}"
                                                            required
                                                        />
                                                        </div>
                                                        <div class="col-12">
                                                        <h5 style="text-align: left;">{{__('lang.admin_role_permissions')}}</h5>
                                                        <!-- Permission table -->
                                                        <div class="d-flex" style="margin-left: 250px;">
                                                            <div class="form-check me-3 me-lg-5 permission">
                                                                <input class="form-check-input permission-all-checkbox_List" type="checkbox" value="List" data-permission="List" onclick="selectAllSameData('permission-all-checkbox_List','permission-checkbox_List');"/>
                                                                <label class="form-check-label" for="All">{{__('lang.admin_all_list')}}</label>
                                                            </div>
                                                            <div class="form-check me-3 me-lg-5 permission">
                                                                <input class="form-check-input permission-all-checkbox_Add" type="checkbox" value="Add" data-permission="Add" onclick="selectAllSameData('permission-all-checkbox_Add','permission-checkbox_Add');"/>
                                                                <label class="form-check-label" for="Add"> {{__('lang.admin_all_add')}}</label>
                                                            </div>
                                                            <div class="form-check me-3 me-lg-5 permission">
                                                                <input class="form-check-input permission-all-checkbox_Update" type="checkbox" value="Update" data-permission="Update" onclick="selectAllSameData('permission-all-checkbox_Update','permission-checkbox_Update');"/>
                                                                <label class="form-check-label" for="Update"> {{__('lang.admin_all_update')}}</label>
                                                            </div>
                                                            <div class="form-check me-3 me-lg-5 permission">
                                                                <input class="form-check-input permission-all-checkbox_Status Change" type="checkbox" data-permission="Status" onclick="selectAllSameData('permission-all-checkbox_Status','permission-checkbox_Status');"/>
                                                                <label class="form-check-label" for="Status"> {{__('lang.admin_all_status')}}</label>
                                                            </div>
                                                            <div class="form-check me-3 me-lg-5 permission">
                                                                <input class="form-check-input permission-all-checkbox_Delete" type="checkbox" value="Delete" data-permission="Delete" onclick="selectAllSameData('permission-all-checkbox_Delete','permission-checkbox_Delete');"/>
                                                                <label class="form-check-label" for="Delete"> {{__('lang.admin_all_delete')}}</label>
                                                            </div>
                                                        </div>
                                                        <div class="table-responsive" style="margin-top: 20px;">
                                                            <table class="table table-flush-spacing">
                                                            <tbody>
                                                                @foreach($permission as $value)
                                                                <tr>
                                                                <td class="text-nowrap fw-semibold">@if($value->module=='Blog')Blog/Quote @else {{$value->module}} @endif</td>
                                                                <td>
                                                                    <div class="d-flex">
                                                                    @foreach($value->permission as $detail)
                                                                    <div class="form-check me-3 me-lg-5">

                                                                        @if($detail->permission_name=='Status Change')
                                                                            <input <?=$detail->permission_name=='Dashboard' ? 'checked  onclick="return false;"' : '';?> class="form-check-input permission-checkbox_Status" type="checkbox" id="{{ $detail->route_name }}" name="permission[]" value="{{$detail->id}}" {{\Helpers::checkRoleHasPermission($row->id,$detail->id) || $detail->is_default ? 'checked' : ''}} />
                                                                        @else
                                                                            <input <?=$detail->permission_name=='Dashboard' ? 'checked  onclick="return false;"' : '';?> class="form-check-input permission-checkbox_{{ $detail->permission_name }}" type="checkbox" id="{{ $detail->route_name }}" name="permission[]" value="{{$detail->id}}" {{\Helpers::checkRoleHasPermission($row->id,$detail->id) || $detail->is_default ? 'checked' : ''}} />
                                                                        @endif
                                                                        
                                                                        <label class="form-check-label" for="{{ $detail->route_name }}"> {{ $detail->permission_name }} </label>
                                                                    </div>
                                                                    @endforeach
                                                                    </div>
                                                                </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                            </table>
                                                        </div>
                                                        <!-- Permission table -->
                                                        </div>
                                                        <div class="col-12 text-center mt-4">
                                                        <button type="submit" class="btn btn-primary me-sm-3 me-1">{{__('lang.admin_button_save_changes')}}</button>
                                                        <button
                                                            type="reset"
                                                            class="btn btn-label-secondary"
                                                            data-bs-dismiss="modal"
                                                            aria-label="Close"
                                                        >
                                                        {{__('lang.admin_button_cancel')}}
                                                        </button>
                                                        </div>
                                                    </form>
                                                    <!--/ Add role form -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                    </td>
                     @endcanany
              

                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            <div class="pagination" style="float: right;">
                {{$result->withQueryString()->links('pagination::bootstrap-4')}}
            </div>
        </div>
    </div>
</div>
</div>
<!-- Striped rows end -->
</div>