@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_roles')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_roles_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                @can('add-role')
                    <button class="btn btn-primary me-sm-3 me-1 waves-effect waves-float waves-light float-right mt-3" type="button" href="javascript:;" data-bs-toggle="modal" data-bs-target="#addRoleModal" class="role-edit-modal">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_create_role')}}</span>
                    </button>
                @endcan

                </div>
            </div>
        </div>

        @include('roles.table')
    </div>
</div>
<!-- Modal to add new record -->
  <div class="modal fade" id="addRoleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
      <div class="modal-content">
      <div class="modal-header">
      <h5 class="modal-title" id="myModalLabel160">{{__('lang.admin_set_role_permission')}}</h5>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

        <div class="modal-body">
          <!-- Add role form -->
          <form class="row g-3" id="add-record" onsubmit="return validateRole('add-record');" action="{{url('admin/add-role')}}" method="POST">
            @csrf
            <div class="col-12">
              <label class="form-label" for="name"> {{__('lang.admin_role_name')}} <span class="required">*</span></label>
              <input
                type="text"
                id="name"
                name="name"
                class="form-control"
                placeholder="{{__('lang.admin_role_name_placeholder')}}"
                tabindex="-1"
                required
              />
            </div>
            <div class="col-12">
              <h5>{{__('lang.admin_role_permissions')}}</h5>
              <div class="d-flex" style="margin-left: 250px;">
                <div class="form-check me-3 me-lg-5 permission">
                  <input class="form-check-input permission-all-checkbox_List" type="checkbox" value="List" data-permission="List" onclick="selectAllSameData('permission-all-checkbox_List','permission-checkbox_List');"/>
                  <label class="form-check-label" for="All">{{__('lang.admin_all_list')}}</label>
                </div>
                <div class="form-check me-3 me-lg-5 permission">
                  <input class="form-check-input permission-all-checkbox_Add" type="checkbox" value="Add" data-permission="Add" onclick="selectAllSameData('permission-all-checkbox_Add','permission-checkbox_Add');"/>
                  <label class="form-check-label" for="Add">{{__('lang.admin_all_add')}}</label>
                </div>
                <div class="form-check me-3 me-lg-5 permission">
                  <input class="form-check-input permission-all-checkbox_Update" type="checkbox" value="Update" data-permission="Update" onclick="selectAllSameData('permission-all-checkbox_Update','permission-checkbox_Update');"/>
                  <label class="form-check-label" for="Update">{{__('lang.admin_all_update')}}</label>
                </div>
                <div class="form-check me-3 me-lg-5 permission">
                  <input class="form-check-input permission-all-checkbox_Status Change" type="checkbox" data-permission="Status" onclick="selectAllSameData('permission-all-checkbox_Status','permission-checkbox_Status');"/>
                  <label class="form-check-label" for="Status">{{__('lang.admin_all_status')}}</label>
                </div>
                <div class="form-check me-3 me-lg-5 permission">
                  <input class="form-check-input permission-all-checkbox_Delete" type="checkbox" value="Delete" data-permission="Delete" onclick="selectAllSameData('permission-all-checkbox_Delete','permission-checkbox_Delete');"/>
                  <label class="form-check-label" for="Delete">{{__('lang.admin_all_delete')}}</label>
                </div>
                <div class="form-check me-3 me-lg-5 permission">
                  <input class="form-check-input permission-all-checkbox_Translation" type="checkbox" value="Translation" data-permission="Translation" onclick="selectAllSameData('permission-all-checkbox_Translation','permission-checkbox_Translation');"/>
                  <label class="form-check-label" for="Translation">{{__('lang.admin_all_translation')}}</label>
                </div>
              </div>
              <!-- Permission table -->
              <div class="table-responsive" style="margin-top: 20px;">
                <table class="table table-flush-spacing">
                  <tbody>
                    @foreach($permission as $value)
                    <tr>
                      <td class="text-nowrap fw-semibold">
                        @if($value->module=='Blog')Blog/Quote @else {{$value->module}} @endif
                      </td>
                      <td>
                        <div class="d-flex">
                          @foreach($value->permission as $detail)
                          <div class="form-check me-3 me-lg-5 permission">
                            @if($detail->permission_name=='Status Change')
                              <input <?=$detail->permission_name=='Dashboard' ? 'checked  onclick="return false;"' : '';?> class="form-check-input permission-checkbox_Status" type="checkbox" id="{{ $detail->route_name }}" name="permission[]" value="{{$detail->id}}" {{$detail->is_default ? 'checked' : ''}} data-permission="{{ $detail->permission_name }}" />
                            @else
                              <input <?=$detail->permission_name=='Dashboard' ? 'checked  onclick="return false;"' : '';?> class="form-check-input permission-checkbox_{{ $detail->permission_name }}" type="checkbox" id="{{ $detail->route_name }}" name="permission[]" value="{{$detail->id}}" {{$detail->is_default ? 'checked' : ''}} data-permission="{{ $detail->permission_name }}" />
                            @endif
                            <label class="form-check-label" for="{{ $detail->route_name }}"> {{ $detail->permission_name }} </label>
                          </div>
                          @endforeach
                        </div>
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
              <!-- Permission table -->
            </div>
            <div class="col-12 text-center mt-4">
              <button type="submit" class="btn btn-primary me-sm-3 me-1">{{__('lang.admin_button_save_changes')}}</button>
              <button
                type="reset"
                class="btn btn-label-secondary"
                data-bs-dismiss="modal"
                aria-label="Close"
              >
              {{__('lang.admin_button_cancel')}}
              </button>
            </div>
          </form>
          <!--/ Add role form -->
        </div>
      </div>
    </div>
  </div>
<!-- END: Content-->
@endsection