@extends('layouts.app')
@section('content')


<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<style type="text/css">
    span.select2-selection__placeholder {
        float: inline-start;
    }

    span#select2-search_order_by_user_id-container {
        float: inline-start;
    }

    span#select2-search_order_by_product_order_id-container {
        float: inline-start;
    }

    span.select2-selection__placeholder {
        float: inline-start;
    }

    span#select2-search_order_by_driver_id-container {
        float: inline-start;
    }
</style>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_products')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_product_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            
            @can('add-product')
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <a href="{{url('admin/product-add')}}">
                        <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{__('lang.admin_product_add')}}</span>
                        </button>
                    </a>
                </div>
            </div>
            @endcan


            <form id="formData" method="get" class="mb-5">
                <div class="row">
                    <div class="col-md-12 row">
                        <div class="form-group col-sm-4">
                            <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_search_by_name')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                        </div>

                        <div class="col-md-4">
                            <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_status')}}</option>
                                @foreach($filter['status'] as $value => $sts)
                                    <option value="{{ $value }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>   
                        </div>
                    </div>
                </div>
            </form>
            @include('products.table')
        </div>
    </div>
</div>
<!-- END: Content-->
@endsection