@extends('layouts.app')
@section('content')

 <style>
    .file-upload-wrapper {
        border: 2px dashed #007bff;
        border-radius: 10px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s;
    }

    .file-upload-wrapper:hover {
        background-color: #f7f7f7;
    }

    .file-upload-wrapper input[type="file"] {
        display: none;
    }

    .preview-container {
        display: flex;
        flex-wrap: wrap;
        margin-top: 20px;
    }

    .preview-container .preview {
        position: relative;
        margin: 10px;
    }

    .preview-container img {
        width: 100px;
        height: 100px;
        object-fit: cover;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .preview-container .remove-btn {
        position: absolute;
        top: -10px;
        right: -10px;
        background-color: red;
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        font-size: 14px;
        cursor: pointer;
        display: flex;
        justify-content: center;
        align-items: center;
    }
</style>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_products')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('products.index') !!}">{{__('lang.admin_product_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_product_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($product, [
                                    'route' => ['products.update', $product->id],
                                    'method' => 'PATCH',
                                    'enctype' => 'multipart/form-data',
                                    'onsubmit' => 'return validatePost("add-record");'
                                ]) !!}
                                @csrf
                                <div class="col-md-12" style="margin-top: 15px;">
                                    <!-- Hidden input to track total image count -->
                                    <input type="hidden" id="totalImageCount" value="0">
                                    <input type="hidden" id="removedImages" name="removed_images" value="">
                                    <label>{{__('lang.admin_image')}} <span class="required">*</span> <span>({{__('lang.admin_instruction_for_upload_multiple_images')}})</span></label>
                                    <div class="file-upload-wrapper mt-3" id="upload-area" style="cursor: pointer;">
                                        <label for="files" class="custom-file-label" style="cursor: pointer;">
                                            <p style="margin-top: 10px; padding-top: 10px;">
                                                {{__('lang.admin_product_images')}} <br>
                                                {{__('lang.admin_click_here_to_upload')}}
                                            </p>
                                        </label>
                                        <input type="file" id="files" name="image[]" multiple accept="image/*" style="display: none;">
                                    </div>
                                    <div class="preview-container" id="preview"></div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_product_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_product_name')}}" value="{{$product->name}}" name="name" id="username" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{__('lang.admin_price')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_price')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{$product->price}}" name="price" id="price" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_discount_price')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_discount_price')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{$product->discount_price}}" name="discount_price" id="discount_price"/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_min_purchase_qty')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_min_purchase_qty')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{$product->minimum_order_quantity}}" name="minimum_order_quantity" id="minimum_order_quantity" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($product->status == 1) selected  @endif>{{__('lang.status_active')}}</option>
                                                <option value="0" @if($product->status == 0) selected @endif>{{__('lang.status_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="start_date">{{__('lang.admin_description')}}</label>
                                            <textarea class="form-control flatpickr-basic" placeholder="{{__('lang.admin_description')}}" value="{{$product->description}}" name="description" id="description">{{$product->description}}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('products.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script type="text/javascript">
    function validatePost(formId) {
        let imageInput = document.getElementById('files');
        let existingImages = document.getElementById('totalImageCount').value;
        
        if (existingImages < 1) {
            toastr.error("{{__('lang.message_please_select_atleat_one_image')}}");
            return false;
        }
        return true;
    }
</script>

<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function () {
        const previewContainer = document.getElementById('preview');
        const fileInput = document.getElementById('files');
        const totalImageCountInput = document.getElementById('totalImageCount'); // Hidden input
        const removedImagesInput = document.getElementById('removedImages'); // Hidden input for removed images
        const existingImages = {!! json_encode($images) !!}; // Pass the entire image objects to know the IDs

        let fileList = [];  // This will store new files being uploaded
        let totalImageCount = existingImages.length; // Initialize count from existing images
        let removedImages = []; // Array to track removed images
        totalImageCountInput.value = totalImageCount; // Set initial value to the hidden input

        // Display existing images
        existingImages.forEach((image) => {
            const previewDiv = document.createElement('div');
            previewDiv.classList.add('preview');
            
            const img = document.createElement('img');
            img.src = image.image !=null ? base_url + `/app-assets/images/products/${image.image}` : base_url + `/app-assets/images/no-image.png`;
            previewDiv.appendChild(img);

            // Create Remove Button
            const removeBtn = document.createElement('button');
            removeBtn.classList.add('remove-btn');
            removeBtn.innerHTML = '&times;';
            removeBtn.setAttribute('data-name', image.image);  // Store the image name for removal
            removeBtn.addEventListener('click', function () {
                removeImage(previewDiv, image.image);  // Call remove image logic
            });

            previewDiv.appendChild(removeBtn);
            previewContainer.appendChild(previewDiv);
        });

        // Function to handle file input changes and display preview for new uploads
        fileInput.addEventListener('change', function (e) {
            Array.from(this.files).forEach((file) => {
                fileList.push(file);  // Add new files to the list
                totalImageCount++;  // Increase the total image count
                totalImageCountInput.value = totalImageCount;  // Update hidden input

                const reader = new FileReader();
                reader.onload = function (event) {
                    const previewDiv = document.createElement('div');
                    previewDiv.classList.add('preview');
                    
                    const img = document.createElement('img');
                    img.src = event.target.result;
                    previewDiv.appendChild(img);

                    // Create Remove Button
                    const removeBtn = document.createElement('button');
                    removeBtn.classList.add('remove-btn');
                    removeBtn.innerHTML = '&times;';
                    removeBtn.setAttribute('data-new', fileList.length - 1);  // Set index for new files

                    removeBtn.addEventListener('click', function () {
                        removeImage(previewDiv, null, fileList.length - 1);  // Call remove image logic for new files
                    });

                    previewDiv.appendChild(removeBtn);
                    previewContainer.appendChild(previewDiv);
                };
                reader.readAsDataURL(file);
            });
        });

        // Function to remove an image (either existing or new)
        function removeImage(previewDiv, imageName = null, newIndex = null) {
            previewDiv.remove();  // Remove image from the preview UI
            totalImageCount--;  // Decrease the total image count
            totalImageCountInput.value = totalImageCount;  // Update the hidden input

            if (imageName !== null) {
                removedImages.push(imageName); // Track the removed existing image
                // Log removed images
                console.log('Removed images:', removedImages);
            } else if (newIndex !== null) {
                fileList.splice(newIndex, 1);  // Remove the new image from fileList if applicable
            }

            // Update the hidden input for removed images
            removedImagesInput.value = JSON.stringify(removedImages); // Store removed images as a JSON string
        }
    });
</script>
@endsection