@extends('layouts.app')
@section('content')

 <style>
    .file-upload-wrapper {
        border: 2px dashed #007bff;
        border-radius: 10px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s;
    }

    .file-upload-wrapper:hover {
        background-color: #f7f7f7;
    }

    .file-upload-wrapper input[type="file"] {
        display: none;
    }

    .preview-container {
        display: flex;
        flex-wrap: wrap;
        margin-top: 20px;
    }

    .preview-container .preview {
        position: relative;
        margin: 10px;
    }

    .preview-container img {
        width: 100px;
        height: 100px;
        object-fit: cover;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .preview-container .remove-btn {
        position: absolute;
        top: -10px;
        right: -10px;
        background-color: red;
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        font-size: 14px;
        cursor: pointer;
        display: flex;
        justify-content: center;
        align-items: center;
    }
</style>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_products')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('products.index') !!}">{{__('lang.admin_product_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_product_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                    <form id="add-record" onsubmit="return validatePost('add-record');" action="{{url('admin/products/store')}}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                        <div class="col-md-12" style="margin-top: 15px;">
                                            <label>{{__('lang.admin_image')}} <span class="required">*</span> <span>({{__('lang.admin_instruction_for_upload_multiple_images')}})</span></label>
                                            <div class="file-upload-wrapper mt-3" id="upload-area">
                                                <p style="margin-top: 10px;padding-top: 10px;"> {{__('lang.admin_product_images')}} <br>
                                                 {{__('lang.admin_click_here_to_upload')}}
                                                </p>
                                                <input type="file" id="files" name="image[]" multiple accept="image/*">
                                            </div>
                                            <div class="preview-container" id="preview"></div>
                                        </div> 
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-1">
                                                    <label class="form-label" for="username">{{__('lang.admin_product_name')}} <span class="required">*</span></label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_product_name')}}"name="name" id="username" required />
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="mb-1">
                                                    <label class="form-label" for="name">{{__('lang.admin_price')}} <span class="required">*</span></label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_price')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" name="price" id="price" required />
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="mb-1">
                                                    <label class="form-label" for="email">{{__('lang.admin_discount_price')}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_discount_price')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" name="discount_price" id="discount_price"/>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="mb-1">
                                                    <label class="form-label" for="email">{{__('lang.admin_min_purchase_qty')}} <span class="required">*</span></label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_min_purchase_qty')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" name="minimum_order_quantity" id="minimum_order_quantity" required />
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="mb-1">
                                                    <label class="form-label" for="start_date">{{__('lang.admin_description')}}</label>
                                                    <textarea class="form-control flatpickr-basic" placeholder="{{__('lang.admin_description')}}" name="description" id="description"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                                <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                                <a href="{!! route('products.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                            </div>
                                        </div>
                                    {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<script type="text/javascript">
    function validatePost(formId) {
        let imageInput = document.getElementById('files');
        if (imageInput.files.length === 0) {
            toastr.error("{{__('lang.message_please_select_atleat_one_image')}}");
            return false;
        }
        return true;
    }
</script>
<script>
    const fileInput = document.getElementById('files');
    const previewContainer = document.getElementById('preview');
    const uploadArea = document.getElementById('upload-area');
    const submitBtn = document.getElementById('submitBtn');

    let fileList = [];  // Store all selected files here

    // Trigger file input on click
    uploadArea.addEventListener('click', () => {
        fileInput.click();
    });

    // Handle file input changes
    fileInput.addEventListener('change', function (e) {
        handleFiles(this.files);
    });

    // Function to handle file input and display preview
    function handleFiles(files) {
        fileList = [];  // Clear previous selection
        previewContainer.innerHTML = '';  //pwn
        Array.from(files).forEach((file, index) => {
            fileList.push(file);  // Add new files to the existing list

            const reader = new FileReader();
            reader.onload = function (event) {
                const previewDiv = document.createElement('div');
                previewDiv.classList.add('preview');
                const img = document.createElement('img');
                img.src = event.target.result;
                previewDiv.appendChild(img);

                // Create Remove Button
                const removeBtn = document.createElement('button');
                removeBtn.classList.add('remove-btn');
                removeBtn.innerHTML = '&times;';
                removeBtn.setAttribute('data-index', fileList.length - 1);  // Set index for removal

                // Remove button event
                removeBtn.addEventListener('click', function () {
                    removeImage(removeBtn.getAttribute('data-index'));
                });

                previewDiv.appendChild(removeBtn);
                previewContainer.appendChild(previewDiv);
            };
            reader.readAsDataURL(file);
        });

        submitBtn.classList.remove('d-none');
    }

    // Function to remove image preview
    function removeImage(index) {
        fileList.splice(index, 1);  // Remove from file list
        updatePreview();  // Rebuild the preview UI
    }

    // Update the preview container
    function updatePreview() {
        fileList = [];  // Clear previous selection
        previewContainer.innerHTML = '';  // Clear previews
        fileList.forEach((file, index) => {
            const reader = new FileReader();
            reader.onload = function (event) {
                const previewDiv = document.createElement('div');
                previewDiv.classList.add('preview');
                const img = document.createElement('img');
                img.src = event.target.result;
                previewDiv.appendChild(img);

                // Create Remove Button
                const removeBtn = document.createElement('button');
                removeBtn.classList.add('remove-btn');
                removeBtn.innerHTML = '&times;';
                removeBtn.setAttribute('data-index', index);  // Update index for the remove button

                // Remove button event
                removeBtn.addEventListener('click', function () {
                    removeImage(index);  // Call remove function
                });

                previewDiv.appendChild(removeBtn);
                previewContainer.appendChild(previewDiv);
            };
            reader.readAsDataURL(file);
        });

        // Hide submit button if no files are left
        if (fileList.length === 0) {
            submitBtn.classList.add('d-none');
        }
    }
</script>
@endsection