<?php
$disabledWeekDays = array();
$highlightedDates = array();
foreach ($holdaysDate as $product_detailss) {
    $temp = array(
        'start' => date("Y-m-d",strtotime($product_detailss->start_date)),
        'end' => date("Y-m-d",strtotime($product_detailss->end_date))
    );
    array_push($disabledWeekDays, $temp);

    $i = 0;
    $startDate = $product_detailss->start_date;
    do{
        $currentDate = date("Y-m-d",strtotime($startDate.' + '.$i.' day'));
        $tempAr = array(
            'date' => $currentDate,
            'highlight' => 'red',
            'markCssClass' => 'square-mark'
        );
        array_push($highlightedDates, $tempAr);
        $i++;
    }while(strtotime($currentDate)<strtotime($product_detailss->end_date));
}

App::setLocale(Session()->get('locale'));
?>
<style>
    .inforow {
        display: flex;
        align-items: center; /* Align items vertically */
        padding: 15px; /* Space around the elements */
        background-color: #f9f9f9; /* Light background for contrast */
        border-radius: 10px; /* Rounded corners */
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); /* Subtle shadow for depth */
        margin-bottom: 20px; /* Space between rows */
        border: 1px solid #dddddd6b;
        transition: box-shadow 0.3s ease; /* Smooth transition for shadow */
    }
    .inforow:hover {
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15); /* More pronounced shadow on hover */
    }

    .product-image {
        height: 120px; /* Fixed height */
        width: 120px; /* Fixed width */
        object-fit: cover; /* Scale image to fill */
        border-radius: 8px; /* Rounded image corners */
        margin-right: 15px; /* Space between image and text */
        border: 1px solid #ccc; /* Light border around image */
        transition: transform 0.2s ease; /* Smooth transition for scale */
    }

    .product-image:hover {
        transform: scale(1.05); /* Slightly enlarge image on hover */
    }

    .product_name {
        flex: 1; /* Take available space */
        font-weight: 600; /* Slightly bolder font */
        font-size: 18px; /* Larger font size */
        color: #333; /* Dark text color */
        margin-right: 20px; /* Space between product name and price */
        text-align: center; /* Center-align text */
    }

    .product_price {
        font-size: 18px; /* Consistent font size */
        font-weight: 500; /* Medium weight */
        color: #6c306af0; /* Attractive color for the price */
        margin-right: 20px; /* Space between price and quantity controls */
        text-align: center; /* Center-align text */
        flex: 1; /* Take available space */
    }

    .productnumber input[type="number"] {
        width: 60px; /* Fixed width */
        text-align: center; /* Center-align the text */
        border: none; /* Remove default border */
        outline: none; /* Remove outline on focus */
        font-size: 16px; /* Consistent font size */
        font-weight: 500; /* Medium weight */
        color: #555; /* Darker text color */
        background-color: transparent; /* Transparent background */
        pointer-events: none; /* Disable manual input */
    }

    .decrbtn {
        border-radius: 0% !important;
        color: #333;
        font-size: 20px;
        cursor: pointer;
        width:23%;
        height:
    }

    .decrbtn:hover {
        background-color: #ddd; /* Darker grey on hover */
        color: #000; /* Darker text on hover */
    }

    .decrbtn:active {
        background-color: #ccc; /* Even darker grey on active */
        transform: scale(0.98); /* Slightly shrink on active */
    }

    @media (max-width: 768px) {
        .inforow {
            flex-direction: column; /* Stack elements vertically on small screens */
            text-align: center; /* Center-align all text */
        }

        .product-image {
            margin-bottom: 10px; /* Space below image */
            margin-right: 0; /* Remove side margin */
        }

        .product_name,
        .product_price {
            margin-right: 0; /* Remove side margin */
            margin-bottom: 10px; /* Space below each text */
        }

        .productnumber {
            justify-content: center; /* Center-align quantity controls */
            margin-bottom: 10px; /* Space below controls */
        }
    }

    /* model changes  */
    .modal-dialog {
        max-width: 900px;
        margin: 1.75rem auto;
    }

    .modal-content {
        border-radius: 2.5rem;
        overflow: hidden;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
        width: 100%;
        padding:5px;
    }

    .modal-header {
        background-color: #f5f5f5;
        border-bottom: 1px solid #dee2e6;
        padding: 1rem;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-header .modal-title {
        font-size: 1.25rem;
        margin: 0;
    }

    .modal-header .close {
        font-size: 1.5rem;
        line-height: 1;
        color: #000;
        text-shadow: none;
        opacity: 0.5;
        cursor: pointer;
    }

    .modal-body {
        padding: 2rem;
        background-color: #fff;
    }

    .calenderbg-outer {
        padding: 12px;
        margin-bottom: 0px;
    }

    div#tab_-1 {
        border-radius: 10px !important;
    }
</style>

<div class="modal-dialog modal-lg w-75" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="productModalLabel"> {{__('lang.product_detail')}}</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <div class="col-lg-12">
                    {!! Form::model(null, ['method' => 'POST', 'url' => ['cart-checkout']]) !!}
                        @csrf
                            @if($product_details)
                                <div class="inforow col-md-12">
                                    <input type="hidden" name="cart_id[]" value="{{$product_details['id']}}">
                                    <input type="hidden" name="product_id" value="{{$product_details['product_id']}}">
                                    <input type="hidden" name="product_minimum_quantity" id="product_min_qty_{{$product_details['product_id']}}" value="{{($product_details['quantity'])}}">
                                    <img src="{{ asset('app-assets/images/products/' . $product_details['product_image']) }}" alt="{{ $product_details['product_name'] }}" style="height:120px !important" />
                                    <span class="product_name col-md-2">{{($product_details['product_name'])}}</span>
                                    <span class="productname product_price col-md-2">{{\Helpers::currency($product_details['total_delivery_amount'])}}</span>
                                    <span class="productnumber col-md-4">
                                        <button data-action="decrement" class="decrbtn" type="button">
                                            <span class="m-auto text-2xl font-thin">−</span>
                                        </button>
                                        <input type="number" name="quantity[]" value="{{ $product_details['quantity'] }}" id="product_quantity" readonly="">
                                        <button data-action="increment" class="decrbtn" type="button">
                                            <span class="m-auto text-2xl font-thin">+</span>
                                        </button>
                                    </span>
                                </div>
                                <div class="calenderbg-outer collapse show" id="tab_{{$product_details['id']}}">
                                    <div class="calenderbg addressform calenderradio">
                                        <div class="calenderradio02 radio row">
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="once_{{$product_details['id']}}" onclick="selectFrequency('once','{{$product_details['id']}}');" name="order_frequency_{{$product_details['id']}}" value="Once" @if($product_details['order_frequency']=='once') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="daily_{{$product_details['id']}}" onclick="selectFrequency('daily','{{$product_details['id']}}');" name="order_frequency_{{$product_details['id']}}" value="Daily"  @if($product_details['order_frequency']=='daily') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="weekly_{{$product_details['id']}}" onclick="selectFrequency('weekly','{{$product_details['id']}}');" name="order_frequency_{{$product_details['id']}}" value="Weekly"  @if($product_details['order_frequency']=='weekly') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="monthly_{{$product_details['id']}}" onclick="selectFrequency('monthly','{{$product_details['id']}}');" name="order_frequency_{{$product_details['id']}}" value="Monthly"  @if($product_details['order_frequency']=='monthly') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="alternative_{{$product_details['id']}}" onclick="selectFrequency('alternative','{{$product_details['id']}}');" name="order_frequency_{{$product_details['id']}}" value="Alternative"  @if($product_details['order_frequency']=='alternative') checked @endif/></span>
                                        </div>
                                        <div class="weeklydays @if($product_details['order_frequency']!='weekly') hide @endif days_option_{{$product_details['id']}}">
                                            <h3>{{__('lang.select_days_for_delivery')}}</h3>
                                            <div class="radio">
                                                <?php
                                                $days = explode(",",$product_details['days']);
                                                ?>
                                                <input type="checkbox" id="days_sun_{{$product_details['id']}}" name="days_{{$product_details['id']}}[sun]" value="S"  @if(in_array(0,$days)) checked @endif/>
                                                <input type="checkbox" id="days_mon_{{$product_details['id']}}" name="days_{{$product_details['id']}}[mon]" value="M"  @if(in_array(1,$days)) checked @endif/>
                                                <input type="checkbox" id="days_tue_{{$product_details['id']}}" name="days_{{$product_details['id']}}[tue]" value="T"  @if(in_array(2,$days)) checked @endif/>
                                                <input type="checkbox" id="days_wed_{{$product_details['id']}}" name="days_{{$product_details['id']}}[wed]" value="W"  @if(in_array(3,$days)) checked @endif/>
                                                <input type="checkbox" id="days_thu_{{$product_details['id']}}" name="days_{{$product_details['id']}}[thu]" value="T"  @if(in_array(4,$days)) checked @endif/>
                                                <input type="checkbox" id="days_fri_{{$product_details['id']}}" name="days_{{$product_details['id']}}[fri]" value="F"  @if(in_array(5,$days)) checked @endif/>
                                                <input type="checkbox" id="days_sat_{{$product_details['id']}}" name="days_{{$product_details['id']}}[sat]" value="S"  @if(in_array(6,$days)) checked @endif/>
                                            </div>
                                        </div>
                                        <div class="quickselection @if($product_details['order_frequency']!='weekly') hide @endif days_option_{{$product_details['id']}}">
                                            <div class="radio">
                                                <span>{{__('lang.quick_selection')}}</span>
                                                <input type="radio" id="weekday_{{$product_details['id']}}" name="quick[]" onclick="selectQuickSelection('WEEKDAYS','{{$product_details['id']}}');" value="{{__('lang.weekdays')}}" />
                                                <input type="radio" id="weekends_{{$product_details['id']}}" name="quick[]" onclick="selectQuickSelection('WEEKENDS','{{$product_details['id']}}');" value="{{__('lang.weekend')}}" />
                                            </div>
                                        </div>
                                        <div class="calenderbox">
                                            <h3>{{__('lang.select_deliver_date')}}</h3>
                                            <?php
                                            $date = $product_details['start_date']. ' - '.$product_details['end_date'];
                                            if($product_details['order_frequency']=='once'){
                                                $date = $product_details['start_date'];
                                            }
                                            if($product_details['order_frequency']=='monthly'){
                                                $date = $product_details['delivery_dates'];
                                            }
                                            ?>
                                            <input type="hidden" class="demo-multi-day" id="delivery_dates_{{$product_details['id']}}" name="delivery_dates[]" value="{{$date}}" required>
                                        </div>
                                    </div>
                                    <?php if($product_details['order_frequency']=='once'){ ?>

                                    <?php }else if($product_details['order_frequency']=='monthly'){ ?>

                                    <?php }else{ ?>

                                    <?php } ?>
                                </div>
                            @endif
                        <div class="cart-total-box calculate">
                            <button class="submit-btn" type="submit" name="submit_button" value="{{__('lang.add_to_cart')}}">{{__('lang.add_to_cart')}} <img src="{{asset('site-assets/images/arrowright.png')}}"/></button>
                        </div>
                    {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
<script>
    var  mobiscrollObj = [];
    var weekDays = '<?php echo json_encode($disabledWeekDays); ?>';
    weekDays = JSON.parse(weekDays);
    var highlightedDates = '<?php echo json_encode($highlightedDates); ?>';
    highlightedDates = JSON.parse(highlightedDates);
    var invalidObj = weekDays;
</script>
<script src="{{ url('site-assets/js/mobiscroll.jquery.min.js') }}"></script>
<link rel="stylesheet" href="{{ url('site-assets/css/mobiscroll.jquery.min.css') }}" />

<script type="text/javascript">
    var currentDate = new Date();
    currentDate.setDate(currentDate.getDate() + nearest_delivery_date);
    mobiscrollObj[<?php echo $product_details['id']; ?>] = mobiscroll.setOptions({
        locale: mobiscroll.localeEn,
    });
    $("#delivery_dates_<?php echo $product_details['id']; ?>")
    .mobiscroll()
    .datepicker({
        controls: ["calendar"],
        invalid: invalidObj,
        colors : highlightedDates,
        display: "inline",
        min: currentDate,
        onInit: function (event, inst) {
            inst.setVal(currentDate, true);
        }
    });
</script>
<script type="text/javascript">
    var currentDate = new Date();
    currentDate.setDate(currentDate.getDate() + nearest_delivery_date);
    mobiscrollObj[<?php echo $product_details['id']; ?>] = mobiscroll.setOptions({
        locale: mobiscroll.localeEn,
    });
    $("#delivery_dates_<?php echo $product_details['id']; ?>")
    .mobiscroll()
    .datepicker({
        controls: ["calendar"],
        invalid: invalidObj,
        marked : highlightedDates,
        display: "inline",
        selectMultiple: true,
        min: currentDate,
        onInit: function (event, inst) {
            inst.setVal(currentDate, true);
        }
    });
</script>
<script type="text/javascript">
    var currentDate = new Date();
    currentDate.setDate(currentDate.getDate() + nearest_delivery_date);
    mobiscrollObj[<?php echo $product_details['id']; ?>] = mobiscroll.setOptions({
        locale: mobiscroll.localeEn,
    });
    $("#delivery_dates_<?php echo $product_details['id']; ?>")
    .mobiscroll()
    .datepicker({
        controls: ["calendar"],
        display: "inline",
        select:'range',
        marked : highlightedDates,
        showRangeLabels: false,
        selectMultiple: true,
        min: currentDate,
        onInit: function (event, inst) {
            inst.setVal(currentDate, true);
        }
    });
</script>
