@extends('layouts.site-app')
@section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>

    <div class="inner-heading">{{__('lang.wallet_title')}}</div>
</section>


<script>
    $(document).on('click', '#start-payment-button-flutterwave', function () {
        // Submit the form
        document.getElementById('payment-form-flutterwave').submit();
    });

    // Add this script to handle redirection after successful payment
    window.addEventListener('message', function (event) {
        // Check if the message is from Flutterwave and contains a success response
        if (event.origin === 'https://checkout.flutterwave.com' && event.data.status === 'successful') {
            // Redirect to your custom URL (order detail page)
            window.location.href = '/wallet';
        }
    });
</script>

<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                @include('partials.site.alert')
                    <div class="chooselocation mt-4 selectlocation">
                        <span><img src="{{asset('site-assets/images/payment-icon.png')}}" /></span>

                        {{__('lang.Payment_method')}}
                    </div>
                    @if(setting('enable_razorpay')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio3" name="payment_method" value="razorpay" onclick="onLinePayment('razorpay')" checked/>
                            <label class="custom-control-label" for="customRadio3"> {{__('lang.pay_using_razorpay')}}</label>
                        </div>
                    @endif
                    @if(setting('enable_stripe')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio5" name="payment_method" value="stripe" onclick="onLinePayment('stripe')"/>
                            <label class="custom-control-label" for="customRadio5"> {{__('lang.pay_using_stripe')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_flutterwave')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio6" name="payment_method" value="flutterwave" onclick="onLinePayment('flutterwave')"/>
                            <label class="custom-control-label" for="customRadio6"> {{__('lang.pay_using_flutterwave')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_paypal')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio7" name="payment_method" value="paypal" onclick="onLinePayment('paypal')"/>
                            <label class="custom-control-label" for="customRadio7"> {{__('lang.pay_using_paypal')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_paytm')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio8" name="payment_method" value="paytm" onclick="onLinePayment('paytm')"/>
                            <label class="custom-control-label" for="customRadio8"> {{__('lang.pay_using_paytm')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_instamojo')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio9" name="payment_method" value="instamojo" onclick="onLinePayment('instamojo')"/>
                            <label class="custom-control-label" for="customRadio9"> {{__('lang.pay_using_instamojo')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_paystack')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio10" name="payment_method" value="paystack" onclick="onLinePayment('paystack')"/>
                            <label class="custom-control-label" for="customRadio10"> {{__('lang.pay_using_paystack')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_phonepe')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio11" name="payment_method" value="phonepe" onclick="onLinePayment('phonepe')"/>
                            <label class="custom-control-label" for="customRadio11"> {{__('lang.pay_using_phonepay')}}</label>
                        </div>
                        @endif

                    <div class="cart-total-box" id="online_payment_div">
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>
                        <form action="{{url('wallet-payment-confirm')}}" method="post">
                        @csrf
                            <script
                                src="https://checkout.razorpay.com/v1/checkout.js"
                                data-key="{{setting('razorpay_key')}}"
                                data-amount="{{$post['amount']*100}}"
                                data-currency="{{ setting('default_currency_code') }}"
                                data-theme.color="#14a1a7",
                                data-button_text = "{{__('lang.pay_now_button')}}"
                                data-button_theme = "submit-btn mt-3"
                            ></script>

                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="razorpay">
                    </form>

                </div>
                <!-- Stripe payment form -->
                <div class="row col-md-12 stripe_payment_form_cls hide">

                    <div class='col-md-12'>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>
                    </div>
                       <form
                            role="form"
                            method="post"
                            class="require-validation"
                            data-cc-on-file="false"
                            data-stripe-publishable-key="pk_test_51OU83NSDapZf0PtL1sTyVVpPPhQtCx1VLy6JcKUtX56uUb785b6omQfNlUEbkT1gCnN55GqERu36GxxpO09g0tZ400kzMBPlZQ"
                            id="payment-forms">
                            <!-- action="{{url('wallet-payment-confirm')}}" -->
                        @csrf

                        <div class='col-md-6'>
                            <div class='form-group required'>
                                <label class='control-label'>{{__('lang.stripe_name_on_card')}}</label> <input
                                    class='form-control' size='4' type='text' name="name" id="name">
                            </div>
                        </div>

                        <div class='col-md-6'>
                            <div class='form-group required'>
                                <label class='control-label'>{{__('lang.stripe_card_number')}}</label> <input
                                    autocomplete='off' class='form-control card-number' size='20'
                                    type='text' name="card_number" id="card_number">
                            </div>
                        </div>


                        <div class='col-md-4'>
                            <div class='form-group cvc required'>
                                <label class='control-label'>{{__('lang.stripe_cvc')}}</label> <input autocomplete='off'
                                    class='form-control card-cvc' placeholder='ex. 311' size='4'
                                    type='text' name="cvv" id="cvv">
                            </div>
                        </div>

                        <div class='col-md-4'>
                            <div class='form-group expiration required'>
                                <label class='control-label'>{{__('lang.stripe_expiration_month')}}</label> <input
                                    class='form-control card-expiry-month' placeholder='MM' size='2'
                                    type='text' name="month" id="month">
                            </div>
                        </div>

                        <div class='col-md-4'>
                            <div class='form-group expiration required'>
                                <label class='control-label'> {{__('lang.stripe_expiration_year')}}</label> <input
                                    class='form-control card-expiry-year' placeholder='YYYY' size='4'
                                    type='text' name="year" id="year">
                            </div>
                        </div>

                        <div class='col-md-12'>
                            <div class='col-md-12 error form-group hide'>
                                <div class='alert-danger alert'>
                                    {{__('lang.stripe_please_correct_the_erros_and_try_again')}}
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="publishable_key" name="publishable_key" value="{{ setting('stripe_key') }}">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="stripe">
                        <input type="hidden" name="amount" value="{{$post['amount']}}">

                        <button class="submit-btn mt-3 full-width-btn" type="button" onclick="addWalletAmount('payment-forms');">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- end here -->

               <!-- Flutterwave payment form -->
                <div class="cart-total-box flutterwave_payment_form_cls hide" style="clear: both;">
                    <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>

                    <form id="payment-form-flutterwave" method="POST" action="{{url('wallet-payment-confirm')}}">
                        @csrf
                        <input type="hidden" name="public_key" value="FLWPUBK_TEST-ca4ed7ffb2347440149d86deb5597779-X" />
                        <input type="hidden" name="redirect_url" value="http://127.0.0.1:8000/orders"/>
                        <input type="hidden" name="customer[email]" value="pawanrajput2909@gmail.com" />
                        <input type="hidden" name="customer[name]" value="Pawan Rajput" />
                        <input type="hidden" name="tx_ref" value="" />
                        <input type="hidden" name="amount" value="{{$post['amount']*100}}" />
                        <input type="hidden" name="currency" value="NGN" />
                        <input type="hidden" name="meta[source]" value="docs-html-test" />
                        <input type="hidden" name="payment_method" id="payment_method" value="flutterwave">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                    </form>
                <button class="submit-btn mt-3 full-width-btn" type="button" id="start-payment-button-flutterwave">{{__('lang.pay_now_button')}}</button>
                </div>
                <!-- End here -->


                <!-- Paypal payment form -->
                <div class="cart-total-box paypal_payment_form_cls hide" style="clear: both;">
                    <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>

                    <form action="{{url('wallet-payment-confirm')}}" method="post">
                        @csrf
                        <input type="hidden" name="payment_method" id="payment_method" value="paypal">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <input type="hidden" name="amount" value="{{$post['amount']*100}}">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                <!-- Paytm payment form -->
                <div class="cart-total-box paytm_payment_form_cls hide" style="clear: both;">
                    <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>

                    <form action="{{url('wallet-payment-confirm')}}" method="post">
                        @csrf
                        <input type="hidden" name="payment_method" id="payment_method" value="paytm">
                        <input type="hidden" name="amount" value="{{$post['amount']*100}}">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                 <!-- Instamojo payment form -->
                <div class="cart-total-box instamojo_payment_form_cls hide" style="clear: both;">
                    <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>

                    <form action="{{url('wallet-payment-confirm')}}" method="post">
                        @csrf
                        <input type="hidden" name="payment_method" id="payment_method" value="instamojo">
                        <input type="hidden" name="amount" value="{{$post['amount']*100}}">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                <!-- Paystack payment form -->
                <div class="cart-total-box paystack_payment_form_cls hide" style="clear: both;">
                    <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>
                    <form action="{{url('wallet-payment-confirm')}}" method="post">
                        @csrf
                        <input type="hidden" name="email" value="">
                        <input type="hidden" name="amount" value="{{$post['amount']*100}}">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <input type="hidden" name="currency" value="{{ setting('default_currency_code') }}">
                        <input type="hidden" name="reference" value="{{ Paystack::genTranxRef() }}">
                        <input type="hidden" name="payment_method" id="payment_method" value="paystack">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->

                <!-- Phonepe payment form -->
                <div class="cart-total-box phonepe_payment_form_cls hide" style="clear: both;">
                    <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>

                    <form action="{{url('wallet-payment-confirm')}}" method="post">
                        @csrf
                        <input type="hidden" name="email" value="pawanrajput2909@gmail.com">
                        <input type="hidden" name="amount" value="{{$post['amount']*100}}">
                        <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="phonepe">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->

            </div>
        </div>
    </div>
</section>

<footer class="footer">
    @include('partials.site.footer')
</footer>

<!-- END: Content-->


<script type="text/javascript">
    function onLinePayment(val) {
        if(val=='razorpay'){
            $("#offline_payment_div").addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#online_payment_div").removeClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='stripe'){
            $('.stripe_payment_form_cls').removeClass("hide");
            $("#offline_payment_div").addClass("hide")
            $("#online_payment_div").addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='flutterwave'){
            $('.flutterwave_payment_form_cls').removeClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='paypal'){
            $('.paypal_payment_form_cls').removeClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='paytm'){
            $('.paytm_payment_form_cls').removeClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='instamojo'){
            $('.instamojo_payment_form_cls').removeClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='paystack'){
            $('.paystack_payment_form_cls').removeClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }else if(val=='phonepe'){
            $('.phonepe_payment_form_cls').removeClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
        }else{
            $("#online_payment_div").addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").removeClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
        }
    }
</script>
<!-- END: Content-->
<script type="text/javascript" src="https://js.stripe.com/v2/"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<style type="text/css">
    .razorpay-payment-button{
        background: #af7ab3;
        color: #fff;
        padding: 0px;
        display: inline-block;
        font-size: 14px;
        font-family: Helvetica-Bold, Helvetica, sans-serif;
        border: none;
        border-radius: 35px;
        height: 60px;
        line-height: 60px;
        padding: 0px 25px;
        width: 100%;
    }
    .razorpay-payment-button:hover {
        background: #06283d;
    }

    .row.col-md-12.stripe_payment_form_cls {
    background: white;
    padding: 15px 10px;
    margin: 10px 0px;
}

 .paymentmethod .custom-control-label::after {
    cursor: pointer!important;
}
</style>

@endsection


