@extends('layouts.site-app')
@section('sitecontent')

<script src="https://checkout.flutterwave.com/v3.js"></script>
<script>
    $(document).on('click', '#start-payment-button-flutterwave', function () {
        // Submit the form
        document.getElementById('payment-form-flutterwave').submit();
    });

    // Add this script to handle redirection after successful payment
    window.addEventListener('message', function (event) {
        // Check if the message is from Flutterwave and contains a success response
        if (event.origin === 'https://checkout.flutterwave.com' && event.data.status === 'successful') {
            // Redirect to your custom URL (order detail page)
            window.location.href = '/order-detail';
        }
    });
</script>

<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.checkout_title')}}</div>
</section>

<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                @include('partials.site.alert')
                <div class="chooselocation selectlocation">
                    <span><img class="chooselocation-img" src="{{asset('site-assets/images/watch-icon.png')}}" /></span>
                    {{__('lang.checout_time_of_delivery')}}
                </div>
                {!! Form::model(null, ['method' => 'POST', 'url' => ['do-place-order']]) !!}
                    @csrf
                    <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                    <input type="hidden" name="timeslot_id" id="timeslot_id" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                    <div class="addressformbg checkgrp">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="addressform">
                                    <div class="row justify-content-end">
                                        <div class="form-group col-md-12">
                                            <div class="radio">
                                                <div class="row">
                                                    @foreach($response['timeslots'] as $timeslot)
                                                        <input type="radio" 
                                                               id="{{$timeslot->name}}" 
                                                               onclick="selectTimeSlot({{$timeslot->id}})" 
                                                               value="{{ $timeslot->name . ' (' . date('h:i A', strtotime($timeslot->from_time)) . ' - ' . date('h:i A', strtotime($timeslot->to_time)) . ')' }}" 
                                                               name="timeslots" 
                                                               checked/>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="chooselocation mt-4 mb-13 selectlocation">
                        <span><img src="{{asset('site-assets/images/payment-icon.png')}}" /></span>
                        {{__('lang.Payment_method')}}
                    </div>

                    <div class="select-address select-address-placeorder paymentmethod">
                        @if(setting('enable_cod')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio1" name="payment_method" value="cash" onclick="onLinePayment('no')" />
                            <label class="custom-control-label" for="customRadio1"> {{__('lang.pay_using_cash_on_delivery')}}</label>
                        </div>
                        @endif

                        @if(setting('enable_wallet')=='1' && $response['total_wallet']>=$total['final_amount'])
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio2" name="payment_method" value="wallet" onclick="onLinePayment('no')"/>
                            <label class="custom-control-label" for="customRadio2"> {{__('lang.pay_using_wallet')}}</label>
                            <a href="{{ url('/wallet') }}" style="font-size: 17px;font-weight: bold;top: 17px;color: #124d71;" target="_blank">{{__('lang.my_balance')}} | {{\Helpers::currency($response['total_wallet'])}}</a>
                        </div>
                        @endif
                      {{--   @if(setting('enable_oppwa')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio3" name="payment_method" value="Oppwa" onclick="onLinePayment('no')"/>
                            <label class="custom-control-label" for="customRadio3"> {{__('lang.pay_using_credit_card')}}</label>
                        </div>
                        @endif --}}
                        @if(setting('enable_razorpay')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio4" name="payment_method" value="razorpay" onclick="onLinePayment('yes')" checked/>
                            <label class="custom-control-label" for="customRadio4"> {{__('lang.pay_using_razorpay')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_stripe')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio5" name="payment_method" value="stripe" onclick="onLinePayment('stripe')"/>
                            <label class="custom-control-label" for="customRadio5"> {{__('lang.pay_using_stripe')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_flutterwave')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio6" name="payment_method" value="flutterwave" onclick="onLinePayment('flutterwave')"/>
                            <label class="custom-control-label" for="customRadio6"> {{__('lang.pay_using_flutterwave')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_paypal')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio7" name="payment_method" value="paypal" onclick="onLinePayment('paypal')"/>
                            <label class="custom-control-label" for="customRadio7"> {{__('lang.pay_using_paypal')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_paytm')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio8" name="payment_method" value="paytm" onclick="onLinePayment('paytm')"/>
                            <label class="custom-control-label" for="customRadio8"> {{__('lang.pay_using_paytm')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_instamojo')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio9" name="payment_method" value="instamojo" onclick="onLinePayment('instamojo')"/>
                            <label class="custom-control-label" for="customRadio9"> {{__('lang.pay_using_instamojo')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_paystack')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio10" name="payment_method" value="paystack" onclick="onLinePayment('paystack')"/>
                            <label class="custom-control-label" for="customRadio10"> {{__('lang.pay_using_paystack')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_phonepe')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio11" name="payment_method" value="phonepe" onclick="onLinePayment('phonepe')"/>
                            <label class="custom-control-label" for="customRadio11"> {{__('lang.pay_using_phonepay')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_liqpay')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio12" name="payment_method" value="liqpay" onclick="onLinePayment('liqpay')"/>
                            <label class="custom-control-label" for="customRadio12"> {{__('lang.pay_using_liqpay')}}</label>
                        </div>
                        @endif

                    </div>

                <!-- offline form -->
                    <div id="offline_payment_div" class="cart-total-box hide">
                        <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>
                        <p>
                            <button class="submit-btn mt-3 full-width-btn" type="submit">{{__('lang.place_order_button')}} &nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                        </p>
                    </div>
                {!! Form::close() !!}

                <!-- End Here -->


                <!-- Razorpay payment form -->
                <div id="online_payment_div" class="cart-total-box" style="clear: both;">
                    <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>
                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <script
                            src="https://checkout.razorpay.com/v1/checkout.js"
                            data-key="{{setting('razorpay_key')}}"
                            data-amount="{{$total['final_amount']*100}}"
                            data-currency="{{ setting('default_currency_code') }}"
                            data-theme.color="#14a1a7",
                            data-button_text = "{{__('lang.place_order_button')}}"
                            data-button_theme = "submit-btn mt-3"
                        ></script>
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="razorpay">
                    </form>
                </div>
                <!-- end here -->

                <!-- Stripe payment form -->
                <div class="row col-md-12 stripe_payment_form_cls hide">
                        <form
                            role="form"
                            method="post"
                            class="require-validation"
                            data-cc-on-file="false"
                            data-url="{{ url('save-token') }}"
                            data-redirection-url="{{ url('orders') }}"
                            data-stripe-publishable-key="pk_test_51OU83NSDapZf0PtL1sTyVVpPPhQtCx1VLy6JcKUtX56uUb785b6omQfNlUEbkT1gCnN55GqERu36GxxpO09g0tZ400kzMBPlZQ"
                            id="payment-forms">
                             {{-- onsubmit="return addOrder('payment-forms');"
                             action="{{url('do-place-order')}}" --}}
                        @csrf
                        <div class='col-md-6'>
                            <div class='form-group required'>
                                <label class='control-label'>Name on Card</label> <input
                                    class='form-control' size='4' name="name" id="name" type='text'>
                            </div>
                        </div>

                        <div class='col-md-6'>
                            <div class='form-group required'>
                                <label class='control-label'>Card Number</label> <input
                                    autocomplete='off' class='form-control card-number' size='20'
                                    type='text' name="card_number" id="card_number">
                            </div>
                        </div>


                        <div class='col-md-4'>
                            <div class='form-group cvc required'>
                                <label class='control-label'>CVC</label> <input autocomplete='off' class='form-control card-cvc' placeholder='ex. 311' size='4' type='text' name="cvv" id="cvv" pattern="^\d{3,4}$">
                            </div>
                        </div>

                        <div class='col-md-4'>
                            <div class='form-group expiration required'>
                                <label class='control-label'>Expiration Month</label> <input
                                    class='form-control card-expiry-month' placeholder='MM' size='2'
                                    type='text' name="month" id="month">
                            </div>
                        </div>

                        <div class='col-md-4'>
                            <div class='form-group expiration required'>
                                <label class='control-label'>Expiration Year</label> <input
                                    class='form-control card-expiry-year' placeholder='YYYY' size='4'
                                    type='text' name="year" id="year">
                            </div>
                        </div>

                        <div class='col-md-12'>
                            <div class='col-md-12 error form-group hide'>
                                <div class='alert-danger alert'>Please correct the errors and try
                                    again.</div>
                            </div>
                        </div>
                        <input type="hidden" id="publishable_key" name="publishable_key" value="{{ setting('stripe_key') }}">
                        <input type="hidden" name="stripe_token" id="stripe_token" value="">
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="stripe">


                        <div class="col-md-4"></div>
                        <div class="col-md-4"></div>
                        <div class="cart-total-box col-md-4" style="clear: both;">
                        <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                        <button class="submit-btn mt-3 full-width-btn" type="button" onclick="addOrder('payment-forms');">{{__('lang.pay_now_button')}}</button>
                        </div>

                    </form>

                </div>
                <!-- end here -->



                <!-- Flutterwave payment form -->
                <div class="cart-total-box flutterwave_payment_form_cls hide" style="clear: both;">
                    <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form id="payment-form-flutterwave" method="POST" action="{{url('do-place-order')}}">
                        @csrf
                        <input type="hidden" name="public_key" value="FLWPUBK_TEST-ca4ed7ffb2347440149d86deb5597779-X" />
                        <input type="hidden" name="redirect_url" value="{{ url('orders') }}"/>
                        <input type="hidden" name="customer_email" value="pawanrajput2909@gmail.com" />
                        <input type="hidden" name="customer_name" value="Pawan Rajput"/>
                        <input type="hidden" name="tx_ref" value="" />
                        <input type="hidden" name="amount" value="{{ $total['final_amount'] }}" />
                        <input type="hidden" name="currency" value="NGN" />
                        <input type="hidden" name="meta[source]" value="docs-html-test"/>
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="flutterwave">
                    </form>
                <button class="submit-btn mt-3 full-width-btn" type="button" id="start-payment-button-flutterwave">{{__('lang.pay_now_button')}}</button>
                </div>
                <!-- End here -->

                <!-- Paypal payment form -->
                <div class="cart-total-box paypal_payment_form_cls hide" style="clear: both;">
                    <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="paypal">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                <!-- Paytm payment form -->
                <div class="cart-total-box paytm_payment_form_cls hide" style="clear: both;">
                    <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="paytm">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                 <!-- Instamojo payment form -->
                <div class="cart-total-box instamojo_payment_form_cls hide" style="clear: both;">
                        <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="instamojo">
                        <input type="hidden" name="amount" value="{{ $total['final_amount'] }}">
                        <input type="hidden" name="customer_email" value="" />
                        <input type="hidden" name="customer_name" value=""/>
                        <input type="hidden" name="phone" value=""/>
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                <!-- Paystack payment form -->
                <div class="cart-total-box paystack_payment_form_cls hide" style="clear: both;">
                        <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <input type="hidden" name="email" value="">

                        <input type="hidden" name="amount" value="{{ $total['final_amount'] }}">

                        <input type="hidden" name="currency" value="{{ setting('default_currency_code') }}">

                        <input type="hidden" name="reference" value="{{ Paystack::genTranxRef() }}">
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="paystack">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                <!-- Phonepe payment form -->
                <div class="cart-total-box phonepe_payment_form_cls hide" style="clear: both;">
                    <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <input type="hidden" name="email" value="pawanrajput2909@gmail.com">
                        <input type="hidden" name="amount" value="{{$total['final_amount']}}">
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="phonepe">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->


                <!-- Liqpay payment form -->
                <div class="cart-total-box liqpay_payment_form_cls hide" style="clear: both;">
                        <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>

                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <input type="hidden" name="description" value="Here is the information of item">

                        <input type="hidden" name="amount" value="{{ $total['final_amount'] }}">

                        <input type="hidden" name="currency" value="{{ setting('default_currency_code') }}">

                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}">
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}">
                        <input type="hidden" name="payment_method" id="payment_method" value="liqpay">
                        <button class="submit-btn mt-3 full-width-btn" type="submit" id="start-payment-button">{{__('lang.pay_now_button')}}</button>
                    </form>
                </div>
                <!-- End here -->

            </div>
        </div>
    </div>
</section>

<footer class="footer">
    @include('partials.site.footer')
</footer>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script type="text/javascript">
    function onLinePayment(val) {
        if(val=='yes'){
            $("#offline_payment_div").addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#online_payment_div").removeClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='stripe'){
            $('.stripe_payment_form_cls').removeClass("hide");
            $("#offline_payment_div").addClass("hide")
            $("#online_payment_div").addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='flutterwave'){
            $('.flutterwave_payment_form_cls').removeClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='paypal'){
            $('.paypal_payment_form_cls').removeClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='paytm'){
            $('.paytm_payment_form_cls').removeClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='instamojo'){
            $('.instamojo_payment_form_cls').removeClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='paystack'){
            $('.paystack_payment_form_cls').removeClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='phonepe'){
            $('.phonepe_payment_form_cls').removeClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }else if(val=='liqpay'){
            $('.liqpay_payment_form_cls').removeClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").addClass("hide");
        }else{
            $("#online_payment_div").addClass("hide");
            $('.stripe_payment_form_cls').addClass("hide");
            $("#offline_payment_div").removeClass("hide");
            $('.flutterwave_payment_form_cls').addClass("hide");
            $('.paypal_payment_form_cls').addClass("hide");
            $('.paytm_payment_form_cls').addClass("hide");
            $('.instamojo_payment_form_cls').addClass("hide");
            $('.paystack_payment_form_cls').addClass("hide");
            $('.phonepe_payment_form_cls').addClass("hide");
            $('.liqpay_payment_form_cls').addClass("hide");
        }
    }
</script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#cvv').on('input', function () {
            let cvv = $(this).val();
            cvv = cvv.replace(/\D/g, ''); // Remove non-numeric characters
            $(this).val(cvv.substring(0, 4)); // Limit to max 4 digits
        });
    });
</script>
<!-- END: Content-->
@endsection
<style type="text/css">
    .razorpay-payment-button{
        background: #af7ab3;
        color: #fff;
        padding: 0px;
        display: inline-block;
        font-size: 14px;
        font-family: Helvetica-Bold, Helvetica, sans-serif;
        border: none;
        border-radius: 35px;
        height: 60px;
        line-height: 60px;
        padding: 0px 25px;
        width: 100%;
    }
    .razorpay-payment-button:hover {
        background: #06283d;
    }

    .row.col-md-12.stripe_payment_form_cls {
    background: white;
    padding: 15px 10px;
    margin: 10px 0px;
}

 .paymentmethod .custom-control-label::after {
    cursor: pointer!important;
}
</style>


