<nav class="navbar navbar-expand-md navbar-light container">
    <a class="navbar-brand" href="{{url('/')}}"><img src="{{asset('site-assets/images/website/')}}/{{setting('website_logo')}}" onerror="this.src='{{asset('uploads/no-logo.png')}}'" style="width: 100px;" /></a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mainnav" aria-controls="mainnav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="mainnav">
        <ul class="navbar-nav ml-auto" style="justify-content: center; width: 100%;">
            <li><a href="{{url('/')}}" class="{{ Request::is('/') ? 'active' : '' }}">{{__('lang.navigation_home')}}</a></li>
            <li><a href="{{url('about')}}" class="{{ Request::is('about') ? 'active' : '' }}">{{__('lang.navigation_about')}}</a></li>
            <li><a href="{{url('contact-us')}}" class="{{ Request::is('contact-us') ? 'active' : '' }}">{{__('lang.navigation_contactus')}}</a></li>
            @auth
            <li class="login-register-tab"><a href="{{url('profile')}}" class="{{ Request::is('profile') ? 'active' : '' }}">{{__('lang.navigation_profile')}}</a></li>
            @endauth
            @guest
            <li class="login-register-tab"><a href="{{url('signin')}}" class="{{ Request::is('signin') ? 'active' : '' }}">{{__('lang.navigation_login_resgister')}}</a></li>
            @endguest
            <li>
                <div class="dropdown mobileshow">
                    <a href="{{url('set-language?lang_code=ar')}}" class="language dropdown-toggle" data-toggle="dropdown"> {{ Config::get('languages')[App::getLocale()] }} </a>
                    <div class="dropdown-menu">
                        @foreach (Config::get('languages') as $lang => $language)
                            @if ($lang != App::getLocale())
                                    <a class="dropdown-item" href="{{url('set-language?lang_code=').$lang}}"> {{$language}}</a>
                            @endif
                        @endforeach
                    </div>
                </div>
            </li>
        </ul>
    </div>
    <div class="header-right">
        @auth
            <a href="{{url('cart')}}" class="btn1"><img src="{{asset('site-assets/images/cart.svg')}}" style="width:21px!important;"/></a> 
            @if(Session()->has('total_cart'))
               @if(Session()->get('total_cart')>0)
               <span class="badge total-cart-count">{{Session()->get('total_cart')}}</span> 
               @endif 
            @endif
            <a href="{{url('profile')}}" class="btn1"><img src="{{asset('site-assets/images/User.svg')}}"/></a>
        @endauth
        @guest
            <a href="{{url('signin')}}" class="btn1"><img src="{{asset('site-assets/images/cart.svg')}}" style="width:21px!important;"/></a> 
            <a href="{{url('signin')}}" class="btn1"><img src="{{asset('site-assets/images/User.svg')}}"/></a>
        @endguest

    </div>
    @php
    $languages = Config::get('languages');
    @endphp

    @if (count($languages) == 1)
        <!-- Show this if there's only one language -->
        <div class="dropdown">
            <a href="javascript:void(0)" class="default_one_language language p-2 ml-1">
                {{ $languages[App::getLocale()] }}
            </a>
        </div>
    @elseif (count($languages) > 1)
        <!-- Show this if there are multiple languages -->
        <div class="dropdown websi">
            <a href="javascript:void(0)" class="language dropdown-toggle" data-toggle="dropdown">
                {{ $languages[App::getLocale()] }}
            </a>
            <div class="dropdown-menu">
                @foreach ($languages as $lang => $language)
                    @if ($lang != App::getLocale())
                        <a class="dropdown-item" href="{{ url('set-language?lang_code=').$lang }}"> {{$language}}</a>
                    @endif
                @endforeach
            </div>
        </div>
    @endif
</nav>
