<button id="scrollToTopBtn" title="Go to top">
    <img src="{{ url('site-assets/images/GotoTop.svg') }}" alt="Go to Top" style="width: 40px; height: 40px;">
</button>

<style>
    #scrollToTopBtn {
        display: none;
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 99;
        border: none;
        outline: none;
        background: transparent;
        cursor: pointer;
        padding: 10px;
        border-radius: 5px;
    }

    #scrollToTopBtn img {
        width: 50px;
        height: 50px;
    }

    #scrollToTopBtn:hover {
        opacity: 0.8;
    }
</style>

<script>
    let scrollToTopBtn = document.getElementById("scrollToTopBtn");

    function checkScroll() {
        if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
            scrollToTopBtn.style.display = "block";
        } else {
            scrollToTopBtn.style.display = "none";
        }
    }

    window.onscroll = checkScroll;
    document.addEventListener("DOMContentLoaded", checkScroll);

    scrollToTopBtn.onclick = function () {
        window.scrollTo({ top: 0, behavior: "smooth" });
    };
</script>


<div class="container">
    <div class="row display-flex mt-60">
        <div class="col-12 col-md-5">
            <div class="phone-icon"><i class="fa fa-phone" aria-hidden="true"></i></div>
            <div class="phone-no">
                <p>{{__('lang.footer_call')}}</p>
                <a href="tel:{{setting('contact_support_phone')}}"><h4>{{setting('contact_support_phone')}}</h4></a>
            </div>
        </div>
        <?php
        $cmsData = App\Models\CmsPages::where('status','1')->get();
        ?>
        <div class="col-12 col-md-2">
            <h6 class="company-title pl-20">{{__('lang.page_company')}}</h6>
            <ul class="company-ul pl-20">


            @if(count($cmsData))
            @foreach ($cmsData as $page)
                @if($page->page_name == 'about')
                   <li style="line-height: 35px;"><a href="{{url('about')}}"> {{__('lang.page_about')}}</a></li>
                @endif
            @endforeach

            @foreach ($cmsData as $page)
                @if($page->page_name == 'policy')
                <li style="line-height: 35px;"><a href="{{url('privacy-policy')}}" style="line-height: 20px;">{{__('lang.page_privacy_policy')}}</a></li>
                @endif
            @endforeach

            @foreach ($cmsData as $page)
                @if($page->page_name == 'terms')
                <li style="line-height: 35px;"><a href="{{url('term-and-conditions')}}" style="line-height: 20px;">{{__('lang.page_term_and_condition')}}</a></li>
              @endif
            @endforeach
            @endif

                <li style="line-height: 35px;"><a href="{{url('contact-us')}}" style="line-height: 20px;">{{__('lang.page_contact_us')}}</a></li>
            </ul>
        </div>
        <div class="col-12 col-md-5 color-white">
            <p class="footer-description">
                <?php echo __('lang.footer_aboutus'); ?>
            </p>
        </div>
    </div>
    <hr class="hr-design">
    <div class="container">
        <div class="row footer-bottom">
            <div class="col-md-6 col-6 text-align-left">
                <h5>{{ __('lang.footer_copyright') }} {{ date('Y') }}</h5>
            </div>
            <div class="col-md-6 col-6">
                <div class="social-icon-layout">
                    <a href="{{setting('snapchat_url')}}" target="_blank" class="social-icons"><i class="fa fa-snapchat-ghost"></i></a>
                    <a href="{{setting('pinterest_url')}}" target="_blank" class="social-icons"><i class="fa fa-pinterest-p" aria-hidden="true"></i></a>
                    <a href="{{setting('instagram_url')}}" target="_blank" class="social-icons"><i class="fa fa-instagram" aria-hidden="true"></i></a>
                    <a href="{{setting('twitter_url')}}" target="_blank" class="social-icons"><i class="fa fa-twitter" aria-hidden="true"></i></a>
                    <a href="{{setting('facebook_url')}}" target="_blank" class="social-icons"><i class="fa fa-facebook" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{asset('site-assets/js/popper.min.js')}}"></script>
<script src="{{asset('site-assets/js/bootstrap.min.js')}}"></script>
<script src="{{asset('site-assets/js/owl.carousel.js')}}"></script>
<script id="main_script" src="{{asset('site-assets/js/scripts.js')}}"></script>
<script>
    $(document).ready(function () {
        if(document.getElementById('owl-carousel')){
            var owl = $(".owl-carousel");
            owl.owlCarousel({
                margin: 0,
                nav: true,
                loop: false,
                responsive: {
                    0: {
                        items: 1,
                    },
                    600: {
                        items: 2,
                    },
                    1000: {
                        items: 4,
                    },
                },
            });
        }
    });
    $('input').on('paste', function () {
        return;
    });

    $('#owl-carousel1').owlCarousel({
        loop: true,
        margin: 0,
        dots: true,
        nav: true,
        items: 5,
    })
    $('#owl-carousel2').owlCarousel({
        loop: true,
        margin: 0,
        dots: true,
        nav: true,
        items: 5,
    })
</script>

