<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_menu_orders_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_order_id')}}</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_order_status')}}</th>
                                <th>{{__('lang.admin_amount')}}</th>
                                <th>{{__('lang.admin_method')}}</th>
                                <th>{{__('lang.admin_payment_status')}}</th>
                                <th>{{__('lang.admin_date')}}</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td><a title="Order Detail" href="{{ route('orders.show', $res->id)}}" style="color:#14a1a7;">#{{$res->id}}</a></td>
                                <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
                                <td>{{ isset($res->order_status) ? $res->order_status->status : '--' }}</td>
                                <td>{{ isset($res->final_amount) ? \Helpers::currency($res->final_amount) : '--' }}</td>
                                @if(isset($res->payment_method) && $res->payment_method=='cash')
                                <td>{{__('lang.payment_method_cash')}}</td>
                                @else
                                <td style="text-transform: capitalize;">{{ isset($res->payment_method) ? $res->payment_method : '--' }}</td>
                                @endif
                                <td>
                                    @if(isset($res->payment_method))
                                        @if($res->payment_method=='cash')
                                            @if(isset($res->payment))
                                                <?php echo \Helpers::showPaymentStatus($res->payment->status) ?>
                                            @else
                                            --
                                            @endif
                                        @else
                                            @if(isset($res->payment))
                                                <?php echo \Helpers::showPaymentStatus($res->payment->status) ?>
                                            @else
                                            --
                                            @endif
                                        @endif
                                    @else
                                        --
                                    @endif
                                </td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>

                                @canany(['update-order', 'delete-order','detail-order'])
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('detail-order')
                                            <a class="dropdown-item" href="{{ route('orders.show', $res->id) }}">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span>{{__('lang.admin_button_detail')}}</span>
                                            </a>
                                            @endcan

                                            @can('update-order')
                                            <a class="dropdown-item" href="{{ route('orders.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            @endcan

                                            @can('delete-order')
                                                <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('order-list' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                                </a>
                                            @endcan
                                        </div>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>
