<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_order_delivery_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_order_id')}}</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_product_name')}}</th>
                                <th>{{__('lang.admin_order_quantity')}}</th>
                                <th>{{__('lang.admin_total_amnt')}}</th>
                                <th>{{__('lang.admin_delivery_status')}}</th>
                                <th>{{__('lang.admin_order_delivery_date')}}</th>
                                <th>{{__('lang.admin_order_date')}}</th>

                                @can('update-order-status')
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcan
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td><a title="Order Detail" href="{{ route('orders.show', $res->order_id)}}" target="_blank">#{{$res->order_id}}</a></td>
                                <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
                                <td><a title="Product Detail" href="{{ route('products.edit', $res->product_id)}}" target="_blank">{{($res->product_orders)?($res->product_orders->product)?$res->product_orders->product->name:'--':'--'}}</a></td>
                                <td>{{ isset($res->product_orders) ? $res->product_orders->quantity : '--' }}</td>
                                <td>{{ isset($res->product_orders) ? \Helpers::currency($res->product_orders->total_delivery_amount) : '--' }}</td>
                                <td>{{ isset($res->delivery_status) ? $res->delivery_status->status : '--' }}</td>
                                <td>{{ isset($res->delivery_date) ? \Helpers::commonDateFormate($res->delivery_date) : '--' }}</td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>

                                @can('update-order-status')
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('orders.show', $res->id) }}">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span>{{__('lang.admin_button_detail')}}</span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                                @endcan
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="9" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>