@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<style type="text/css">
    span.select2-selection__placeholder {
        float: inline-start;
    }

    span#select2-search_order_by_user_id-container {
        float: inline-start;
    }

    span#select2-search_order_by_product_order_id-container {
        float: inline-start;
    }

    span.select2-selection__placeholder {
        float: inline-start;
    }

    span#select2-search_order_by_driver_id-container {
        float: inline-start;
    }
</style>

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_revenue')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_revenue_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons">
                    <form id="formData" method="get">
                        <div class="row">

                            <div class="col-md-12 row">

                                <div class="col-md-4">
                                        <input type="text" class="form-control" name="order_id" @if(isset($_GET['order_id'])) value="{{$_GET['order_id']}}" @endif placeholder="{{__('lang.admin_order_id')}}">
                                </div>
                                <div class="col-md-4">
                                    <input type="text" name="order_delivery_date" class="form-control flatpickr-basic" placeholder="{{__('lang.admin_order_delivery_date')}}" id="order_delivery_date" @if(isset($_GET['order_delivery_date'])) value="{{$_GET['order_delivery_date']}}" @endif>
                                </div>
                                <div class="col-md-4">
                                        <input type="text" name="date_filter" class="form-control flat-picker" placeholder="{{__('lang.admin_order_date')}}" id="reportrange" @if(isset($_GET['date_filter'])) value="{{$_GET['date_filter']}}" @endif>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <select class="form-select" name="order_status_id" id="search_order_by_status">
                                        <option value="">{{__('lang.admin_delivery_status')}}</option>
                                        @foreach($filter['order_status'] as $status)
                                            <option value="{{$status->id}}" @if(isset($_GET['order_status_id'])) @if($_GET['order_status_id']==$status->id) selected @endif @endif>{{$status->status}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <select class="form-select" name="user_id" id="search_order_by_user_id" style="width: -webkit-fill-available">
                                        <option value="">{{__('lang.admin_select_user')}}</option>
                                        @foreach($filter['user'] as $user)
                                            <option value="{{$user->id}}" @if(isset($_GET['user_id'])) @if($_GET['user_id']==$user->id) selected @endif @endif>{{$user->phone}} @if($user->name!='' || $user->name!=null)({{$user->name}})@endif</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <select class="form-select" name="product_order_id" id="search_order_by_product_order_id" style="width: -webkit-fill-available">
                                        <option value="">{{__('lang.admin_select_user')}}</option>
                                        @foreach($filter['products'] as $product)
                                            <option value="{{$product->id}}" @if(isset($_GET['product_order_id'])) @if($_GET['product_order_id']==$product->id) selected @endif @endif>@if($product->name!='' || $product->name!=null){{$product->name}}@endif</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <select class="form-select" name="driver_id" id="search_order_by_driver_id" style="width: -webkit-fill-available">
                                        <option value="">{{__('lang.admin_select_user')}}</option>
                                        @foreach($filter['drivers'] as $user)
                                            <option value="{{$user->id}}" @if(isset($_GET['driver_id'])) @if($_GET['driver_id']==$user->id) selected @endif @endif>{{$user->phone}} @if($user->name!='' || $user->name!=null)({{$user->name}})@endif</option>
                                        @endforeach
                                    </select>
                                </div>
                                 <div class="col-md-4 mt-2">
                                    <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                    <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                                    <div class="btn-group">
                                        <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i data-feather="download"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <a class="dropdown-item" href="{{ url('admin/export-revenue-to-excel') }}">Excel</a>
                                            <a class="dropdown-item" href="{{ url('admin/export-revenue-to-pdf') }}">Pdf</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @include('orders.revenue_table')
        </div>
    </div>
</div>

<script type="text/javascript">
    var basicPickr = $('.flatpickr-basic');
    basicPickr.flatpickr();
</script>

<!-- Select2 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
<script>
  $("#search_order_by_user_id").select2({
      placeholder: "{{__('lang.admin_select_user')}}",
      allowClear: true
  });
</script>
<script>
  $("#search_order_by_product_order_id").select2({
      placeholder: "{{__('lang.admin_select_product')}}",
      allowClear: true
  });
</script>

<script>
  $("#search_order_by_driver_id").select2({
      placeholder: "{{__('lang.admin_select_driver')}}",
      allowClear: true
  });
</script>


<script type="text/javascript">
    var flatPicker = $(".flat-picker");
    var date = new Date();
    flatPicker.each(function () {
        $(this).flatpickr({
            mode: "range"
        });
    });
</script>

<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<!-- END: Content-->
@endsection
