<div class="card card-employee-task">
    <div class="card-header">
        <h4 class="card-title">{{__('lang.admin_order_info')}}</h4>
    </div>
    <div class="card-body">
        <div class="transaction-item">
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title">{{__('lang.admin_order')}} #:</h6>
                    <small>{{isset($data->id) ? $data->id : '--'}}</small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title">{{__('lang.admin_order_date')}}:</h6>
                    <small>{{isset($data->created_at) ? \Helpers::commonDateTimeFormate($data->created_at) : '--'}}</small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title">{{__('lang.admin_amount')}}:</h6>
                    <small>{{isset($data->final_amount) ? \Helpers::currency($data->final_amount) : '--'}}</small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title">{{__('lang.admin_payment_method')}}:</h6>
                    <small>
                        @if(isset($data->payment_method))
                            @if($data->payment_method == 'cash')
                                {{__('lang.payment_method_cash')}}
                            @else
                                {{ $data->payment_method }}
                            @endif
                        @else
                            --
                        @endif
                    </small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title">{{__('lang.admin_timeslot')}}:</h6>
                    <small>@if(isset($data->time_slots)) <b>{{$data->time_slots->name}}</b> {{date('h:i A',strtotime($data->time_slots->from_time))}} - {{date('h:i A',strtotime($data->time_slots->to_time))}} @endif</small>
                </div>
            </div>
        </div>
    </div>
</div>
