<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_menu_orders_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_order_id')}}</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_request_status')}}</th>
                                <th>{{__('lang.admin_refund_amnt')}}</th>
                                <!-- <th>{{__('lang.admin_refund_status')}}</th> -->
                                <th>{{__('lang.admin_payment_status')}}</th>
                                <th>{{__('lang.admin_request_date')}}</th>
                                 @can('update-order-status')
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcan
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res) @if($res->order)
                            <tr>
                                <td><a title="Order Detail" href="{{ route('orders.show', $res->order_id)}}" target="_blank">#{{$res->order_id}}</a></td>
                                <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
                                <td>
                                    @if($res->status == 1)
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-success me-1">{{__('lang.admin_approved')}}</span>
                                        </a>
                                    @elseif($res->status == 2)
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-danger me-1">{{__('lang.admin_declined')}}</span>
                                        </a>
                                    @else
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_pending')}}</span>
                                        </a>
                                    @endif
                                </td>
                                <td>{{ isset($res->refund_amount) ? \Helpers::currency($res->refund_amount) : '--' }}</td>
                                <!-- <td>
                                    @if($res->refund_status == 1)
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-success me-1">{{__('lang.admin_refunded')}}</span>
                                        </a>
                                    @else
                                        @if($res->order->payment_method=='cash')
                                            --
                                        @else
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_not_yet')}}</span>
                                        </a>
                                        @endif
                                    @endif
                                </td> -->
                                <td>
                                     @if($res->order->payment_method=='cash')
                                    <a href="javascript:;">
                                        <span class="badge rounded-pill badge-light-info me-1">{{__('lang.admin_cash_on_delivery')}}</span>
                                    </a>
                                    @else
                                    <a href="javascript:;">
                                        <span class="badge rounded-pill badge-light-success me-1">{{__('lang.admin_online')}}</span>
                                    </a>
                                    @endif
                                </td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                @can('update-order-status')
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @if($res->status != 1)
                                            <a class="dropdown-item" href="{{ url('admin/approved-order-request/'.$res->id) }}">
                                                <i data-feather="check" class="me-50"></i>
                                                <span>{{__('lang.admin_approved')}}</span>
                                            </a>
                                            @endif
                                            @if($res->status != 2)
                                            <a class="dropdown-item" href="{{ url('admin/declined-order-request/'.$res->id) }}">
                                                <i data-feather="x" class="me-50"></i>
                                                <span>{{__('lang.admin_declined')}}</span>
                                            </a>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                @endcan
                            </tr>
                            @endif
                            @endforeach
                            @else
                            <tr>
                                <td colspan="10" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>