@extends('layouts.app')
@section('content')

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<style type="text/css">
    span.select2-selection__placeholder {
        float: inline-start;
    }

    span#select2-search_order_by_user_id-container {
        float: inline-start;
    }
</style>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_order_cancel_request')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a></li>
                                <li class="breadcrumb-item active">{{__('lang.admin_request_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons text-end">
                    <form id="formData" method="get">
                        <div class="row">
                            

                              <div class="col-md-12 row">

                                    <div class="form-group col-md-4">
                                        <select class="form-select" name="status" id="status">
                                            <option value="">{{__('lang.admin_cancel_status')}}</option>
                                            <option value="0">{{__('lang.admin_pending')}}</option>
                                            <option value="1">{{__('lang.admin_approved')}}</option>
                                            <option value="2">{{__('lang.admin_declined')}}</option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-4">
                                        <select class="form-select" name="user_id" id="search_order_by_user_id" style="width: -webkit-fill-available">
                                            <option value="">{{__('lang.admin_select_user')}}</option>
                                            @foreach($filter['user'] as $user)
                                                <option value="{{$user->id}}" @if(isset($_GET['user_id'])) @if($_GET['user_id']==$user->id) selected @endif @endif>{{$user->phone}} @if($user->name!='' || $user->name!=null)({{$user->name}})@endif</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-md-4">
                                        <select class="form-select" name="payment_method" id="search_order_by_payment_method">
                                            <option value="">{{__('lang.admin_payment_method')}}</option>
                                            @foreach($filter['payment_methods'] as $paymentMethod)
                                                <option value="{{$paymentMethod}}" @if(isset($_GET['payment_method']) && $_GET['payment_method'] == $paymentMethod) selected @endif>{{ucfirst($paymentMethod)}}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-md-4 mt-2">
                                        <input type="text" class="form-control" name="order_id" @if(isset($_GET['order_id'])) value="{{$_GET['order_id']}}" @endif placeholder="{{__('lang.admin_order_id')}}">
                                    </div>

                                    <div class="form-group col-md-4 mt-2">
                                        <input type="text" name="date_filter" class="form-control flat-picker" placeholder="{{__('lang.admin_order_date')}}" id="reportrange" @if(isset($_GET['date_filter'])) value="{{$_GET['date_filter']}}" @endif>
                                    </div>
                            

                                    <div class="form-group col-md-4 mt-2">
                                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                                    </div> 

                            </div>

                        </div>
                    </form>
                </div>
            </div>
            @include('orders.cancelrequest.table')
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- Select2 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
<script>
  $("#search_order_by_user_id").select2({
      placeholder: "{{__('lang.admin_select_user')}}",
      allowClear: true
  });
</script>

<script type="text/javascript">
    var flatPicker = $(".flat-picker");
    var date = new Date();
    flatPicker.each(function () {
        $(this).flatpickr({
            mode: "range"
        });
    });
</script>
@endsection