@extends('layouts.site-app')

@section('sitecontent')

<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.my_order_title')}}</div>
</section>
<section class="youracc-bg">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                @include('partials.site.user-links')
            </div>
            <div class="col-md-6">
                @if(Session::has('message'))
                <div class="row">
                    <div class="col-lg-12">
                        <div class="alert alert-success" role="alert">
                          {{ Session::get('message') }}
                        </div>
                    </div>
                </div>
                @endif
                @if(Session::has('error'))
                <div class="row">
                    <div class="col-lg-12">
                        <div class="alert alert-danger" role="alert">
                          {{ Session::get('error') }}
                        </div>
                    </div>
                </div>
                @endif
                <div class="order-tracking-bg">
                    <div class="order-tracking order-tracking-bg">
                        <ul>
                            <li class="active">
                                <span><img src="{{asset('site-assets/images/icon-store.png')}}"  /></span>
                                <h4>{{__('lang.your_order_received')}}</h4>
                                <p>
                                    {{\Helpers::commonDateFormate($data->updated_at)}} <br />
                                    {{\Helpers::commonTimeFormate($data->updated_at)}}
                                </p>
                            </li>
                            <li class="middle-li-margin middle-option">
                                <span class="pt-23"><img src="{{asset('site-assets/images/icon-delivery.png')}}"  /></span>
                                <h4>{{__('lang.your_order_on_the_way')}}</h4>
                            </li>
                            <li>
                                <span class="pt-23"><img src="{{asset('site-assets/images/path.png')}}"  /></span>
                                <h4>{{__('lang.your_order_delivered')}}</h4>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="delvery-details">
                    <ul>
                        <li>
                            <h4>{{__('lang.your_order_delivery_address')}}</h4>
                            @if($data->delivery_address)
                                @if($data->delivery_address->address!='') {{$data->delivery_address->address}}, @endif {{$data->delivery_address->zipcode}} ,  @if($data->delivery_address->city!='') {{$data->delivery_address->city}}, @endif  @if($data->delivery_address->state!='') {{$data->delivery_address->state}}, @endif
                            <br>
                            {{__('lang.note')}} {{$data->delivery_address->note}}
                            @else
                            --
                            @endif
                        </li>
                        <li>
                            <h4>{{__('lang.phone')}}</h4>
                            {{$data->user->phone}}
                        </li>
                        <li>
                            <h4>{{__('lang.your_order_delivery_time')}}</h4>
                            @if(isset($data->time_slots)) <b>{{$data->time_slots->name}}</b> {{date('h:i A',strtotime($data->time_slots->from_time))}} - {{date('h:i A',strtotime($data->time_slots->to_time))}} @endif
                        </li>
                        <li>
                            <h4>{{__('lang.Payment_method')}}</h4>
                            @if($data->payment_method == 'cash')
                                {{__('lang.payment_method_cash')}}
                            @else
                                {{$data->payment_method}}
                            @endif
                            
                        </li>
                        @if($data->payment_status==1)
                            @if($data->payment_method=='razorpay')
                                <li>
                                @foreach($transection as $key => $value)
                                    <h4>{{$key}}</h4>
                                   {{ $value}}
                                @endforeach
                                </li>

                            @else
                                <li>
                                    <h4>{{__('lang.payment_transaction_id')}}</h4>
                                    {{$data->payment_transection_id}}
                                </li>
                            @endif

                        @endif
                        <li style="padding: 8px 0px 22px;">
                           <h4>{{__('lang.order_payment_status')}}</h4>
                            @if($data->payment_status==1 || $data->payment_status==0 && $data->payment_method=='cash')
                                <p><span class="badge text-bg-success btn payment-badge"> {{__('lang.payment_success')}}</span></p>
                            @else
                                <p><span class="badge text-bg-warning btn payment-badge">{{__('lang.payment_failed_or_cancelled')}}</span></p>
                            @endif
                        </li>
                        <li>
                            <h4>{{__('lang.your_order_time')}}</h4>
                            {{\Helpers::commonDateTimeFormate($data->created_at)}}
                        </li>
                    </ul>
                </div>
                <div class="order-tracking-table" style="border-bottom: solid 1px #e1e6eb;">
                    <div class="col-md-12" style="display: flex;padding-left: 0px;padding-right: 0px;line-height: 1;">
                        <div class="col-md-6 text-align-left" style="padding-left: 0px;padding-right: 0px;">
                            <p style="color: #748a9d;font-size: 20px;">{{__('lang.sub_total')}}</p>
                        </div>
                        <div class="col-md-6 text-align-right" style="padding-left: 0px;padding-right: 0px;">
                            <p style="color: #748a9d;font-size: 20px;">{{\Helpers::currency($data->subtotal)}}</p>
                        </div>
                    </div>
                    <div class="col-md-12" style="display: flex;padding-left: 0px;padding-right: 0px;line-height: 1;">
                        <div class="col-md-6 text-align-left" style="padding-left: 0px;padding-right: 0px;">
                            <p style="color: #748a9d;font-size: 20px;">{{__('lang.vat')}}</p>
                        </div>
                        <div class="col-md-6 text-align-right" style="padding-left: 0px;padding-right: 0px;">
                            <p style="color: #748a9d;font-size: 20px;">{{\Helpers::currency($data->tax)}}</p>
                        </div>
                    </div>
                    <div class="col-md-12" style="display: flex;padding-left: 0px;padding-right: 0px;line-height: 1;">
                        <div class="col-md-6 text-align-left" style="padding-left: 0px;padding-right: 0px;">
                            <p style="margin-bottom: 10px;color: #748a9d;font-size: 20px;">{{__('lang.delivery')}}</p>
                        </div>
                        <div class="col-md-6 text-align-right" style="padding-left: 0px;padding-right: 0px;">
                            @if($data->delivery_fee>0)
                                <p style="margin-bottom: 10px;color: #748a9d;font-size: 20px;">{{\Helpers::currency($data->delivery_fee)}}</p>
                            @else
                                <p style="margin-bottom: 10px;color: #748a9d;font-size: 20px;">{{__('lang.standard_free_delivery')}}</p>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="order-tracking-table" style="border-bottom: solid 1px #e1e6eb;">
                    <div class="col-md-12" style="display: flex;padding-left: 0px;padding-right: 0px;line-height: 1;padding-top: 15px;">
                        <div class="col-md-6 text-align-left" style="padding-left: 0px;padding-right: 0px;">
                            <p style="color: #748a9d;font-size: 20px;">{{__('lang.coupon_discount')}}</p>
                        </div>
                        <div class="col-md-6 text-align-right" style="padding-left: 0px;padding-right: 0px;">
                            <p style="font-weight: bold;color: #06283d;font-size: 20px;">-{{\Helpers::currency($data->promotional_disount)}}</p>
                        </div>
                    </div>
                </div>
                <div class="order-tracking-table">
                    <div class="col-md-12" style="display: flex;padding-left: 0px;padding-right: 0px;line-height: 1;padding-top: 15px;">
                        <div class="col-md-6 text-align-left" style="padding-left: 0px;padding-right: 0px;">
                            <h1 style="font-weight: bold;color:#06283d;">{{__('lang.total')}}</h1>
                        </div>
                        <div class="col-md-6 text-align-right" style="padding-left: 0px;padding-right: 0px;">
                            <h1 style="font-weight: bold;color:#06283d;">{{\Helpers::currency($data->final_amount)}}</h1>
                        </div>
                    </div>
                </div>
                <!-- 
                <?php
                $allow = 0;
                ?>
                @if(count($data->delivered_products)>0)
                @foreach($data->delivered_products as $delivery)
                <?php
                if((strtotime($delivery['date'])>strtotime(date("Y-m-d H:i:s")))){
                    $allow = 1;
                }
                ?>
                <div class="item-status">
                    <div class="item-status-left">
                        <h6>{{__('lang.items')}}</h6>
                    </div>
                    <div class="item-status-right">
                        <h6>{{__('lang.status')}}</h6>
                    </div>
                    @foreach($delivery['data'] as $product)
                        <div class="item-status-left">
                            <p>{{($product->product_orders)?($product->product_orders->product)?$product->product_orders->product->name:'--':'--'}}: x {{($product->product_orders)?$product->product_orders->quantity:'--'}}</p>
                        </div>
                        <div class="item-status-right">
                            <p>{{($product->delivery_status)?$product->delivery_status->status:'--'}}</p>
                        </div>
                    @endforeach
                    <div class="item-status-left" style="margin-top:10px;">
                        <p><b>{{__('lang.date')}}</b> {{\Helpers::commonDateFormate($delivery['date'])}}</p>
                    </div>
                    <div class="item-status-right">
                    </div>
                </div>
                @endforeach
                @endif-->
                @if($data->payment_status==1 || $data->payment_status==0 && $data->payment_method=='cash')
                    @if($data->cancel_request)
                        <div class="savebtn pl-0">
                            @if($data->cancel_request->status==0)
                                <p class="btn btn-secondary">{{__('lang.cancel_request_already_submited')}}</p>
                            @elseif($data->cancel_request->status==2)
                                <p class="btn btn-danger">{{__('lang.cancel_request_declined_by_admin')}}</p>
                            @elseif($data->cancel_request->status==1 && $data->cancel_request->refund_status==1)
                                @if($data->payment_method!='cash')
                                    <p class="btn btn-success">{{__('lang.cancel_request_approved_and_refunded')}}</p>
                                @else
                                    <p class="btn btn-success">{{__('lang.cancel_request_approved')}}</p>
                                @endif
                            @elseif($data->cancel_request->status==1 && $data->cancel_request->refund_status==0)
                                @if($data->payment_method!='cash')
                                    <p class="btn btn-info">{{__('lang.cancel_request_approved')}}</p>
                                @else
                                    <p class="btn btn-success">{{__('lang.cancel_request_approved')}}</p>
                                @endif
                            @endif
                        </div>
                    @elseif(!$allow)
                    <div class="savebtn pl-0">
                        <p class="btn btn-danger">{{__('lang.cancel_request_not_allowed')}}</p>
                    </div>
                    @else
                    <div class="savebtn pl-0">
                        <a href="#" onclick="showDeleteConfirmation('{{__('lang.are_you_sure_you_want_to_cancel_order')}}', '{{ $data->id }}');">{{__('lang.cancel_order')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></a>
                    </div>
                    @endif
                    @if($data->payment_method !='cash')
                        <div class="alert alert-warning" role="alert">
                        Note: If you cancel your order, a refund will be issued to your wallet.
                        </div>
                    @endif
                @endif


            </div>
            <div class="col-md-3">
                <div class="itemno">
                    <h5>{{__('lang.no_of_items')}} 
                        @if(count($data->product_orders) > 0)
                        {{count($data->product_orders)}} 
                        @else
                        1
                        @endif
                        {{__('lang.items')}}
                    </h5>
                    @foreach($data->product_orders as $productInfo)
                    <div class="itemno-details">
                        <div class="itemno-details-left">
                            <img src="{{asset('app-assets/images/products/'.$productInfo->product->image)}}" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';" />
                            <p>{{$productInfo->product->name}}</p>
                            <p>{{__('lang.order_qty')}} {{$productInfo->quantity}}</p>
                        </div>
                        <div class="itemno-details-right">
                            <h6 style="text-transform:capitalize;direction: rtl; unicode-bidi: plaintext;">({{$productInfo->order_frequency}})
                            </h6>

                            @if($productInfo->order_frequency!='once')
                            <p>
                                {{__('lang.start_date')}}
                                @if(isset($productInfo->start_date))
                                    {{\Helpers::commonDateFormate($productInfo->start_date)}}
                                @else
                                    @if(isset($productInfo->product_deliverys[0]))
                                        {{\Helpers::commonDateFormate($productInfo->product_deliverys[0]->delivery_date)}}
                                    @else
                                        --
                                    @endif
                                @endif
                            </p>
                            <p>
                                {{__('lang.end_date')}}
                                @if(isset($productInfo->end_date))
                                    {{\Helpers::commonDateFormate($productInfo->end_date)}}
                                @else
                                    @if($productInfo->product_deliverys)
                                        @if(isset($productInfo->product_deliverys[count($productInfo->product_deliverys)-1]))
                                            {{\Helpers::commonDateFormate($productInfo->product_deliverys[count($productInfo->product_deliverys)-1]->delivery_date)}}
                                        @else
                                            --
                                        @endif
                                    @else
                                        --
                                    @endif
                                @endif
                            </p>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
<style type="text/css">
    .item-status-right p {
        margin: 0;
    }
</style>
<footer class="footer">
    @include('partials.site.footer')
</footer>
<!-- END: Content-->

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
    function showDeleteConfirmation(message, itemId) {
        Swal.fire({
            title: "{{__('lang.admin_swal_are_you_sure')}}",
            text: message,
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "{{__('lang.admin_swal_yes_delete_it')}}",
            cancelButtonText: "{{ __('lang.admin_swal_cancel') }}",
            customClass: {
                confirmButton: 'swal-confirm-button-class'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // If confirmed, redirect to the specified URL with the item ID
                window.location.href = "{{ url('/cancel-order-request/') }}" + '/' + itemId;
            }
        });
    }
</script>

<style type="text/css">
.swal-confirm-button-class {
        background-color: #14a1a7 !important; /* Set the desired background color */
    }
</style>
@endsection
