<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Firebase Notification Test</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1>Firebase Notification Test</h1>
        <p>Enter the details below to send a notification:</p>
        <form id="notification-form" action="{{ route('send-notification') }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="tokens">Device Tokens (comma-separated)</label>
                <textarea id="tokens" name="tokens" class="form-control" placeholder="Device Tokens" required></textarea>
            </div>
            <div class="form-group">
                <label for="title">Title</label>
                <input type="text" id="title" name="title" class="form-control" placeholder="Notification Title" required>
            </div>
            <div class="form-group">
                <label for="body">Body</label>
                <textarea id="body" name="body" class="form-control" placeholder="Notification Body" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Send Notification</button>
        </form>
    </div>
    <!-- The core Firebase JS SDK is always required and must be listed first -->

    <script type="module">
        // Import the functions you need from the SDKs you need
        import { initializeApp } from 'https://www.gstatic.com/firebasejs/9.6.1/firebase-app.js';
        import { getMessaging, getToken, onMessage } from 'https://www.gstatic.com/firebasejs/9.6.1/firebase-messaging.js';

        // Your Firebase configuration
        const firebaseConfig = {
            apiKey: "AIzaSyDao-0vGmqN5jVJHpCkmD9QxZKAtpkWAbw",
            authDomain: "waterapp-787d2.firebaseapp.com",
            projectId: "waterapp-787d2",
            storageBucket: "waterapp-787d2.appspot.com",
            messagingSenderId: "10036061486",
            appId: "1:10036061486:web:76eeec80a2c2adefb646bf",
            measurementId: "G-2QBZN8387C"
        };

        // Initialize Firebase
        const app = initializeApp(firebaseConfig);
        const messaging = getMessaging(app);

        // Request permission and get token
        async function requestPermissionAndGetToken() {
            try {
                const permission = await Notification.requestPermission();
                if (permission === 'granted') {
                    console.log('Notification permission granted.');
                    const token = await getToken(messaging, { vapidKey: 'BC5Qg6Fn4TsndZHUTkdGcKeAhaxu4orGlM8oOFJscO0_hjLcsnSaOnW6pxqmLxuiLf4eHbjriOSjABv-tJaOmzw' });
                    if (token) {
                        save_token(token);
                        // You can send this token to your server for storing
                    } else {
                        console.log('No registration token available. Request permission to generate one.');
                    }
                } else {
                    console.log('Unable to get permission to notify.');
                }
            } catch (error) {
                console.error('An error occurred while retrieving token.', error);
            }
        }
        function save_token(token){
            let xhr = new XMLHttpRequest();
            xhr.open("post", "{{ route('fcmToken') }}");

            xhr.setRequestHeader("Content-Type", "application/json");

            xhr.onload = () => console.log(xhr.responseText);

            let data = {
            token: token,
            "_token": "{{ csrf_token() }}"
            };
            xhr.send(JSON.stringify(data));
        }

        requestPermissionAndGetToken();

        // // Handle incoming messages
        // onMessage(messaging, (payload) => {
        //     console.log('Message received. ', payload);
        //     const notificationTitle = payload.notification.title;
        //     const notificationOptions = {
        //         body: payload.notification.body,
        //         icon: '/app-assets/images/users/20240422132320.jpg'
        //     };
        //     new Notification(notificationTitle, notificationOptions);
        // });

        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('/firebase-messaging-sw.js')
            .then((registration) => {
                console.log('Service Worker registered with scope:', registration.scope);
            })
            .catch((err) => {
                console.error('Service Worker registration failed:', err);
            });
}
    </script>

</body>
</html>
